print_string `***** Hi! You're going to load a tool to emulate`; 
print_newline() ;
print_string `***** Pen & Paper proof style in HOL` ; print_newline() ;
print_newline() ;
print_string `***** I hope you enjoy them.` ; print_newline() ;
print_string `+++++ Wishnu Prasetya` ; print_newline() ;
print_string `+++++ wishnu@cs.ruu.nl` ; print_newline() ;
print_string `+++++ Comp. Science, Utrecht University` ; print_newline() ;
print_string `+++++ the Netherlands` ; print_newline() ;;

letref proof_space = []:((string#thm#string)list) ;;
letref asm_space = []:(string list) ;;
letref cur_lemma = (`Jade`,"T",`JaDe Hint`) ;;
letrec mPROOF_SPACE ps =
    if ps = [] then (print_newline() ; ())
    else let (label,thm,hint).qs = ps in
        (print_newline() ;
         print_string label; print_string ` :  ` ; print_newline() ;
         print_string `(* `; print_string hint; 
         print_string ` *)` ; print_newline() ;
         print_string `    `; print_thm thm ; print_newline() ;
           mPROOF_SPACE qs) ;;

let (PROOF_SPACE:void->void) () =
    print_newline () ; mPROOF_SPACE proof_space ;;
letrec mRECALL (label:string) ps =
    if ps=[] then failwith `Label not found!`
    else let (lab,thm,hint).qs = ps in
    if label=lab  then thm
    else mRECALL label qs ;;

let RECALL (label:string) = mRECALL label proof_space ;;
let GEN_RECALL (label:string) = GEN_ALL (DISCH_ALL (RECALL label)) ;;
letrec mASSUMPTIONS ps =
    if ps = [] then print_newline()
    else let label.qs = ps in
         print_string label ; print_string ` :  ` ;
         print_term (concl (RECALL label)) ; print_newline() ;
         mASSUMPTIONS qs ;;

let (ASSUMPTIONS:void->void) () =
    print_newline () ; mASSUMPTIONS asm_space ;;
let Set_Assumptions asml =
    proof_space := map (\(a:string,b). (a,ASSUME b,`Assumption`)) asml ;
    asm_space := (map fst asml) ;
    ASSUMPTIONS() ;
    () ;;
let LEMMA ((label:string),lemma,hint,tac) =
    let thm = TAC_PROOF((map (concl o RECALL) asm_space,lemma),tac) in
    ( proof_space := append proof_space [(label,thm,hint)] ;
      print_newline() ;
      print_string label ; print_string ` : ` ; 
      print_thm thm ; print_newline()) ;;
let (LU:void->void) () = 
   if proof_space = [] then failwith `Proof Space is EMPTY!`
   else (proof_space := butlast proof_space  ; PROOF_SPACE()) ;;
let Lg (label,lemma,hint) = 
    let goal = (map (concl o RECALL) asm_space,lemma) in
    cur_lemma := (label,lemma,hint) ; set_goal goal ;;
let Le tac =
    e tac ;
    (let (label,thm,hint) = cur_lemma in
     if concl(top_thm()) = thm then
        (proof_space := append proof_space [(label,top_thm(),hint)];
        PROOF_SPACE())
     else 
        (print_newline() ;
         print_string `BUT` ; print_newline() ; 
         print_string 
         `Theorem proven is not the current lemma!` ;
         print_newline ())
    ) ? () ;;

letref derivation = ([]:(term # term # thm # string) list) ;;
letref rel_in_der = "jade:*" ;;
letref rel_list = ([]:(term#thm) list) ;;
letref cur_expr = ("T","T", "T",`jade`) ;;
letrec mTRANS_LIST t =
    if t=[] then print_newline() 
    else let (rel,rel_trans).s = t in
       (print_newline() ;
        print_string ` `; print_term rel ; print_string ` : ` ;
        print_newline() ; print_string `  ` ;
        print_thm rel_trans ;  
        print_newline() ;
        mTRANS_LIST s) ;;

let (TRANS_LIST:void->void) () =
    print_newline() ;
    print_string `Transitive Relations used:` ; print_newline();
    mTRANS_LIST (rev rel_list) ;
    print_newline() ;;
let ADD_TRANS (rel:term,rel_trans:thm) =
    rel_list := (rel,rel_trans).rel_list ;
    TRANS_LIST() ;;

let (UNDO_TRANS:void->void) () =
    if rel_list=[] then () else
       (rel_list := tl rel_list ; TRANS_LIST()) ;;
letrec mGET_TRANS (rel:term) phi =
    if (phi=[]) then failwith `the relation is NOT in the rel_list!`
    else let (relx,thm).s = phi in
         if rel=relx then thm
         else mGET_TRANS rel s ;;

let GET_TRANS (rel:term) = mGET_TRANS rel rel_list ;;
letrec mDERIVATION deriv =
    if deriv=[] then (print_newline() ; ())
    else ( let (rel,expr,th,comment).tail = deriv in
           print_newline () ;
           print_string ` ` ; print_term rel ; 
           print_string ` (*`; print_string comment; print_string `*)`;
           print_newline () ; print_newline() ;
           print_string `    ` ; print_term expr ; print_newline() ;
           mDERIVATION tail) ;;
       
let (DERIVATION:void->void) () = mDERIVATION (rev derivation) ;;
let BD (rel:term) (expr:term) = 
    derivation := 
       [("Derivation:*",expr, 
        prove("^expr =  ^expr", REWRITE_TAC[]),
        ` `)] ;
    rel_in_der := rel ;
    print_newline() ; print_string `Assumptions:` ;
    ASSUMPTIONS() ;
    print_string `Relation under Consideration : ` ;
    print_term rel ; print_newline() ;
    print_string `Begin Expression: ` ;
    print_term expr ; print_newline() ;;
let DERIVE (rel,expr,comment,tac) =
    if derivation = [] then 
       failwith `Derivation must be initialized first!`
    else let (rel0, expr0,th0,cm) = hd derivation in
         let thm =
         TAC_PROOF 
           ((map (concl o RECALL) asm_space,
             mk_comb (mk_comb(rel,expr0),expr)),
             tac) in
         ( derivation := (rel,expr,thm,comment).derivation ;
           print_newline();
           print_thm thm ; print_newline(); ()) ;;
let (DU:void->void) () = 
    derivation := tl derivation ; DERIVATION() ;;
letrec mETD t =
   if t=[] then failwith `Derivation is EMPTY!`
   else let (rel,p,thm,cm1).s = t in
   if s=[] then failwith `Derivation contains only begin expression!`
   else let (relx,pn,thmx,cm2).s0 = s in
   if s0=[] then (pn,thm) 
   else
      let (p0,last_thm) = mETD s in
      let thm_now = 
          (CONV_RULE (RAND_CONV (REWRITE_CONV thm)) last_thm ?
           MATCH_MP (GET_TRANS rel_in_der) (CONJ last_thm thm) ?
           CONV_RULE (RATOR_CONV (RAND_CONV (REWRITE_CONV (SYM last_thm))))
                      thm) in
      (p0,thm_now) ;;

let (ETD:void->thm) () = snd(mETD derivation) ;;
let Dg (rel,expr,comment) =
    if derivation = [] then 
       failwith `Derivation must be initialized first!`
    else let (rel0, expr0, th0,cm) = hd derivation in
         let goal = (map (concl o RECALL) asm_space, 
                     mk_comb (mk_comb(rel,expr0),expr)) in
         cur_expr := (rel,expr,snd goal,comment) ;
         set_goal goal ;;
let De tac =
    e tac ;
    (let (rel,expr,thm,comment) = cur_expr in
     if concl(top_thm()) = thm then
        (derivation := (rel,expr,top_thm(),comment).derivation ;
        DERIVATION())
     else
        (print_newline() ;
         print_string `BUT` ; print_newline() ; 
         print_string 
         `Theorem proven is not what the current derivation step expects!` ;
         print_newline ())
    ) ? () ;;
