(****************************************************************************)
(*                                                                          *)
(*                  Copyright 1995 University of Cambridge                  *)
(*                                                                          *)
(*                           All rights reserved.                           *)
(*                                                                          *)
(****************************************************************************)

(****************************************************************************)
(* FILE          : syn_tree_util.sml                                        *)
(* DESCRIPTION   : Functions for use with Syntax Trees.                     *)
(*                                                                          *)
(* AUTHOR        : R.J.Boulton                                              *)
(* DATE          : 23rd August 1995                                         *)
(*                                                                          *)
(* LAST MODIFIED : R.J.Boulton                                              *)
(* DATE          : 23rd August 1995                                         *)
(****************************************************************************)

local
   open Portable SynTreeAST
in

structure SynTreeUtil =
struct

exception ExtractFromSynTree;

fun extract_meta_variable (Tree (TreeMeta s)) = s
  | extract_meta_variable _ = raise ExtractFromSynTree;

fun extract_production (Node (name,subtrees)) =
   (name,map extract_meta_variable subtrees)
  | extract_production _ = raise ExtractFromSynTree;

end; (* SynTreeUtil *)

end;
