(****************************************************************************)
(*                                                                          *)
(*               Copyright 1995, 1996 University of Cambridge               *)
(*                  Copyright 1998 University of Edinburgh                  *)
(*                                                                          *)
(*                           All rights reserved.                           *)
(*                                                                          *)
(****************************************************************************)

(****************************************************************************)
(* FILE          : runtime.sml                                              *)
(* DESCRIPTION   : Support code required for generated embeddings.          *)
(*                                                                          *)
(* AUTHOR        : R.J.Boulton                                              *)
(* DATE          : 13th July 1995                                           *)
(*                                                                          *)
(* LAST MODIFIED : R.J.Boulton                                              *)
(* DATE          : 19th February 1998                                       *)
(****************************************************************************)

(* Lexical support *)

val _ = use (claret_dir ^ "/runtime/naturals.sml");
val _ = use (claret_dir ^ "/runtime/rationals.sml");
val _ = use (claret_dir ^ "/runtime/lex_support.sml");

(* Parsing support *)

(* The ML-Yacc base code is already present in HOL.
val _ = use (claret_dir ^ "/runtime/mlyacc/base.sml");
*)

(* Pretty-printing support *)

val _ = use (claret_dir ^ "/runtime/portable.sig");
val _ = use (claret_dir ^ "/runtime/portable.sml");
val _ = use (claret_dir ^ "/runtime/mlpretty/prettyp/ppboxes.sig");
val _ = use (claret_dir ^ "/runtime/mlpretty/prettyp/ppboxes.sml");
structure PrettyPrint = Compiler.PrettyPrint;
val _ = use (claret_dir ^ "/runtime/mlpretty/prettyp/ppboxes_sml-nj.sml");
val _ = use (claret_dir ^ "/runtime/mlpretty/prettyp/ppout.sml");
val _ = use (claret_dir ^ "/runtime/mlpretty/pretty.support.sml");

(* HOL support *)

val _ = use (claret_dir ^ "/runtime/hol_type_support.sml");

val _ = use (claret_dir ^ "/runtime/hol/hol.pp.support.sml");
val _ = use (claret_dir ^ "/runtime/hol/hol.pp.sml");
val _ = use (claret_dir ^ "/runtime/hol/hol.pp.extend.sml");
