(****************************************************************************)
(*                                                                          *)
(*            Copyright 1994, 1995, 1996 University of Cambridge            *)
(*                  Copyright 1998 University of Edinburgh                  *)
(*                                                                          *)
(*                           All rights reserved.                           *)
(*                                                                          *)
(****************************************************************************)

(****************************************************************************)
(* FILE          : hol.pp.extend.sml                                        *)
(* DESCRIPTION   : Extending the HOL pretty-printer.                        *)
(*                                                                          *)
(* AUTHOR        : R.J.Boulton                                              *)
(* DATE          : 4th May 1994                                             *)
(*                                                                          *)
(* LAST MODIFIED : R.J.Boulton                                              *)
(* DATE          : 19th February 1998                                       *)
(****************************************************************************)

structure ExtensibleHOLPP =
struct

structure HOLPP = HOLPP;

local

val pp_term_ref
       : (HOLPPDestructors.branch list PrettySupport.string_table ->
          {depth:int, outer_prec:PrettySupport.precedence} ->
          {context:string} ->
          term * HOLPPDestructors.branch list ->
          HOLPPDestructors.branch list HOLPP.PP.LabelPPBoxes.ppbox) ref =
   ref (fn _ => fn _ => fn _ => fn _ => HOLPP.PP.pp_empty_box);

fun initial_pp_type st internals params tr =
   HOLPP.pp_type st internals params tr (initial_pp_type,!pp_term_ref)
and initial_pp_term st internals params tr =
   HOLPP.pp_term st internals params tr (initial_pp_type,!pp_term_ref);

val _ = pp_term_ref := initial_pp_term;

in

fun pp_term st internals params tr = (!pp_term_ref) st internals params tr;

fun extend_pp_term print_fun =
   let val old_pp_term = !pp_term_ref
       fun new_pp_term st internals params tr =
          let fun pp_term st internals params tr =
                 (!pp_term_ref) st internals params tr
          in  print_fun pp_term st internals params tr
              handle _ => old_pp_term st internals params tr
          end
   in  pp_term_ref := new_pp_term
   end;

fun reset_pp_term () = (pp_term_ref := initial_pp_term);

fun print_term st =
   pp_term st
      {outer_prec = HOLPP.initial_precedence,depth = HOLPP.initial_depth}
      HOLPP.initial_params;

end;

end; (* ExtensibleHOLPP *)
