
;;;
;;; Short name for compile-vocabulary
;;;
(defun cv ()
  (interactive)
  (compile-vocabulary)
)

;;;
;;; Compile a vocabulary for source file or a directory being edited.
;;; Compile as source file if the buffer is linked to a file, otherwise
;;; assume that we are editing a directory using dired (may not be true)
;;;
(defun compile-vocabulary ()
  (if (buffer-is-file) 
      (compile-vocabulary-source) 
    (compile-vocabulary-filenames))
)

;;;
;;; Compile a vocabulary of file names contained in the directory 
;;; currently being edited with dired. 
;;;
;;; Ask the user if he wants to compile file names for all subdirectories
;;; as well.
;;;
(defun compile-vocabulary-filenames ()
  (setq compile-subdirectories (read-input "Compile subdirectories\(y/n\)? "))
  (message (concat "compile-subdirectories is " compile-subdirectories))
  (if (string-equal compile-subdirectories "y") 
      (compile-vocabulary-tree)
    (compile-vocabulary-directory))
)


(defun compile-vocabulary-source ()
  (interactive)
  (setq file-name (buffer-file-name))
  (setq command (concat "$VCHOME/vocCompile.pl " file-name))
  (message (concat "Compiling vocabulary ..."))
  (shell-command command)
  (message (concat "Vocabulary compiled and ready for loading."))
)

(defun compile-vocabulary-tree ()
  (interactive)
  (setq dir-name (dired-current-directory))
  (setq command (concat "$VCHOME/vocCompile.pl -ot " dir-name))
  (message (concat "Compiling vocabulary ..."))
  (shell-command command)
  (message (concat "Vocabulary compiled and ready for loading."))
)

(defun compile-vocabulary-directory ()
  (setq dir-name (dired-current-directory))
  (setq command (concat "$VCHOME/vocCompile.pl -od " dir-name))
  (message (concat "Compiling vocabulary ..."))
  (shell-command command)
  (message (concat "Vocabulary compiled and ready for loading."))
)
(defun cvd ()
  (interactive)
  (compile-vocabulary-directory)
)


(defun fn ()
  (interactive)
  (setq file-name (buffer-file-name))
  (setq base-buffer (buffer-base-buffer))
  (setq buf-name (buffer-name))
  (message (concat "buffer name: " buf-name " file name: " file-name " base" base-buffer))  
)

(defun dn ()
  (interactive)
  (setq dir-name (dired-current-directory))
	(message (concat "directory name: " dir-name))
)

(defun tst ()
  (interactive)
  (if (buffer-is-file) (message "is file!") (message "is NOT file!"))
)
(defun buffer-is-file ()
  (if buffer-file-name t nil)
)