#!/usr/local/bin/perl5 

print "============ Regression test on VoiceCode vocabulary compiler ===========\n\n\n";

print "*** Tests Started at: ".`date`."\n";

$compilerName = '$VCHOME/vocCompile.pl';
$testDataDir = '$VCHOME/Benchmark/TestData/';
$testNum = 1;


DoTest("$compilerName $testDataDir/Perl/benchmark.pl", $testNum);
$testNum++;

DoTest("$compilerName -lperl $testDataDir/Perl/benchmark.pl", $testNum);
$testNum++;

DoTest("$compilerName -lC $testDataDir/Cpp/benchmark.cpp", $testNum);
$testNum++;

DoTest("$compilerName -lperl -cl $testDataDir/Perl/benchmark.pl", $testNum);
$testNum++;

DoTest("$compilerName -lC -cl $testDataDir/Cpp/benchmark.cpp", $testNum);
$testNum++;

DoTest("$compilerName $testDataDir/Cpp/benchmark.cpp", $testNum);
$testNum++;

DoTest("$compilerName $testDataDir/Perl/benchmark.pl", $testNum);
$testNum++;

DoTest("$compilerName $testDataDir/", $testNum);
$testNum++;

DoTest("$compilerName -lunix -od $testDataDir/", $testNum);
$testNum++;

DoTest("$compilerName -op $testDataDir/testProject.prj", $testNum);
$testNum++;

print "\n\n*** Tests ended at: ".`date`."\n";

sub DoTest {
    local ($command) = @_;

    print "\n\n==========================================================\n";
    print "Test Number: $testNum\n";
    print "Command: $command\n";
    print "==========================================================\n\n\n";
    $result = `$command`;
    print $result;
    print "\n\nVocabulary created:\n";
    $command = "cat \$VCHOME/Load/new.ddx";
    print `$command`;
}
