; Dragondictate utilities for emacs v. 0.8
; Written by Thomas Rene Nielsen (trn@imada.ou.dk)
; Notice that this is not the final version

(setq word-pad-frame nil)
(setq word-pad-list nil)
(setq word-pad-filename nil)

;(setq word-pad-default-filename "c:/utils/emacs-19.34/default.pad")
(setq word-pad-default-filename "~/speciale/default.pad")

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; frame coordinates and size
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(setq word-pad-frame-coor '((left . 678)))
(setq word-pad-frame-size '((width . 35)(height . 40)))


(add-hook 'mouse-1-down-hook 'word-pad-mouse-action)


(defun insert-word-pad ()
  "Inserts the word at cursor in word-pad if 'word' is not there."
  (interactive)
  ;(backward-word 1)
  (start-of-word)
  (if (member major-mode lisp-modes)
      (while (looking-at-num -1 "-")
	(backward-word 1)))
  (if (member major-mode c-modes)
      (while (looking-at-num -1 "_")
	(backward-word 1)))  

  (let ((start-pos (point)))
    (forward-word 1)
    (if (member major-mode lisp-modes)
	(while (looking-at "-")
	  (forward-word 1)))
    (if (member major-mode c-modes)
	(while (looking-at "_")
	  (forward-word 1)))
    (let ((end-pos (point)))
      (let ((word (buffer-substring start-pos end-pos)))

      (if (and (not (member word word-pad-list)) (> (length word) 0))
	  (setq word-pad-list (append word-pad-list (list word)))))))

      (if (frame-live-p word-pad-frame)
	(open-word-pad2))
)


(defun delete-word-pad ()
  "Deletes the word at cursor in word-pad."
  (interactive)
  (backward-word 1)
  (if (member major-mode lisp-modes)
      (while (looking-at-num -1 "-")
	(backward-word 1)))
  (if (member major-mode c-modes)
      (while (looking-at-num -1 "_")
	(backward-word 1)))  
  
  (let ((start-pos (point)))
    (forward-word 1)
    (if (member major-mode lisp-modes)
	(while (looking-at "-")
	  (forward-word 1)))
    (if (member major-mode c-modes)
	(while (looking-at "_")
	  (forward-word 1)))
    (let ((end-pos (point)))
      (let ((word (buffer-substring start-pos end-pos)))

	(setq word-pad-list (delete word word-pad-list)))))

    (if (frame-live-p word-pad-frame)
	(open-word-pad2))
  )
  

(defun show-word-pad ()
  "This function shows the word pad."
  (let ((temp word-pad-list))
    (while (not (atom temp))
      (insert (car temp))
      (newline 1)
      (setq temp (cdr temp))))
  (sort-lines nil (point-min) (point-max))
)


(defun open-word-pad ()
  "Opens the fast selection word pad. 
Call again to close."
  (interactive)
  (if (frame-live-p word-pad-frame)
      (progn (delete-frame word-pad-frame)
	     (kill-buffer "Word Pad"))
     (progn (setq word-pad-frame (make-frame (append word-pad-frame-coor word-pad-frame-size '((name . "Click to copy")(minibuffer . nil)(menu-bar-lines . 0)(visibility . nil)))))
   ; (progn (setq word-pad-frame (make-frame '((name . "Click to copy")(left . 678)(width . 50)(height . 12)(top . 202)(minibuffer . nil)(menu-bar-lines . 0)(visibility . nil))))
     (open-word-pad2)))
)


(defun open-word-pad2 ()
  "Call open-word-pad2 to refresh the word-pad."
  (interactive)
  (let ((this-frame (selected-frame))) 
    (select-frame word-pad-frame)
    (switch-to-buffer "Word Pad")
    (setq buffer-read-only nil)
    (erase-buffer)
    (if (string-equal nil word-pad-filename)
	(get-word-pad word-pad-default-filename))
    (show-word-pad)
    (setq buffer-read-only t)
    (modify-frame-parameters word-pad-frame '((visibility . t)))
    (set-mouse-position word-pad-frame 10 5)
    (select-frame this-frame))
)


(defun word-pad-mouse-action ()
  "Tests if the mouse has clicked in the 'word-pad' frame and copies word
to kill-ring."
  (if (and (frame-live-p word-pad-frame) (eq word-pad-frame (selected-frame)))
      (progn (goto-char (position-of-mouse))
	     (beginning-of-line)
	     (let ((start-pos (point)))
	       (end-of-line)
	       (let ((end-pos (point)))
		 (copy-region-as-kill start-pos end-pos)))))
)

(defun save-word-pad ()
  "Saves the current word-pad."
  (interactive)
  (save-excursion (let ((temp-buf (get-buffer-create "buffer i/o")))
		    (set-buffer temp-buf)
		    (show-word-pad)
		    (save-buffer)
		    (kill-buffer temp-buf)))
  )


(defun clear-word-pad ()
  "Clears the word-pad."
  (interactive)
  (setq word-pad-list nil)

  (if (frame-live-p word-pad-frame)
	(open-word-pad2))
  )


(defun get-word-pad (filename)
  (save-excursion (let ((temp-buf (get-buffer-create "buffer i/o")))
		    (set-buffer temp-buf)
		    (insert-file-contents filename)
		    (setq word-pad-list nil)
		    (goto-char (point-min))
		    (while (< (point) (point-max))
		      (let ((end-pos (get-end-pos)))
			(setq word-pad-list (append word-pad-list (get-word-pad-word))))
		      (forward-line 1))
		    (setq word-pad-filename filename)
		    (kill-buffer temp-buf)))
  )



(defun get-word-pad-word ()
  (beginning-of-line)
  (let ((start-pos (point)))
    (while (not (looking-at "[\n]"))
      (forward-char 1))
    (list (buffer-substring start-pos (point))))
  )


(defun load-word-pad (filename)
  (interactive "FWord pad filename : ")
  (if (string-equal nil filename)
      (setq filename word-pad-default-filename))
  (get-word-pad filename)
  (open-word-pad)
  )
  

(defun go-word-pad ()
  "Jumps to the word-pad frame."
  (interactive)
  (activate-frame word-pad-frame)
  )
