; Dragondictate utilities for emacs v. 0.8
; Written by Thomas Rene Nielsen (trn@imada.ou.dk)
; Notice that this is not the final version

(setq undo-filename "~/speciale/undo.dat")
;(setq undo-filename "d:/emacs-19.34/undo.dat")

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; These lines moves the help from 'ctrl-h' to 'meta-h'. 
(global-set-key "\M-h" 'help-command)
(global-set-key "\M-ha" 'command-apropos)
(global-set-key "\M-hb" 'describe-bindings)
(global-set-key "\M-hc" 'describe-key-briefly)
(global-set-key "\M-hf" 'describe-function)
(global-set-key "\M-h\M-f" 'Info-goto-emacs-command-node)
(global-set-key "\M-hF" 'view-emacs-FAQ)
(global-set-key "\M-hi" 'info)
(global-set-key "\M-hk" 'describe-key)
(global-set-key "\M-h\M-k" 'Info-goto-emacs-key-command-node)
(global-set-key "\M-hl" 'view-lossage)
(global-set-key "\M-hm" 'describe-mode)
(global-set-key "\M-hn" 'view-emacs-news)
(global-set-key "\M-hp" 'finder-by-keyword)
(global-set-key "\M-hs" 'describe-syntax)
(global-set-key "\M-ht" 'help-with-tutorial)
(global-set-key "\M-hv" 'describe-variable)
(global-set-key "\M-hw" 'where-is)
(global-set-key "\M-h\M-h" 'help-for-help)
(global-set-key "\M-h\M-c" 'describe-copying)
(global-set-key "\M-h\M-d" 'describe-distribution)
(global-set-key "\M-h\M-n" 'view-emacs-news)
(global-set-key "\M-h\M-p" 'describe-project)
(global-set-key "\M-h\M-w" 'describe-no-warranty)
(global-unset-key "\C-h")
(global-unset-key "\C-ha")
(global-unset-key "\C-hb")
(global-unset-key "\C-hc")
(global-unset-key "\C-hf")
(global-unset-key "\C-h\C-f")
(global-unset-key "\C-hF")
(global-unset-key "\C-hi")
(global-unset-key "\C-hk")
(global-unset-key "\C-h\M-k")
(global-unset-key "\C-hl")
(global-unset-key "\C-hm")
(global-unset-key "\C-hn")
(global-unset-key "\C-hp")
(global-unset-key "\C-hs")
(global-unset-key "\C-ht")
(global-unset-key "\C-hv")
(global-unset-key "\C-hw")
(global-unset-key "\C-h\C-h")
(global-unset-key "\C-h\C-c")
(global-unset-key "\C-h\C-d")
(global-unset-key "\C-h\C-n")
(global-unset-key "\C-h\C-p")
(global-unset-key "\C-h\C-w")

;(global-set-key [backspace] 'undo-dragondictate)
(global-set-key "\C-h" 'undo-dragondictate)

(setq undo-flag nil)
(setq undo-list nil)

(add-hook 'pre-command-hook 'reset-undo-flag)


; this one is used to reset the undo-flag, but only if present command,
; isn't part of undo sequence.
(defun reset-undo-flag ()
  (if (not (equal this-command 'undo-dragondictate))
      (setq undo-flag nil))
  )

     
(defun undo-dragondictate ()
  "The undo is called if emacs receives backspace characters, which means
that dragonditate is undoing a speech command.
Undo examines the last command run and if a function (not simply a word),
 makes a lookup in the  file 'undo.dat'. This file holds a list of
function - undo-function pairs. Runs the undo function, if present. If no undo
function is present, the EMACS undo wil be run. 
Will undo repeated runs of functions too, by looking at pre-arg."
  (interactive)
  (if (not (equal last-command 'undo-dragondictate))
      (let ((undo-command (assoc (symbol-name last-command) undo-list)))
	(if undo-command
	    (progn (if (equal (car (car command-history)) last-command)
	    ; if this is an extended command, then get arg from command-history
		       (if (cdr (car command-history))
					;any arg ?
			   (funcall (intern (car (cdr undo-command)))
				    (car (cdr (car command-history))))
			 (if (cdr (cdr undo-command))
					; is there a arg ?
			     (funcall (intern (car (cdr undo-command)))
					      (string-to-number(cdr (cdr undo-command))))
			   (funcall (intern (car (cdr undo-command))))))
		     (if (cdr (cdr undo-command))
					; is there a arg ?
			 (funcall (intern (car (cdr undo-command))) (string-to-number(cdr (cdr undo-command))))
		       (funcall (intern (car (cdr undo-command))))))
		   (setq undo-flag t))
	  (if (equal last-command 'self-insert-command)
	      (backward-delete-char-untabify 1)
	    (undo 1))))
    (if (not undo-flag)
	(backward-delete-char-untabify 1)))
  ) 


(defun get-undo-list ()
  (interactive)
  (let ((this-buffer (current-buffer)))
    (switch-to-buffer "undo file list")
    (erase-buffer)
    (insert-file-contents undo-filename)
    (setq undo-list nil)
    (goto-char (point-min))
    (while (< (point) (point-max))
      (let ((end-pos (get-end-pos)))
	(beginning-of-line)
	(if (not (looking-at "[\;]"))
	    (progn (if (search-forward ":" end-pos t)
		       (progn (beginning-of-line)
			      (let ((temp-string nil))
				(setq temp-string (get-undo-word))
				(setq test temp-string)
				(forward-char 2)
				(setq undo-list (append undo-list (list(cons temp-string (cons (get-undo-word) (get-undo-arg))))))))))))
      (forward-line 1))
    (switch-to-buffer this-buffer))
  (kill-buffer "undo file list")
  )


(defun get-undo-word ()
  (interactive)
  (let ((word nil))
    (while (not (looking-at "[ \n\:]"))
      (if (not (looking-at "[\t]"))
	  (setq word (concat word (char-to-string(char-after (point))))))
      (forward-char 1))
    word)
  )


(defun get-undo-arg ()
  (if (looking-at "[ ]")
      (forward-char))
  (get-undo-word)
  )


; collect the undo list
(get-undo-list)


;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; specific undo-functions
;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defun undo-right-5 (arg)
  "Used for undoing some commands. Moves cursor 5 chars to the right,
and erases 'arg' chars to the left, from there."
  (interactive)
  (forward-char 5)
  (backward-delete-char arg)
  )


(defun undo-right-4 (arg)
  "Used for undoing some commands. Moves cursor 4 chars to the right,
and erases 'arg' chars to the left, from there."
  (interactive)
  (forward-char 4)
  (backward-delete-char arg)
  )


(defun undo-right-3 (arg)
  "Used for undoing some commands. Moves cursor 3 chars to the right,
and erases 'arg' chars to the left, from there."
  (interactive)
  (forward-char 3)
  (backward-delete-char arg)
  )


(defun undo-right-2 (arg)
  "Used for undoing some commands. Moves cursor 2 chars to the right,
and erases 'arg' chars to the left, from there."(interactive)
  (forward-char 2)
  (backward-delete-char arg)
  )


(defun undo-right-1 (arg)
   "Used for undoing some commands. Moves cursor 1 char to the right,
and erases 'arg' chars to the left, from there."
  (interactive)
  (forward-char 1)
  (backward-delete-char arg)
  )
 

; the following are commands for undoing c-forms
(defun undo-c-switch ()
  (interactive)
  (backward-word 1)
  (let ((start-pos (point)))
    (next-line 7)
    (end-of-line)
    (delete-region start-pos (point)))
  )


(defun undo-c-while-do ()
  (interactive)
  (backward-word 1)
  (let ((start-pos (point)))
    (next-line 2)
    (end-of-line)
    (delete-region start-pos (point)))
  )


(defun undo-c-do-while ()
  (interactive)
  (search-backward "do")
  (let ((start-pos (point)))
    (next-line 2)
    (end-of-line)
    (delete-region start-pos (point)))
  )


(defun undo-c-new-case ()
  (interactive)
  (search-backward "case")
  (let ((start-pos (point)))
    (next-line 2)
    (end-of-line)
    (delete-region start-pos (point)))
  )


(defun undo-c-block ()
  (interactive)
  (search-backward "{")
  (let ((start-pos (point)))
    (next-line 2)
    (end-of-line)
    (delete-region start-pos (point)))
  )


; the following are commands for undoing lisp-forms
(defun undo-lisp-defun ()
  (interactive)
  (search-backward "\(")
  (let ((start-pos (point)))
    (next-line 1)
    (end-of-line)
    (delete-region start-pos (point)))
  )


(defun undo-let-selection ()
  (interactive)
  (if (string-equal 'emacs-lisp-mode major-mode)
      (progn (search-backward "\(let")
	     (let ((start-pos (point)))
	       (next-line 1)
	       (end-of-line)
	       (delete-region start-pos (point))))
    (backward-delete-char 4))
  )


(defun undo-quote-body ()
  (interactive)
  (if (or (string-equal 'ams-latex-mode major-mode) (string-equal 'latex-mode major-mode) (string-equal 'tex-mode major-mode))
      (undo-right-2 4)
    (undo-right-1 2))
  )


; 
(defun nothing ()
  "Nothing is used for 'undoing' functions that is difficult to undo.
As the name says, it does nothing. The reason is the way dragondictate
undoes all speech commands : by sending backspace characters.
Running undo at a function without a paired undo-function, will erase a
 given number of characters, thereby erasing text unconnected to the function.
Nothing avoids that."
  (interactive)
  ()
  )


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Undo for use with windows version of DD.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defun dragondictate-undo ()
  "Undo made to 'counter' the DragonDictate 'No Space' mode."
  (interactive)
  (advertised-undo 1)
  (insert " ")
  )

