; Dragondictate utilities for emacs v. 0.8
; Written by Thomas Rene Nielsen (trn@imada.ou.dk)
; Notice that this is not the final version


(setq speaklist-frame nil)


;(setq speaklist-file "c:/windows/speciale/demacs.ddx")
;(setq speaklist-file "d:/ddwin2.5/demacs.ddx")
(setq speaklist-file "~/speciale/demacs.dcm")

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; frame coordinates and size
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;(setq speaklist-frame-coor '((left . 664)))
;(setq speaklist-frame-size '((width . 35)(height . 40)))
(setq speaklist-frame-coor '((left . 678)))
(setq speaklist-frame-size '((width . 35)(height . 40)))




; The frame starts as invisible and is shown when the text in the buffer
; is formatted. The speak commands must have the form "[commmand aa]".
(defun open-speak-list ()
  "Opens overview of the possible speak commands. A second call will close the list.

Reads file specified in speaklist-file.

Remarks made in file will be shown in speaklist. Double ;; remarks wil not be shown. "
  (interactive)
  (let ((this-frame (selected-frame))) 
    (if (frame-live-p speaklist-frame)
	(progn (delete-frame speaklist-frame)
	       (kill-buffer "Speak commands"))
      (progn (setq speaklist-frame (make-frame (append speaklist-frame-coor speaklist-frame-size '((name . "Speak Commands")(minibuffer . nil)(menu-bar-lines . 0)(visibility . nil))))))
      (select-frame speaklist-frame)
      (switch-to-buffer "Speak commands")
      (setq buffer-read-only nil)
      (erase-buffer)
      (insert-file-contents speaklist-file )
      (modify-frame-parameters speaklist-frame '((visibility . t)))
      (get-speak-commands)
      (setq buffer-read-only t)
      (modify-frame-parameters speaklist-frame '((visibility . t)))
      (select-frame this-frame)))
)


(defun get-speak-commands ()
  "Searches through buffer and deletes everything not a speak command."
  (goto-char (point-min))
  (let ((start-pos (get-start-pos)))
    (let ((end-pos (get-end-pos)))
      (while (> (point-max) (get-end-pos))
	(if (looking-at "switch")
	    (delete-region start-pos end-pos)
	  (progn (re-search-forward "[[;]" end-pos t)
		 (if (and (looking-at-num -1 ";") (looking-at ";"))
		  ;  double quote means list remark, don't include in list
		     (delete-region start-pos end-pos)
		   (if (looking-at-num -1 "[[]")
		       (progn (backward-char 1)
			      (delete-region start-pos (point))
			      (search-forward "]")
			      (setq start-pos (point))
					;skip quote
			      (forward-char 1)
					; get to last quote
			      (re-search-forward "[\"]" nil t)
			      (re-search-forward "[\"]" nil t)
			      (delete-region start-pos (get-end-pos)))))))
		 (next-line 1)
		 (beginning-of-line)
		 (setq start-pos (get-start-pos))
		 (setq end-pos (get-end-pos)))

      (re-search-forward "[[;]" end-pos t)
      (if (and (looking-at-num -1 ";") (looking-at ";"))
					;  double quote means list remark, don't include in list
	  (delete-region start-pos end-pos)
	(if (looking-at-num -1 "[[]")
	    (progn (backward-char 1)
		   (delete-region start-pos (point))
		   (search-forward "]")
		   (setq start-pos (point))
					;skip quote
		   (forward-char 1)
					; get to last quote
		   (re-search-forward "[\"]" nil t)
		   (re-search-forward "[\"]" nil t)
		   (delete-region start-pos (get-end-pos)))))))
  )


;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Frame selection
;;;;;;;;;;;;;;;;;;;;;;;;;;

(defun go-speak-list ()
  "Jumps to the speak list frame."
  (interactive)
  (activate-frame speaklist-frame)
  )
  

 












