; Dragondictate utilities for emacs v. 0.8
; Written by Thomas Rene Nielsen (trn@imada.ou.dk)
; Notice that this is not the final version

(setq lisp-filename "~/speciale/lisp.dat")
;(setq lisp-filename "c:/utils/emacs-19.34/lisp.dat")

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; frame coordinates and size
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;(setq var-frame-coor '((left . 664)(top . 280)))
;(setq var-frame-size '((width . 43)(height . 12)))
;(setq defun-frame-coor '((left . 664)(top . 100)))
;(setq defun-frame-size '((width . 43)(height . 12)))
(setq var-frame-coor '((left . 678)(top . 202)))
(setq var-frame-size '((width . 50)(height . 12)))
(setq defun-frame-coor '((left . 678)))
(setq defun-frame-size '((width . 50)(height . 12)))
;(setq lisp-main-frame-coor '((left . 664)(top . 100)))
;(setq lisp-main-frame-size '((width . 43)(height . 12)))
;(setq lisp-sub-frame-coor '((left . 664)(top . 280)))
;(setq lisp-sub-frame-size '((width . 43)(height . 12)))
(setq lisp-main-frame-coor '((left . 678)(top . 0)))
(setq lisp-main-frame-size '((width . 50)(height . 12)))
(setq lisp-sub-frame-coor '((left . 678)(top . 222)))
(setq lisp-sub-frame-size '((width . 50)(height . 12)))

; Internal stuff

(setq lisp-main-frame nil)
(setq lisp-sub-frame nil)
(setq lisp-group-list nil)
(setq lisp-sub-group nil)
; global variables used by the identifier functions
(setq defun-frame nil)
(setq var-frame nil)
(setq defun-list nil)
(setq lisp-var-list nil)

 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Lisp basic forms
;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defun lisp-paren ()
  "Makes a lisp paren pair and indents line."
  (interactive)
  (insert "()")
  (backward-char 1)
  (lisp-indent-line)
  )


(defun lisp-quote ()
  "Makes a lisp quote pair and indents line."
  (interactive)
  (insert-char ?\" 2)
  (backward-char 1)
  (lisp-indent-line)
  )


(defun lisp-remark ()
  "Inserts a lisp remark."
  (interactive)
  (insert "; ")
  )


(defun lisp-make-defun ()
  "Inserts a defun form."
  (interactive)
  (newline 2)
  (insert "(defun  ()")
  (next-line 1)
  (insert ")")
  (lisp-indent-line)
  (previous-line 1)
  (beginning-of-line)
  (forward-word 1)
  (forward-char 1)
  )


(defun lisp-make-setq ()
  "inserts a setq-form."
  (interactive)
  (insert "(setq )")
  (backward-char 1)
  (lisp-indent-line)
  )



(defun lisp-make-let ()
  "inserts a let-form."
  (interactive)
  (insert "(let (())")
  (backward-char 2)
  (lisp-indent-line)
  (let ((this-pos (point)))
    (end-of-line)
    (newline 1)
    (insert ")")
    (goto-char this-pos)) 
  )


(defun lisp-conditional ()
  "inserts a if-form."
  (interactive)
  (insert "(if ()")
  (backward-char 1)
  (lisp-indent-line)
  (let ((this-pos (point)))
    (end-of-line)
    (newline 1)
    (insert ")")
    (goto-char this-pos)) 
  )


(defun lisp-while-do ()
  "inserts a while-do-form."
  (interactive)
  (insert "(while ()")
  (backward-char 1)
  (lisp-indent-line)
  (let ((this-pos (point)))
    (end-of-line)
    (newline 1)
    (insert ")")
    (goto-char this-pos))
  )


(defun lisp-do-while ()
  "inserts a while-do-form."
  (interactive)
  (insert "(while (progn")
  (lisp-indent-line)
  (end-of-line)
  (newline 2)
  (insert "()))")
  (lisp-indent-line)
  (previous-line 1)
  (lisp-indent-line)
  )


; creates the main part of an a-list
(defun lisp-make-alist ()
  "Creates an alist."
  (interactive)
  (insert " '(( . ))")
  (backward-char 5)
  )


; adds more inner parts of a-lists
(defun lisp-make-alist-part ()
  "Makes an alist part : ( . ) and positions cursor."
  (interactive)
  (insert "( . )")
  (backward-char 4)
)


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Lisp identifiers collecting functions
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(add-hook 'mouse-1-down-hook 'defun-list-mouse-action)
(add-hook 'mouse-1-down-hook 'var-list-mouse-action)

; use this hook, if you want every file you load, to be parsed for identifiers.
;(add-hook 'find-file-hooks 'collect-all-identifiers-buffer)


(defun lisp-clear-identifiers ()
  "Clears the lisp identifier lists."
  (interactive)
  (setq defun-list nil)
  (setq lisp-var-list nil)
  (if (frame-live-p defun-frame)
      (open-defun-list2))
  (if (frame-live-p var-frame)
      (open-var-list2))
  )


(defun lisp-collect-defun-only ()
  "Clear the defun list, and collects the function identifiers in the defun."
  (interactive)
  (lisp-clear-identifiers)
  (beginning-of-defun)
  (lisp-collect-identifiers)
  (if (frame-live-p defun-frame)
      (open-defun-list2))
  (if (frame-live-p var-frame)  
      (open-var-list2))
  )


(defun lisp-collect-identifiers ()
  "Collects all identifiers on the current logical line
or in the current function."
  (interactive)
  (beginning-of-line)
  ; skips empty spaces at the start of the line
  (while (looking-at "[ \t]")
    (forward-char 1))
  ; is this a list paren ?
  (if (looking-at "\(")
      (progn (forward-char 1)
	     (lisp-get-identifiers (get-word))))
)
	
   
(defun lisp-get-identifiers (word)
  ; if the first keyword is 'defun' or 'defmacro'
   (if (or (string-equal "defun" word) (string-equal "defmacro" word))
       (progn (next-word)
	      (insert-defun-list (get-word))
	      (next-word)
	      (while (not (looking-at "\)"))
		(next-word)
		(insert-var-list (get-word)))
	      (forward-char 1)))

   ; if a 'setq' of 'set' part
   (if (or (string-equal "setq" word) (string-equal "set" word))
       (progn (next-word)
	      (while (not (looking-at "\)")) 
		(next-word)
		(skip-remark)
		
		(insert-var-list (get-word))
		(next-word)
		(skip-remark)
		
		(if (looking-at-num -1 " ")
		    (insert-var-list (get-word))
		  (if (looking-at-num -1 "\(")
		      ; call recursive to get inner part as well
		      (progn (lisp-get-identifiers (get-word))
			     (forward-char 1)))))))
   
   (if (or (string-equal "let" word) (string-equal "let*" word)) 
       (progn (next-word)
	      (while (not (looking-at "\)"))  
		(next-word)
		(skip-remark)
	       
		(insert-var-list (get-word))
		(next-word)
		(skip-remark)
		
		(if (looking-at-num -1 " ")
		    (get-word)
		  (if (looking-at-num -1 "\(")
		      ; call recursive to get inner part as well
		      (progn (lisp-get-identifiers (get-word))
			     (forward-char 2)))))
	      (forward-char 1)))
   
   
   (if (or (string-equal "defvar" word) (string-equal "defconst" word))
       (progn (next-word)
	      (insert-var-list (get-word)) 
	      (while (not (looking-at "\)")) 
		(next-word)
		(skip-remark)
		
		(if (looking-at "\"")
		    (progn (forward-char 1)
			   (re-search-forward "[\"]" nil t)
			   (while (looking-at-num -2 "[\\]")
			     (re-search-forward "[\"]" nil t)))
		  (if (looking-at-num -1 " ")
		      (insert-var-list (get-word))
		    (if (looking-at-num -1 "\(")
			; call recursive to get inner part as well
			(progn (lisp-get-identifiers (get-word))
			       (forward-char 1))))))))
	     


 (insert-defun-list word)
 (next-word)
 (while (not (looking-at "\)"))   
   (next-word)
   (skip-remark)
   ; is the next part quoted.
   (if (looking-at "\'")
       (if (looking-at-num 1 "\(")
	   (if (looking-at-num 2 "\(")
	       ; including parens -> alist -> should be skipped
	       (search-forward "))" nil t)
	     (search-forward ")" nil t))
	 (get-word))
     (if (looking-at "\"")
	 ; string ?
	 (progn (forward-char 1)
		(re-search-forward "[\"]" nil t)
		(while (looking-at-num -2 "[\\]")
		  (re-search-forward "[\"]" nil t)))
       (if (looking-at-num -1 "\(")
	   ; recurse to inner parts
	   (progn (next-word)
		  (lisp-get-identifiers (get-word))
		  (forward-char 1))
	 (progn 
	   (insert-var-list (get-word))
	  
	   (next-word))))))
 )


	
(defun skip-remark ()
  "Skips until end of remark."
  (interactive)
  (while (looking-at "\;")
    (end-of-line)
    (next-word))
)



; The next functions are inner parts of the identifier functions
(defun next-word ()
  "Jump past spaces and '(' to next expression."
  (while (looking-at "[ \t\n\(]")
    (forward-char 1))
)



(defun get-word ()
  "get the next word and place cursor after word."
  (let ((temp-string nil))
    (if (or (> (char-after (point)) ?9) (looking-at "[\-\/\*\+]"))
  	(while (looking-at "[^ \)\(\n]") 
	  (setq temp-string (concat temp-string (char-to-string(char-after (point)))))
	  (forward-char 1))
      (while (looking-at "[^ \)\(\n]")
	(forward-char 1))) 
      temp-string)
)
 


(defun insert-defun-list (word)
  "Inserts 'word' in defun-list if 'word' is not there."
  (if (and (not (member word defun-list)) (> (length word) 0))
      (setq defun-list (append defun-list (list word))))
)


(defun insert-var-list (word)
  "Inserts 'word' in var-list if 'word' is not there."
  (if (and (not (member word lisp-var-list)) (> (length word) 0))
      (setq lisp-var-list (append lisp-var-list (list word))))
)



(defun show-var-list ()
  "This function makes a visual var buffer list."
  (let ((temp lisp-var-list))
    (while (not (atom temp))
      (insert (car temp))
      (newline 1)
      (setq temp (cdr temp))))
  (sort-lines nil (point-min) (point-max))
)


(defun open-var-list ()
  "Opens the fast selection var identifier list. 
Call again to close. Mouseclick in list to copy var to kill-ring."
  (interactive)
  (if (frame-live-p var-frame)
      (progn (delete-frame var-frame)
	     (kill-buffer "Variable Identifiers"))
    (progn (setq var-frame (make-frame (append var-frame-coor var-frame-size '((name . "Click to copy")(minibuffer . nil)(menu-bar-lines . 0)(visibility . nil)))))
    (open-var-list2)))
)


(defun open-var-list2 ()
  "Call open-var-list2 to refresh the var-list."
  (interactive)
  (let ((this-frame (selected-frame))) 
    (select-frame var-frame)
    (switch-to-buffer "Variable Identifiers")
    (setq buffer-read-only nil)
    (erase-buffer)
    (show-var-list)
    (setq buffer-read-only t)
    (modify-frame-parameters var-frame '((visibility . t)))
    (set-mouse-position var-frame 10 5)
    (select-frame this-frame))
)


(defun show-defun-list ()
  "This function makes a visual defun buffer list."
  (let ((temp defun-list))
    (while (not (atom temp))
      (insert (car temp))
      (newline 1)
      (setq temp (cdr temp))))
  (sort-lines nil (point-min) (point-max))
)


; this function opens the lisp function list.
;  Mouse click in the function list, to copy the  functionname to the killring.
(defun open-defun-list ()
  "Opens the fast selection defun identifier list. 
Call again to close. Mouseclick in list to copy defun to kill-ring."
  (interactive)
  ; if the frame is allready alive, then kill it and recreate
  (if (frame-live-p defun-frame)
      (progn (delete-frame defun-frame)
	     (kill-buffer "Function Identifiers"))
    (progn (setq defun-frame (make-frame (append defun-frame-coor defun-frame-size '((name . "Click to copy")(minibuffer . nil)(menu-bar-lines . 0)(visibility . nil)))))
    (open-defun-list2)))
)


;  Use this function to update the lisp function list.
(defun open-defun-list2 ()
  "Refreshes the defun-list."
  (interactive)
  (let ((this-frame (selected-frame))) 
    (select-frame defun-frame)
    (switch-to-buffer "Function Identifiers")
    (setq buffer-read-only nil)
    (erase-buffer)
    (show-defun-list)
    (setq buffer-read-only t)
    (modify-frame-parameters defun-frame '((visibility . t)))
    (set-mouse-position defun-frame 10 5)
    (select-frame this-frame))
)


;  Parses the whole buffer.
(defun lisp-collect-all-identifiers-buffer ()
  "Collects all the identifiers in the whole buffer."
  (interactive)
  (if (string-equal 'emacs-lisp-mode major-mode)
      (let ((this-pos (point)))
	(goto-char (point-min))
	(lisp-collect-identifiers)
	(end-of-line)
	(while (and (/= 1 (forward-line 1)) (< (point) (point-max)))
	  (lisp-collect-identifiers)
	  (end-of-line))
	(goto-char this-pos)
	(if (frame-live-p defun-frame)
	    (open-defun-list2))
	(if (frame-live-p var-frame)
	    (open-var-list2))))
  )



(defun defun-list-mouse-action ()
  "Tests if the mouse has clicked in the 'defun' frame and copies word
to kill-ring."
  (if (and (frame-live-p defun-frame) (eq defun-frame (selected-frame)))
      (progn (goto-char (position-of-mouse))
	     (beginning-of-line)
	     (let ((start-pos (point)))
	       (end-of-line)
	       (let ((end-pos (point)))
		 (copy-region-as-kill start-pos end-pos)))))
)

 
(defun var-list-mouse-action ()
  "Tests if the mouse has clicked in the 'var' frame and copies word
to kill-ring."
  (if (and (frame-live-p var-frame) (eq var-frame (selected-frame)))
      (progn (goto-char (position-of-mouse))
	     (beginning-of-line)
	     (let ((start-pos (point)))
	       (end-of-line)
	       (let ((end-pos (point)))
		 (copy-region-as-kill start-pos end-pos)))))
)



;;;;;;;;;;;;;;;;;;;;;;;
;; Lisp menu
;;;;;;;;;;;;;;;;;;;;;;;


(add-hook 'mouse-1-down-hook 'lisp-main-mouse-action)
(add-hook 'mouse-1-down-hook 'lisp-sub-mouse-action)


(defun lisp-open-main-list ()
  "Opens lisp main list. Call again to close. Mouseclick in list to select."
  (interactive)
  (if (frame-live-p lisp-main-frame)
      (progn (delete-frame lisp-main-frame)
             (kill-buffer "Lisp Main")
	     (delete-frame lisp-sub-frame)
	     (kill-buffer"Lisp Selection"))
    (progn (setq lisp-main-frame (make-frame (append lisp-main-frame-coor lisp-main-frame-size '((name . "Click to select")(minibuffer . nil)(menu-bar-lines . 0)(visibility . nil)))))
	   (lisp-open-main-list2)))
)


(defun lisp-open-main-list2 ()
  "This function actually does the job."
  (interactive)
  (let ((this-frame (selected-frame))) 
    (select-frame lisp-main-frame)
    (switch-to-buffer "Lisp Main")
    (setq buffer-read-only nil)
    (erase-buffer)
    (get-lisp-main-list)
    (erase-buffer)
    (list-lisp-main)
    (setq buffer-read-only t)
    (modify-frame-parameters lisp-main-frame '((visibility . t)))
    (select-frame this-frame))
)


(defun lisp-main-mouse-action ()
  "Tests if the mouse has clicked in the 'lisp-main' frame and
select subgroup."
  (if (and (frame-live-p lisp-main-frame) (eq lisp-main-frame (selected-frame)))
      (progn (goto-char (position-of-mouse))
             (beginning-of-line)
	     ; using the get-word from latex
             (let ((word (get-latex-word)))
                   (if (not (eq word nil))                     
                       (open-lisp-sub-list word)))))
  )


; inner parts of lisp list
(defun get-lisp-main-list ()
  (switch-to-buffer "Lisp Main")
  (erase-buffer)
  (insert-file-contents lisp-filename)
  (setq lisp-group-list nil)
  (goto-char (point-min))
  (let ((group-name nil))
    (let ((list-part nil))
      (while (< (point) (point-max))
        (let ((end-pos (get-end-pos)))
          (beginning-of-line)
          (if (not (looking-at "[\;]"))
              (progn (if (search-forward ":" end-pos t)
                         (progn (beginning-of-line)
                                (let ((temp-string nil))
                                  (setq temp-string (get-latex-word))
                                  (forward-char 2)
                                  (setq list-part (append list-part (list(cons temp-string (get-latex-word)))))))
                       
                       (progn (if (not (eq nil group-name))
                                  (setq lisp-group-list (append lisp-group-list (list (cons group-name (list list-part))))))
                              (setq list-part nil)
                              (setq group-name (get-latex-word)))))))
        (forward-line 1))))
  )





(defun list-lisp-main ()
  (let ((number 0))
    (while (nth number lisp-group-list)
      (insert (car (nth number lisp-group-list)))
      (newline 1)
      (setq number (+ number 1))))
  )


(defun open-lisp-sub-list (group-name)
  "Opens lisp sub list. "
  (let ((this-frame (selected-frame))) 
    (if (not (frame-live-p lisp-sub-frame))
	(setq lisp-sub-frame (make-frame (append lisp-sub-frame-coor lisp-sub-frame-size '((name . "Click to copy")(minibuffer . nil)(menu-bar-lines . 0)(visibility . nil))))))
    (select-frame lisp-sub-frame)
    (switch-to-buffer "Lisp Selection")
    (setq buffer-read-only nil)
    (setq lisp-sub-group group-name)
    (erase-buffer)
    (list-lisp-sub group-name)
    (setq buffer-read-only t)
    (modify-frame-parameters lisp-sub-frame '((visibility . t)))
    (select-frame this-frame)) 
)


(defun lisp-sub-mouse-action ()
  "Tests if the mouse has clicked in the 'lisp-sub' frame and if so,
copies text to kill-ring."
  (if (and (frame-live-p lisp-sub-frame) (eq lisp-sub-frame (selected-frame)))
      (progn (goto-char (position-of-mouse))
             (beginning-of-line)
             (let ((word (get-latex-word)))
               (if (not (eq nil word))
                   (let ((output (cdr (assoc word (car (cdr (assoc lisp-sub-group lisp-group-list)))))))
                     (setq buffer-read-only nil)
                     (goto-char (point-max))
                     (newline 1)
		     (setq test output)
                     (insert output)
                     (beginning-of-line)
                     (let ((start-pos (point)))
                       (end-of-line)
                       (let ((end-pos (point)))
                         (copy-region-as-kill start-pos end-pos)))))
; if you like the lisp-lists to close after selection
; then uncomment the next four lines.
               ;  (delete-frame lisp-sub-frame)
               ;  (delete-frame lisp-main-frame)
               ;  (kill-buffer "Lisp Selection")
               ;  (kill-buffer "Lisp Main")
	       )))
)

(defun list-lisp-sub (group-name)
  (let ((group (car (cdr (assoc group-name lisp-group-list)))))
    (let ((number 0))
      (while (nth number group)
      (insert (car (nth number group)))
      (newline 1)
      (setq number (+ number 1)))))
)

;;;;;;;;;;;;;;;;;;;
;; Skip functions
;;;;;;;;;;;;;;;;;;;


(defun lisp-skip-forward ()
  "skips to the next logical place to write in a quote,paran or bracket pair. skips to the other side in an alist ( . )."
  (interactive)
  (let ((this-pos (point)))
    (end-of-line)
    (let ((end-pos (point)))
      (goto-char this-pos)
      ; looking for ']', '.', '"' '(' or ')'
      (if (re-search-forward "[\].\")(]" end-pos t)
	  (if (looking-at-num -1 "[\.]")
	      (forward-char 1))
	(progn (next-line 1)
	       (beginning-of-line)))))
)

(defun lisp-skip-backward ()
  "skips backward to the next logical place to write in a quote,paran or bracket pair. skips to the other side in an alist ( . )."
  (interactive)
  (let ((this-pos (point)))
    (beginning-of-line)
    (let ((start-pos (point)))
      (goto-char this-pos)
      (if (re-search-backward "[\[.\"\(\)]" start-pos t)
	  (if (looking-at "[\.]")
	      (backward-char 1))
	(progn (previous-line 1)
	       (end-of-line)))))
  )


;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Frame selection
;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defun go-lisp-var-frame ()
  "Jumps to the Lisp var frame."
  (interactive)
  (activate-frame var-frame)
  )


(defun go-lisp-defun-frame ()
  "Jumps to the Lisp defun frame."
  (interactive)
  (activate-frame defun-frame)
  )


(defun go-lisp-main-frame ()
  "Jumps to the Lisp main frame."
  (interactive)
  (activate-frame lisp-main-frame)
  )


(defun go-lisp-sub-frame ()
  "Jumps to the Lisp sub frame."
  (interactive)
  (activate-frame lisp-sub-frame)
  )







