; Dragondictate utilities for emacs v. 0.8
; Written by Thomas Rene Nielsen (trn@imada.ou.dk)
; Notice that this is not the final version

(setq latex-filename "~/speciale/latex.dat")
;(setq latex-filename "c:/utils/emacs-19.34/latex.dat")

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; frame coordinates and size
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;(setq latex-main-frame-coor '((left . 664)(top . 100)))
;(setq latex-main-frame-size '((width . 43)(height . 12)))
;(setq latex-sub-frame-coor '((left . 664)(top . 280)))
;(setq latex-sub-frame-size '((width . 43)(height . 12)))
(setq latex-main-frame-coor '((left . 678)(top . 0)))
(setq latex-main-frame-size '((width . 50)(height . 12)))
(setq latex-sub-frame-coor '((left . 678)(top . 222)))
(setq latex-sub-frame-size '((width . 50)(height . 12)))


; Internal stuff
(setq latex-main-frame nil)
(setq latex-sub-frame nil)
(setq latex-group-list nil)
(setq latex-sub-group nil)



;;;;;;;;;;;;;;;;;;;;;;;
;; Latex menu
;;;;;;;;;;;;;;;;;;;;;;;

(add-hook 'mouse-1-down-hook 'latex-main-mouse-action)
(add-hook 'mouse-1-down-hook 'latex-sub-mouse-action)


(defun latex-open-main-list ()
  "Opens latex main list. Call again to close.
Mouseclick in list to select."
  (interactive)
  (if (frame-live-p latex-main-frame)
      (progn (delete-frame latex-main-frame)
             (kill-buffer "Latex Main")
	     (delete-frame latex-sub-frame)
	     (kill-buffer"Latex Selection"))
    (progn (setq latex-main-frame (make-frame (append latex-main-frame-coor latex-main-frame-size '((name . "Click to select")(minibuffer . nil)(menu-bar-lines . 0)(visibility . nil)))))
	   (latex-open-main-list2)))
)


(defun latex-open-main-list2 ()
  "This function actually does the job."
  (interactive)
  (let ((this-frame (selected-frame))) 
    (select-frame latex-main-frame)
    (switch-to-buffer "Latex Main")
    (setq buffer-read-only nil)
    (erase-buffer)
    (get-latex-main-list)
    (erase-buffer)
    (list-latex-main)
    (setq buffer-read-only t)
    (modify-frame-parameters latex-main-frame '((visibility . t)))
    (select-frame this-frame))
)


(defun latex-main-mouse-action ()
  "Tests if the mouse has clicked in the 'latex-main' frame and
select subgroup."
  (if (and (frame-live-p latex-main-frame) (eq latex-main-frame (selected-frame)))
      (progn (goto-char (position-of-mouse))
             (beginning-of-line)
             (let ((word (get-latex-word)))
                   (if (not (eq word nil))                     
                       (open-latex-sub-list word)))))
  )


; inner parts of latex list
(defun get-latex-main-list ()
  (switch-to-buffer "Latex Main")
  (erase-buffer)
  (insert-file-contents latex-filename)
  (setq latex-group-list nil)
  (goto-char (point-min))
  (let ((group-name nil))
    (let ((list-part nil))
      (while (< (point) (point-max))
        (let ((end-pos (get-end-pos)))
          (beginning-of-line)
          (if (not (looking-at "[\;]"))
              (progn (if (search-forward ":" end-pos t)
                         (progn (beginning-of-line)
                                (let ((temp-string nil))
                                  (setq temp-string (get-latex-word))
                                  (forward-char 2)
                                  (setq list-part (append list-part (list(cons temp-string (get-latex-word)))))))
                       
                       (progn (if (not (eq nil group-name))
                                  (setq latex-group-list (append latex-group-list (list (cons group-name (list list-part))))))
                              (setq list-part nil)
                              (setq group-name (get-latex-word)))))))
        (forward-line 1))))
  )



(defun get-latex-word ()
  (let ((word nil))
    (while (not (looking-at "[\n\:]"))
      (if (not (looking-at "[\t]"))
          (setq word (concat word (char-to-string(char-after (point))))))
      (forward-char 1)) 
    word)
  )


(defun list-latex-main ()
  (let ((number 0))
    (while (nth number latex-group-list)
      (insert (car (nth number latex-group-list)))
      (newline 1)
      (setq number (+ number 1))))
  )


(defun open-latex-sub-list (group-name)
  "Opens latex sub list. "
  (let ((this-frame (selected-frame))) 
    (if (not (frame-live-p latex-sub-frame))
	(setq latex-sub-frame (make-frame (append latex-sub-frame-coor latex-sub-frame-size '((name . "Click to copy")(minibuffer . nil)(menu-bar-lines . 0)(visibility . nil))))))
    (select-frame latex-sub-frame)
    (switch-to-buffer "Latex Selection")
    (setq buffer-read-only nil)
    (setq latex-sub-group group-name)
    (erase-buffer)
    (list-latex-sub group-name)
    (setq buffer-read-only t)
    (modify-frame-parameters latex-sub-frame '((visibility . t)))
    (select-frame this-frame)) 
)


(defun latex-sub-mouse-action ()
  "Tests if the mouse has clicked in the 'latex-sub' frame and if so,
copies text to kill-ring."
  (if (and (frame-live-p latex-sub-frame) (eq latex-sub-frame (selected-frame)))
      (progn (goto-char (position-of-mouse))
             (beginning-of-line)
             (let ((word (get-latex-word)))
               (if (not (eq nil word))
                   (let ((output (cdr (assoc word (car (cdr (assoc latex-sub-group latex-group-list)))))))
                     (setq buffer-read-only nil)
                     (goto-char (point-max))
                     (newline 1)
                     (insert output)
                     (beginning-of-line)
                     (let ((start-pos (point)))
                       (end-of-line)
                       (let ((end-pos (point)))
                         (copy-region-as-kill start-pos end-pos)))))
; if you like the latex-lists to close after selection
; then uncomment the next four lines.
               ;  (delete-frame latex-sub-frame)
               ;  (delete-frame latex-main-frame)
               ;  (kill-buffer "Latex Selection")
               ;  (kill-buffer "Latex Main")
	       )))
)


(defun list-latex-sub (group-name)
  (let ((group (car (cdr (assoc group-name latex-group-list)))))
    (let ((number 0))
      (while (nth number group)
      (insert (car (nth number group)))
      (newline 1)
      (setq number (+ number 1)))))
)


;;;;;;;;;;;;;;;;;;;;;;;;;
;; Latex basic forms
;;;;;;;;;;;;;;;;;;;;;;;;;

(defun latex-enviroment ()
  "Asks for enviroment name and creates enviroment form."
  (interactive)
  (let ((name (read-string "Enviroment Name : ")))
    (newline 2)
    (insert "\\begin{")
    (insert name)
    (insert "}")
    (newline 2)
    (insert "\\end{")
    (insert name)
    (insert "}")
    (previous-line 1)
    (beginning-of-line))
  )


; just an example
(defun latex-flushright ()
  "Inserts flushright enviroment."
  (interactive)
  (newline 2)
  (insert "\\begin{flushright}")
  (newline 2)
  (insert "\\end{flushright}")
  (previous-line 1)
  (beginning-of-line)
  )
          

(defun latex-document ()
  "Inserts document enviroment."
  (interactive)
  (newline 2)
  (insert "\\begin{document}")
  (newline 2)
  (insert "\\end{document}")
  (previous-line 1)
  (beginning-of-line)
  )


(defun latex-quotes ()
  "Inserts a latex quote pair."
  (interactive)
  (insert "``''")
  (backward-char 2)
  )


(defun latex-remark ()
  "Inserts a latex remark."
  (interactive)
  (insert "%")
  )


(defun latex-inline ()
  "Inserts the math 'inline' form and positions cursor."
  (interactive)
  (insert "\\(  \\)")
  (backward-char 3)
  )


(defun latex-displayed ()
 "Inserts the math 'displayed' form and positions cursor."
  (interactive)
  (insert "\\[  \\]")
  (backward-char 3)
  )  


(defun latex-emphasize-text ()
  "Inserts an emphasize text form."
  (interactive)
  (insert "\\em \\/")
  (backward-char 2)
  )


(defun latex-number-range ()
  "Inserts '---' number range."
  (interactive)
  (insert "---")
  )


(defun latex-subscript ()
  "Inserts subscript."
  (interactive)
  (insert "_{}")
  (backward-char 1)
  )


(defun latex-superscript ()
  "Inserts superscript."
  (interactive)
  (insert "^{}")
  (backward-char 1)
  )


(defun latex-interval-open-open ()
  "Inserts open-open (, ) interval."
  (interactive)
  (insert "(, )")
  (backward-char 3)
  )


(defun latex-interval-open-closed ()
   "Inserts open-closed (, ] interval."
  (interactive)
  (insert "(, ]")
  (backward-char 3)
  ) 


(defun latex-interval-closed-open ()
   "Inserts closed-open [, ) interval."
  (interactive)
  (insert "[, )")
  (backward-char 3)
  )


(defun latex-interval-closed-closed ()
   "Inserts closed-closed [, ] interval."
  (interactive)
  (insert "[, ]")
  (backward-char 3)
  )


;;;;;;;;;;;;;;;;;;;;;;;;;
;; Latex skip functions
;;;;;;;;;;;;;;;;;;;;;;;;;

(defun latex-skip-forward ()
  "skips to the next logical place to write."
  (interactive)
  (let ((end-pos (get-end-pos)))
    (if (re-search-forward "[]\[\}\\,\)\{\(]" end-pos t)
	(if (looking-at "[\(\)]")
	    (forward-char 1))))
  )


(defun latex-skip-backward ()
  "skips backward to the next logical place to write."
  (interactive)
  (let ((start-pos (get-start-pos)))
    (if (re-search-backward "[]\[\}\{,\)\(]" start-pos t)
	(if (looking-at-num -1 "[\\]")
	    (backward-char 1))))
  )




;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Latex frame selection
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defun go-latex-main-frame ()
  "Jumps to the latex main frame."
  (interactive)
  (activate-frame latex-main-frame)
  )


(defun go-latex-sub-frame ()
  "Jumps to the latex sub frame."
  (interactive)
  (activate-frame latex-sub-frame)
  )


