; Dragondictate utilities for emacs v. 0.8
; Written by Thomas Rene Nielsen (trn@imada.ou.dk)
; Notice that this is not the final version

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; frame coordinates and size
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;(setq filelist-frame-coor '((left . 664)(top . 202)))
;(setq filelist-frame-size '((width . 43)(height . 12)))
(setq filelist-frame-coor '((left . 678)(top . 202)))
(setq filelist-frame-size '((width . 50)(height . 12)))



(setq file-list '())
(setq filelist-frame nil)
(add-hook 'find-file-hooks 'insert-file-list)
(add-hook 'after-save-hook 'insert-file-list)
(add-hook 'mouse-1-down-hook 'file-list-mouse-action)


(defun open-file-list ()
  "Opens the fast selection file list. Call twice to close.
Shows the ten most recently used files. Select file by mouseclicking."
  (interactive)
  (if (frame-live-p filelist-frame)
      (progn (delete-frame filelist-frame)
	     (kill-buffer "Recent Files"))
    (progn (setq filelist-frame (make-frame (append filelist-frame-coor filelist-frame-size '((name . "Click to Load")(left . 678)(width . 50)(height . 12)(minibuffer . nil)(menu-bar-lines . 0)(visibility . nil)))))
    (open-file-list2)))
)


(defun open-file-list2 ()
  "This function actually does the job"
  (let ((this-frame (selected-frame))) 
    (select-frame filelist-frame)
    (switch-to-buffer "Recent Files")
    (setq buffer-read-only nil)
    (erase-buffer)
    (show-file-list)
    (setq buffer-read-only t)
    (modify-frame-parameters filelist-frame '((visibility . t)))
    (select-frame this-frame))
)


; add to find-file-hooks
(defun insert-file-list ()
  "inserts file-name in list of most recent used files"
  (let ((file-name (buffer-file-name)))
    (setq file-list(delete file-name file-list))
    (if (< (length file-list) 10)
	(setq file-list (append (list file-name) file-list))
      (setq file-list (append (list file-name) (delete (nth 9 file-list) file-list)))))
  (if (frame-live-p filelist-frame)
      (open-file-list2)) 
)
 

(defun show-file-list ()
  "This function makes a visual file list"
  (let ((temp file-list))
    (while (not (atom temp))
      (insert (car temp))
      (newline 1)
      (setq temp (cdr temp))))
)


(defun file-list-mouse-action ()
  "Tests if the mouse has clicked in the 'file-list' frame"
  (if (and (frame-live-p filelist-frame) (eq filelist-frame (selected-frame)))
      (progn (select-frame main-frame)
	     (let ((filename (nth (cdr(cdr(mouse-position))) file-list)))
	       (if filename 
		   (find-file filename)))))
  )


; presently I don't use this one.
(defun choose-file-list ()
  "Load the file number 'num' in the file list. Asks for a number between 0-9"
  (interactive)
  (progn (select-frame main-frame)
	 (if (let ((filename (nth (string-to-number (read-string "Number : ")) file-list)))
	       (find-file filename))))
  )


;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Frame selection
;;;;;;;;;;;;;;;;;;;;;;;;;;

(defun go-file-list ()
  "Jumps to the file list frame."
  (interactive)
  (activate-frame filelist-frame)
  )





