; Dragondictate utilities for emacs v. 0.8
; Written by Thomas Rene Nielsen (trn@imada.ou.dk)
; Notice that this is not the final version

(setq c-filename "~/speciale/c.dat")
;(setq c-filename "c:/utils/emacs-19.34/c.dat")

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; frame coordinates and size
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;(setq c-var-frame-coor '((left . 664)(top . 280)))
;(setq c-var-frame-size '((width . 43)(height . 12)))
;(setq c-function-frame-coor '((left . 664)(top . 100)))
;(setq c-function-frame-size '((width . 43)(height . 12)))
(setq c-var-frame-coor '((left . 678)(top . 0)))
(setq c-var-frame-size '((width . 50)(height . 12)))
(setq c-function-frame-coor '((left . 678)(top . 222)))
(setq c-function-frame-size '((width . 50)(height . 12)))
;(setq c-main-frame-coor '((left . 664)(top . 100)))
;(setq c-main-frame-size '((width . 43)(height . 12)))
;(setq c-sub-frame-coor '((left . 664)(top . 280)))
;(setq c-sub-frame-size '((width . 43)(height . 12)))
(setq c-main-frame-coor '((left . 678)(top . 0)))
(setq c-main-frame-size '((width . 50)(height . 12)))
(setq c-sub-frame-coor '((left . 678)(top . 222)))
(setq c-sub-frame-size '((width . 50)(height . 12)))

; Internal stuff
(setq c-function-frame nil)
(setq c-var-frame nil)
(setq c-function-list nil)
(setq c-var-list nil)
(setq c-main-frame nil)
(setq c-sub-frame nil)
(setq c-group-list nil)
(setq c-sub-group nil)

(add-hook 'mouse-1-down-hook 'c-var-list-mouse-action)
(add-hook 'mouse-1-down-hook 'c-function-list-mouse-action)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Identifier collecting functions
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun clear-c-identifiers ()
  "clears the c indetifier list. "
  (interactive)
  (setq c-function-list nil)
  (setq c-var-list nil)

  (if (frame-live-p c-function-frame)
      (open-c-function-list2))
  (if (frame-live-p c-var-frame)
      (open-c-var-list2))
)


(defun collect-c-identifiers ()
  "Collects all identifiers on the current logical line."
  (interactive)
  (beginning-of-line)
  (let ((start-pos (point)))
    
    (while (looking-at "[ \t]")
      (forward-char 1))
    
    (if (not (looking-at "\n"))
	(if (looking-at "\#")
	    (progn (forward-char 1)
		   (if (string-equal "define" (get-c-word))
		       (progn (forward-char 1)
			      (get-c-identifiers))
		     (end-of-line)))
	  
	  (if (looking-at "\/")
	      (if (looking-at-num 1 "\/")
		  (end-of-line)
		(if (looking-at-num 1 "\*")
		    (search-forward "*/" nil t)))
	    
	    (let ((word (get-c-word)))
	      (if (looking-at "[ ]")
		  (progn (next-c-word)
			 (get-c-identifiers))
		(progn (goto-char start-pos)
		       (next-c-word)
		       (get-c-identifiers))))))))
)



(defun get-c-identifiers ()
  "Does the job for collect-c-identifiers."
   (let ((word nil))
     (while (looking-at "[^\n\}\;\)]") ; Continue if we havn't reached the end of line, semicolon, end bracket or end
       (setq word (get-c-word))
  
       (if (looking-at "[^{}]")
	   (if (looking-at "\(")
	       (progn (if (not (string-equal nil word))
			  (insert-c-function-list word))

		      (next-c-word)

		      (if (looking-at "\)")
			  (progn (get-c-identifiers)
				 (forward-char 1))))
	     (if (and (not (string-equal nil word)) (not (string-equal "break" word)))
		 (insert-c-var-list word)))
	 (forward-char 1))
       
       (if (looking-at "\"")
	   (progn (forward-char 1)
		  (search-forward "\"" nil t)))

       (if (looking-at "[] [&'<=>\t!]")
	   (forward-char 1))
       (if (and (<= ?\* (char-after (point))) (>= ?\: (char-after (point))))
	   (forward-char 1))))
   )



(defun next-c-word ()
  "Jump past spaces and '(' to next expression."
  (while (looking-at "[ \t\n\(]")
    (forward-char 1))
)


(defun get-c-word ()
  "get the next word and place cursor after word."
  (let ((temp-string nil))
    (if (or (looking-at "\_") (and (<= ?A (char-after (point))) (>= ?Z (char-after (point)))) (and (<= ?a (char-after (point))) (>= ?z (char-after (point)))))
	(progn (setq temp-string (concat temp-string (char-to-string(char-after (point)))))
	       (forward-char 1)
	       (while (or (looking-at "[\-\_]") (and (<= ?A (char-after (point))) (>= ?Z (char-after (point)))) (and (<= ?a (char-after (point))) (>= ?z (char-after (point)))))       
		 (setq temp-string (concat temp-string (char-to-string(char-after (point)))))
		 (forward-char 1))))
    temp-string)
)


(defun insert-c-function-list (word)
  "Inserts 'word' in function-list if 'word' is not there."
  (if (and (not (member word c-function-list)) (> (length word) 0))
      (setq c-function-list (append c-function-list (list word))))
)


(defun insert-c-var-list (word)
  "Inserts 'word' in var-list if 'word' is not there."
  (if (and (not (member word c-var-list)) (> (length word) 0))
      (setq c-var-list (append c-var-list (list word))))
)


(defun show-c-var-list ()
  "This function makes a visual var buffer list."
  (let ((temp c-var-list))
    (while (not (atom temp))
      (insert (car temp))
      (newline 1)
      (setq temp (cdr temp))))
  (sort-lines nil (point-min) (point-max))
)


(defun open-c-var-list ()
  "Opens the fast selection var identifier list. Call again to close.
Mouseclick in list to copy to kill-ring."
  (interactive)
  (if (frame-live-p c-var-frame)
      (progn (delete-frame c-var-frame)
	     (kill-buffer "Variable Identifiers"))
    (progn (setq c-var-frame (make-frame (append c-var-frame-coor c-var-frame-size '((name . "Click to copy")(minibuffer . nil)(menu-bar-lines . 0)(visibility . nil)))))
    (open-c-var-list2)))
)


; Call this to update list
(defun open-c-var-list2 ()
  "This function actually does the job for 'open-c-var-list'.
Call this to refresh the c-var-list window."
  (interactive)
  (let ((this-frame (selected-frame))) 
    (select-frame c-var-frame)
    (switch-to-buffer "Variable Identifiers")
    (setq buffer-read-only nil)
    (erase-buffer)
    (show-c-var-list)
    (setq buffer-read-only t)
    (modify-frame-parameters c-var-frame '((visibility . t)))
    (select-frame this-frame))
)


(defun show-c-function-list ()
  "This function makes a visual defun buffer list."
  (let ((temp c-function-list))
    (while (not (atom temp))
      (insert (car temp))
      (newline 1)
      (setq temp (cdr temp))))
  (sort-lines nil (point-min) (point-max))
)


(defun open-c-function-list ()
  "Opens the fast selection c function identifier list. Call again to close.
Mouseclick in list to copy to kill-ring."
  (interactive)
  (if (frame-live-p c-function-frame)
      (progn (delete-frame c-function-frame)
	     (kill-buffer "Function Identifiers"))
    (progn (setq c-function-frame (make-frame (append c-function-frame-coor c-function-frame-size '((name . "Click to copy")(minibuffer . nil)(menu-bar-lines . 0)(visibility . nil)))))
    (open-c-function-list2)))
)


(defun open-c-function-list2 ()
  "This function actually does the job for 'open-c-function-list'.
Call this to refresh the c-function-list window."
  (interactive)
  (let ((this-frame (selected-frame))) 
    (select-frame c-function-frame)
    (switch-to-buffer "Function Identifiers")
    (setq buffer-read-only nil)
    (erase-buffer)
    (show-c-function-list)
    (setq buffer-read-only t)
    (modify-frame-parameters c-function-frame '((visibility . t)))
    (select-frame this-frame))
)


(defun collect-all-c-identifiers-buffer ()
  "Collects all the identifiers in the whole buffer."
  (interactive)
  (if (string-equal 'c-mode major-mode)
      (let ((this-pos (point)))
	(goto-char (point-min))
	(collect-c-identifiers)
	(end-of-line)
	(while (< (point) (point-max))
	  (forward-line 1)
	  (collect-c-identifiers)
	  (end-of-line))
	(goto-char this-pos)
	(if (frame-live-p c-function-frame)
	    (open-c-function-list2))
	(if (frame-live-p c-var-frame)
	    (open-c-var-list2))))
)


(defun c-function-list-mouse-action ()
  "Tests if the mouse has clicked in the 'c-function' frame and copies word to
kill-ring."
  (if (and (frame-live-p c-function-frame) (eq c-function-frame (selected-frame)))
      (progn (goto-char (position-of-mouse))
	     (beginning-of-line)
	     (let ((start-pos (point)))
	       (end-of-line)
	       (let ((end-pos (point)))
		 (copy-region-as-kill start-pos end-pos)))))
)

 
(defun c-var-list-mouse-action ()
  "Tests if the mouse has clicked in the 'c-var' frame and copies word to
kill-ring."
  (if (and (frame-live-p c-var-frame) (eq c-var-frame (selected-frame)))
      (progn (goto-char (position-of-mouse))
	     (beginning-of-line)
	     (let ((start-pos (point)))
	       (end-of-line)
	       (let ((end-pos (point)))
		 (copy-region-as-kill start-pos end-pos)))))
)



;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; C skip functions
;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defun c-skip-forward ()
  "Skips to the next logical place to write, in the standard forms."
  (interactive)
  (let ((end-pos (get-end-pos)))
     (if (re-search-forward "[\"(,;:})]" end-pos t)
	 (if (looking-at-num -1 "\)")
	     (if (search-forward ";" end-pos t)
		 (progn (next-line 1)
			(beginning-of-line))
	       (if (search-forward "{" end-pos t)
		   (progn (next-line 1)
			  (end-of-line)))))
     
       (progn (next-line 1)
	      (setq end-pos (get-end-pos))
	      (beginning-of-line)
	      (if (search-forward "break;" end-pos t)
		  (progn (next-line 1)
			 (setq end-pos (get-end-pos))
			 (beginning-of-line)
			 (if (search-forward "}" end-pos t)
			     (progn (next-line 1)
				    (beginning-of-line))))
		(progn (search-forward "default:" end-pos t)
		       (search-forward "case :" end-pos t)
		       (search-forward "\(" end-pos t)
		       (if (search-forward "}" end-pos t)
			   (next-line 1)))))))
  )


(defun c-skip-backward ()
  "Skips to the previous logical place to write, in the standard forms."
  (interactive)
  (let ((start-pos (get-start-pos)))
    ; check this line
    (if (not (re-search-backward "[\",;)]" start-pos t))
	(progn (previous-line 1)
	       (setq start-pos (get-start-pos))
	       (end-of-line)
	       (if (not (search-backward ");" start-pos t))
		   (progn (if (search-backward "}" start-pos t)
			      (progn (previous-line 1)
				     (setq start-pos (get-start-pos))
				     (end-of-line)))
			  (if (search-backward "break;" start-pos t)
			      (progn (previous-line 1)
				     (end-of-line)
				     (setq start-pos (get-start-pos))))
			  ;(re-search-backward "[,;)]" start-pos t)
			  )))))
  )
      

;;;;;;;;;;;;;;;;;;;;;;;;;
;; C basic forms
;;;;;;;;;;;;;;;;;;;;;;;;;

(defun c-remark ()
  "Inserts a C remark."
  (interactive)
  (insert "/*  */")
  (backward-char 3)
  )


(defun c-main ()
  "Inserts a C main form."
  (interactive)
  (insert "void main()")
  (backward-char 1)
  )


(defun c-for-loop ()
  "Inserts a C for loop."
  (interactive)
  (newline 2)
  (insert "for(;;) ")
  (backward-char 4)
  (c-indent-command)
)

     
(defun c-conditional ()
  "Inserts C 'if' part."
  (interactive)
  (newline 2)
  (insert "if() ")
  (backward-char 2)
  (c-indent-command)
)
 

; The following code is written by Simon Crosby. I couldn't find any reason
; to write my own code for these functions, because Simon's functions does the
; job nicely. 

;;;--------------------------------------------------------------------
;; Emacs Lisp macros for programming and general use with DragonDictate
;;
;; Copyright (c) Simon Crosby, University of Cambridge 1994, except
;; where stated.
;; 
;; You may freely distribute this code, but must preserve the copyright

;;;--------------------------------------------------------------------

(defun c-do-while ()
  "add a C do while construct at point"
  (interactive)
  (open-line 2)
  (beginning-of-line)
  (insert "do {")
  (c-indent-command)
  (forward-line 1)
  (beginning-of-line)
  (insert "")
  (c-indent-command)
  (let ((pos (point-marker)))
    (forward-line 1)
    (beginning-of-line)
    (insert "} while();")
    (c-indent-command)
    (goto-char (marker-position pos)))
  )


(defun c-while-do ()
  "add a C while construct at point"
  (interactive)
  (open-line 2)
  (beginning-of-line)
  (insert "while(")
  (c-indent-command)
  (let ((pos (point-marker)))
    (insert ") {")
    (c-indent-command)
    (forward-line 1)
    (beginning-of-line)
    (insert "")
    (c-indent-command)
    (forward-line 1)
    (beginning-of-line)
    (insert "}")
    (c-indent-command)
    (goto-char (marker-position pos)))
  )



(defun c-block ()
  "add a C block construct at point"
  (interactive)
  (open-line 2)
  (insert " {")
  (c-indent-command)
  (forward-line 1)
  (beginning-of-line)
  (insert "")
  (c-indent-command)
  (let ((pos (point-marker)))
    (forward-line 1)
    (beginning-of-line)
    (insert "}")
    (c-indent-command)
    (goto-char (marker-position pos)))
  )


  (defun c-switch ()
  "add a C switch construct at point"
  (interactive)
  (open-line 7)
  (beginning-of-line)
  (insert "switch(")
  (let ((pos (point-marker)))
    (insert ") {")
    (c-indent-command)
    (forward-line 1)
    (beginning-of-line)
    (insert "case :")
    (c-indent-command)
    (forward-line 1)
    (beginning-of-line)
    (insert "")
    (c-indent-command)
    (forward-line 1)
    (beginning-of-line)
    (insert "break;")
    (c-indent-command)
    (forward-line 1)
    (beginning-of-line)
    (insert "")
    (c-indent-command)
    (forward-line 1)
    (beginning-of-line)
    (insert "default:")
    (c-indent-command)
    (forward-line 1)
    (beginning-of-line)
    (insert "break;")
    (c-indent-command)
    (forward-line 1)
    (beginning-of-line)
    (insert "}")
    (c-indent-command)
    (goto-char (marker-position pos)))
  )


(defun c-new-case ()
  "add a C switch case at point"
  (interactive)
  (open-line 3)
  (beginning-of-line)
  (insert "case ")
  (c-indent-command)
  (let ((pos (point-marker)))
    (insert ":")
    (c-indent-command)
    (forward-line 1)
    (beginning-of-line)
    (insert "")
    (c-indent-command)
    (forward-line 1)
    (beginning-of-line)
    (insert "break;")
    (c-indent-command)
    (forward-line 1)
    (beginning-of-line)
    (insert "")
    (c-indent-command)
    (goto-char (marker-position pos)))
  )








;;;;;;;;;;;;;;;;;;;;;;;
;; C menu
;;;;;;;;;;;;;;;;;;;;;;;


(add-hook 'mouse-1-down-hook 'c-main-mouse-action)
(add-hook 'mouse-1-down-hook 'c-sub-mouse-action)


(defun c-open-main-list ()
  "Opens C main list. Call again to close.
Mouseclick in list to select."
  (interactive)
  (if (frame-live-p c-main-frame)
      (progn (delete-frame c-main-frame)
             (kill-buffer "C Main")
	     (delete-frame c-sub-frame)
	     (kill-buffer"C Selection"))
    (progn (setq c-main-frame (make-frame (append c-main-frame-coor c-main-frame-size '((name . "Click to select")(minibuffer . nil)(menu-bar-lines . 0)(visibility . nil)))))
	   (c-open-main-list2)))
)


(defun c-open-main-list2 ()
  "This function actually does the job."
  (interactive)
  (let ((this-frame (selected-frame))) 
    (select-frame c-main-frame)
    (switch-to-buffer "C Main")
    (setq buffer-read-only nil)
    (erase-buffer)
    (get-c-main-list)
    (erase-buffer)
    (list-c-main)
    (setq buffer-read-only t)
    (modify-frame-parameters c-main-frame '((visibility . t)))
    (select-frame this-frame))
)


(defun c-main-mouse-action ()
  "Tests if the mouse has clicked in the 'c-main' frame and
select subgroup."
  (if (and (frame-live-p c-main-frame) (eq c-main-frame (selected-frame)))
      (progn (goto-char (position-of-mouse))
             (beginning-of-line)
	     ; using the get-word from latex
             (let ((word (get-latex-word)))
                   (if (not (eq word nil))                     
                       (open-c-sub-list word)))))
  )


; inner parts of c list
(defun get-c-main-list ()
  (switch-to-buffer "C Main")
  (erase-buffer)
  (insert-file-contents c-filename)
  (setq c-group-list nil)
  (goto-char (point-min))
  (let ((group-name nil))
    (let ((list-part nil))
      (while (< (point) (point-max))
        (let ((end-pos (get-end-pos)))
          (beginning-of-line)
          (if (not (looking-at "[\;]"))
              (progn (if (search-forward ":" end-pos t)
                         (progn (beginning-of-line)
                                (let ((temp-string nil))
                                  (setq temp-string (get-latex-word))
                                  (forward-char 2)
                                  (setq list-part (append list-part (list(cons temp-string (get-latex-word)))))))
                       
                       (progn (if (not (eq nil group-name))
                                  (setq c-group-list (append c-group-list (list (cons group-name (list list-part))))))
                              (setq list-part nil)
                              (setq group-name (get-latex-word)))))))
        (forward-line 1))))
  )





(defun list-c-main ()
  (let ((number 0))
    (while (nth number c-group-list)
      (insert (car (nth number c-group-list)))
      (newline 1)
      (setq number (+ number 1))))
  )


(defun open-c-sub-list (group-name)
  "Opens c sub list. "
  (let ((this-frame (selected-frame))) 
    (if (not (frame-live-p c-sub-frame))
	(setq c-sub-frame (make-frame (append c-sub-frame-coor c-sub-frame-size '((name . "Click to copy")(minibuffer . nil)(menu-bar-lines . 0)(visibility . nil))))))
    (select-frame c-sub-frame)
    (switch-to-buffer "C Selection")
    (setq buffer-read-only nil)
    (setq c-sub-group group-name)
    (erase-buffer)
    (list-c-sub group-name)
    (setq buffer-read-only t)
    (modify-frame-parameters c-sub-frame '((visibility . t)))
    (select-frame this-frame)) 
)


(defun c-sub-mouse-action ()
  "Tests if the mouse has clicked in the 'c-sub' frame and if so,
copies text to kill-ring."
  (if (and (frame-live-p c-sub-frame) (eq c-sub-frame (selected-frame)))
      (progn (goto-char (position-of-mouse))
             (beginning-of-line)
             (let ((word (get-latex-word)))
               (if (not (eq nil word))
                   (let ((output (cdr (assoc word (car (cdr (assoc c-sub-group c-group-list)))))))
                     (setq buffer-read-only nil)
                     (goto-char (point-max))
                     (newline 1)
		     (setq test output)
                     (insert output)
                     (beginning-of-line)
                     (let ((start-pos (point)))
                       (end-of-line)
                       (let ((end-pos (point)))
                         (copy-region-as-kill start-pos end-pos)))))
; if you like the c-lists to close after selection
; then uncomment the next four lines.
               ;  (delete-frame c-sub-frame)
               ;  (delete-frame c-main-frame)
               ;  (kill-buffer "C Selection")
               ;  (kill-buffer "C Main")
	       )))
)

(defun list-c-sub (group-name)
  (let ((group (car (cdr (assoc group-name c-group-list)))))
    (let ((number 0))
      (while (nth number group)
      (insert (car (nth number group)))
      (newline 1)
      (setq number (+ number 1)))))
)



;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Frame selection
;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defun go-c-var-frame ()
  "Jumps to the C var frame."
  (interactive)
  (activate-frame c-var-frame)
  )


(defun go-c-function-frame ()
  "Jumps to the C function frame."
  (interactive)
  (activate-frame c-function-frame)
  )


(defun go-c-main-frame ()
  "Jumps to the C main frame."
  (interactive)
  (activate-frame c-main-frame)
  )


(defun go-c-sub-frame ()
  "Jumps to the C sub frame."
  (interactive)
  (activate-frame c-sub-frame)
  )

 



  






