; Written by Thomas Rene Nielsen (trn@imada.ou.dk)
; Notice that these are not public versions, so please don't spread


; Internal stuff
(setq c-function-frame nil)
(setq c-var-frame nil)
(setq c-function-list nil)
(setq c-var-list nil)



(defun clear-c-identifiers ()
  "clears the c indetifier list. "
  (interactive)
  (setq c-function-list nil)
  (setq c-var-list nil)

  (if (frame-live-p c-function-frame)
      (open-c-function-list2))
  (if (frame-live-p c-var-frame)
      (open-c-var-list2))
)


(defun collect-c-identifiers ()
  "Collects all identifiers on the current logical line"
  (interactive)
  (beginning-of-line)
  (let ((start-pos (point)))
    
    (while (looking-at "[ \t]")
      (forward-char 1))
    
    (if (not (looking-at "\n"))
	(if (looking-at "\#")
	    (progn (forward-char 1)
		   (if (string-equal "define" (get-c-word))
		       (progn (forward-char 1)
			      (get-c-identifiers))
		     (end-of-line)))
	  
	  (if (looking-at "\/")
	      (if (looking-at-num 1 "\/")
		  (end-of-line)
		(if (looking-at-num 1 "\*")
		    (search-forward "*/" nil t)))
	    
	    (let ((word (get-c-word)))
	      (if (looking-at "[ ]")
		  (progn (next-c-word)
			 (get-c-identifiers))
		(progn (goto-char start-pos)
		       (next-c-word)
		       (get-c-identifiers))))))))
)



(defun get-c-identifiers ()
  "Does the job for collect-c-identifiers"
   (let ((word nil))
     (while (looking-at "[^\n\}\;\)]") ; Continue if we havn't reached the end of line, semicolon, end bracket or end
       (setq word (get-c-word))
  
       (if (looking-at "[^{}]")
	   (if (looking-at "\(")
	       (progn (if (not (string-equal nil word))
			  (insert-c-function-list word))

		      (next-c-word)

		      (if (looking-at "\)")
			  (progn (get-c-identifiers)
				 (forward-char 1))))
	     (if (and (not (string-equal nil word)) (not (string-equal "break" word)))
		 (insert-c-var-list word)))
	 (forward-char 1))
       
       (if (looking-at "\"")
	   (progn (forward-char 1)
		  (search-forward "\"" nil t)))

       (if (looking-at "[] [&'<=>\t!]")
	   (forward-char 1))
       (if (and (<= ?\* (char-after (point))) (>= ?\: (char-after (point))))
	   (forward-char 1))))
   )




(defun next-c-word ()
  "Jump past spaces and '(' to next expression"
  (while (looking-at "[ \t\n\(]")
    (forward-char 1))
)



(defun get-c-word ()
  "get the next word and place cursor after word"
  (interactive)
  (let ((temp-string nil))
    (if (or (looking-at "\_") (and (<= ?A (char-after (point))) (>= ?Z (char-after (point)))) (and (<= ?a (char-after (point))) (>= ?z (char-after (point)))))
	(progn (setq temp-string (concat temp-string (char-to-string(char-after (point)))))
	       (forward-char 1)
	       (while (or (looking-at "[\-\_]") (and (<= ?A (char-after (point))) (>= ?Z (char-after (point)))) (and (<= ?a (char-after (point))) (>= ?z (char-after (point)))))       
		 (setq temp-string (concat temp-string (char-to-string(char-after (point)))))
		 (forward-char 1))))
    temp-string)
)


(defun insert-c-function-list (word)
  "Inserts 'word' in function-list if 'word' is not there"
  (if (and (not (member word c-function-list)) (> (length word) 0))
      (setq c-function-list (append c-function-list (list word))))
)


(defun insert-c-var-list (word)
  "Inserts 'word' in var-list if 'word' is not there"
  (if (and (not (member word c-var-list)) (> (length word) 0))
      (setq c-var-list (append c-var-list (list word))))
)


(defun show-c-var-list ()
  "This function makes a visual var buffer list"
  (let ((temp c-var-list))
    (while (not (atom temp))
      (insert (car temp))
      (newline 1)
      (setq temp (cdr temp))))
  (sort-lines nil (point-min) (point-max))
)


(defun open-c-var-list ()
  "Opens the fast selection var identifier list. 
Call again to close."
  (interactive)
  (if (frame-live-p c-var-frame)
      (progn (delete-frame c-var-frame)
	     (kill-buffer "Variable Identifiers"))
    (progn (setq c-var-frame (make-frame '((name . "Click to copy")(left . 678)(width . 50)(height . 12)(top . 202)(minibuffer . nil)(menu-bar-lines . 0)(visibility . nil))))
    (open-c-var-list2)))
)

; Call this to update list
(defun open-c-var-list2 ()
  "This function actually does the job"
  (interactive)
  (let ((this-frame (selected-frame))) 
    (select-frame c-var-frame)
    (switch-to-buffer "Variable Identifiers")
    (setq buffer-read-only nil)
    (erase-buffer)
    (show-c-var-list)
    (setq buffer-read-only t)
    (modify-frame-parameters c-var-frame '((visibility . t)))
    (select-frame this-frame))
)


(defun show-c-function-list ()
  "This function makes a visual defun buffer list"
  (let ((temp c-function-list))
    (while (not (atom temp))
      (insert (car temp))
      (newline 1)
      (setq temp (cdr temp))))
  (sort-lines nil (point-min) (point-max))
)


(defun open-c-function-list ()
  "Opens the fast selection c function identifier list. 
Call again to close."
  (interactive)
  (if (frame-live-p c-function-frame)
      (progn (delete-frame c-function-frame)
	     (kill-buffer "Function Identifiers"))
    (progn (setq c-function-frame (make-frame '((name . "Click to copy")(left . 678)(width . 50)(height . 12)(minibuffer . nil)(menu-bar-lines . 0)(visibility . nil))))
    (open-c-function-list2)))
)


(defun open-c-function-list2 ()
  "This function actually does the job"
  (interactive)
  (let ((this-frame (selected-frame))) 
    (select-frame c-function-frame)
    (switch-to-buffer "Function Identifiers")
    (setq buffer-read-only nil)
    (erase-buffer)
    (show-c-function-list)
    (setq buffer-read-only t)
    (modify-frame-parameters c-function-frame '((visibility . t)))
    (select-frame this-frame))
)



(defun collect-all-c-identifiers-buffer ()
  "Collects all the identifiers in the whole buffer"
  (interactive)
  (if (string-equal 'c-mode major-mode)
      (let ((this-pos (point)))
	(goto-char (point-min))
	(collect-c-identifiers)
	(end-of-line)
	(while (< (point) (point-max))
	  (forward-line 1)
	  (collect-c-identifiers)
	  (end-of-line))
	(goto-char this-pos)
	(if (frame-live-p c-function-frame)
	    (open-c-function-list2))
	(if (frame-live-p c-var-frame)
	    (open-c-var-list2))))
)



(defun c-function-list-mouse-action ()
  "Tests if the mouse has clicked in the 'c-function' frame and copies word to kill-ring"
  (if (and (frame-live-p c-function-frame) (eq c-function-frame (selected-frame)))
      (progn (goto-char (position-of-mouse))
	     (beginning-of-line)
	     (let ((start-pos (point)))
	       (end-of-line)
	       (let ((end-pos (point)))
		 (copy-region-as-kill start-pos end-pos)))))
)

 
(defun c-var-list-mouse-action ()
  "Tests if the mouse has clicked in the 'c-var' frame and copies word to kill-ring"
  (if (and (frame-live-p c-var-frame) (eq c-var-frame (selected-frame)))
      (progn (goto-char (position-of-mouse))
	     (beginning-of-line)
	     (let ((start-pos (point)))
	       (end-of-line)
	       (let ((end-pos (point)))
		 (copy-region-as-kill start-pos end-pos)))))
)


; The following functions are the basic  c forms
(defun c-for-loop ()
  "Inserts a C for loop"
  (interactive)
  (newline 2)
  (insert "for(;;) ")
  (backward-char 4)
  (c-indent-command)
)

     
(defun c-conditional ()
  "Inserts C 'if' part"
  (interactive)
  (newline 2)
  (insert "if() ")
  (backward-char 2)
  (c-indent-command)
)
 

;; The following code is written by Simon Crosby. I couldn't find any reason
;; to write my own code for these functions, because Simon's functions does the
;; job nicely. 

;;;--------------------------------------------------------------------
;; Emacs Lisp macros for programming and general use with DragonDictate
;;
;; Copyright (c) Simon Crosby, University of Cambridge 1994, except
;; where stated.
;; 
;; You may freely distribute this code, but must preserve the copyright

;;;--------------------------------------------------------------------

(defun c-do-while ()
  "add a C do while construct at point"
  (interactive)
  (open-line 2)
  (beginning-of-line)
  (insert "do {")
  (c-indent-command)
  (forward-line 1)
  (beginning-of-line)
  (insert "")
  (c-indent-command)
  (let ((pos (point-marker)))
    (forward-line 1)
    (beginning-of-line)
    (insert "} while();")
    (c-indent-command)
    (goto-char (marker-position pos)))
  )


(defun c-while-do ()
  "add a C while construct at point"
  (interactive)
  (open-line 2)
  (beginning-of-line)
  (insert "while(")
  (c-indent-command)
  (let ((pos (point-marker)))
    (insert ") {")
    (c-indent-command)
    (forward-line 1)
    (beginning-of-line)
    (insert "")
    (c-indent-command)
    (forward-line 1)
    (beginning-of-line)
    (insert "}")
    (c-indent-command)
    (goto-char (marker-position pos)))
  )



(defun c-block ()
  "add a C block construct at point"
  (interactive)
  (open-line 2)
  (insert " {")
  (c-indent-command)
  (forward-line 1)
  (beginning-of-line)
  (insert "")
  (c-indent-command)
  (let ((pos (point-marker)))
    (forward-line 1)
    (beginning-of-line)
    (insert "}")
    (c-indent-command)
    (goto-char (marker-position pos)))
  )




(defun c-switch ()
  "add a C switch construct at point"
  (interactive)
  (open-line 7)
  (beginning-of-line)
  (insert "switch(")
  (let ((pos (point-marker)))
    (insert ") {")
    (c-indent-command)
    (forward-line 1)
    (beginning-of-line)
    (insert "case :")
    (c-indent-command)
    (forward-line 1)
    (beginning-of-line)
    (insert "")
    (c-indent-command)
    (forward-line 1)
    (beginning-of-line)
    (insert "break;")
    (c-indent-command)
    (forward-line 1)
    (beginning-of-line)
    (insert "")
    (c-indent-command)
    (forward-line 1)
    (beginning-of-line)
    (insert "default:")
    (c-indent-command)
    (forward-line 1)
    (beginning-of-line)
    (insert "break;")
    (c-indent-command)
    (forward-line 1)
    (beginning-of-line)
    (insert "}")
    (c-indent-command)
    (goto-char (marker-position pos)))
  )


(defun c-new-case ()
  "add a C switch case at point"
  (interactive)
  (open-line 3)
  (beginning-of-line)
  (insert "case ")
  (c-indent-command)
  (let ((pos (point-marker)))
    (insert ":")
    (c-indent-command)
    (forward-line 1)
    (beginning-of-line)
    (insert "")
    (c-indent-command)
    (forward-line 1)
    (beginning-of-line)
    (insert "break;")
    (c-indent-command)
    (forward-line 1)
    (beginning-of-line)
    (insert "")
    (c-indent-command)
    (goto-char (marker-position pos)))
  )





;; Dave Evers functions for commenting regions.
;; Nice job too.
; Hm , jeg er ikke for sikkker paa de to her !
;;  these are useful functions for voice macros
;;  From Dave Evers dme@cl.cam.ac.uk

(defun c-comment-region (beg end)
  "Insert C comments round region"
  (interactive "r")
  (save-excursion
    (let ((end-marker (set-marker (make-marker) end)))
      (goto-char beg)
      (beginning-of-line)
      (insert "/* ")
      (forward-line 1)
      (beginning-of-line)
      (while (< (point) (marker-position end-marker))
        (insert " * ")
        (forward-line 1))
      (beginning-of-line)
      (goto-char (marker-position end-marker))
      (open-line 1)
;      (forward-line 1)
      (beginning-of-line)
      (insert " */")
      (set-marker end-marker nil))))

;;  From Dave Evers dme@cl.cam.ac.uk
(defun c-uncomment-region (beg end)
  "Remove C comments round region created by c-comment-region"
  (interactive "r")
  (save-excursion
    (goto-char beg)
    (beginning-of-line)
    (let ((beg (point)))
      (if (not (looking-at "^/\\*.*\n\\( \\* .*\n\\)* \\*/"))
          (message "I can't see a C comment.") 
          (re-search-forward "^ \\*/")
          (delete-rectangle beg (match-end 0))))))

 

(defun c-skip-forward ()
  "Skips to the next logical place to write, in the standard forms."
  (interactive)
  (let ((end-pos (get-end-pos)))
     (if (re-search-forward "[\"(,;:})]" end-pos t)
	 (if (looking-at-num -1 "\)")
	     (if (search-forward ";" end-pos t)
		 (progn (next-line 1)
			(beginning-of-line))
	       (if (search-forward "{" end-pos t)
		   (progn (next-line 1)
			  (end-of-line)))))
     
       (progn (next-line 1)
	      (setq end-pos (get-end-pos))
	      (beginning-of-line)
	      (if (search-forward "break;" end-pos t)
		  (progn (next-line 1)
			 (setq end-pos (get-end-pos))
			 (beginning-of-line)
			 (if (search-forward "}" end-pos t)
			     (progn (next-line 1)
				    (beginning-of-line))))
		(progn (search-forward "default:" end-pos t)
		       (search-forward "case :" end-pos t)
		       (search-forward "\(" end-pos t)
		       (if (search-forward "}" end-pos t)
			   (next-line 1)))))))
  )



; boer vaere et spejlbillede af c-skip ?!
(defun c-skip-backward ()
  "Skips to the previous logical place to write, in the standard forms."
  (interactive)
  (let ((start-pos (get-start-pos)))
    ; check this line
    (if (not (re-search-backward "[\",;)]" start-pos t))
	(progn (previous-line 1)
	       (setq start-pos (get-start-pos))
	       (end-of-line)
	       (if (not (search-backward ");" start-pos t))
		   (progn (if (search-backward "}" start-pos t)
			      (progn (previous-line 1)
				     (setq start-pos (get-start-pos))
				     (end-of-line)))
			  (if (search-backward "break;" start-pos t)
			      (progn (previous-line 1)
				     (end-of-line)
				     (setq start-pos (get-start-pos))))
			  ;(re-search-backward "[,;)]" start-pos t)
			  )))))
  )
      

(defun c-remark ()
  (interactive)
  (insert "/*  */")
  (backward-char 3)
  )
  





