package india;

import java.awt.*;

/**
 * The Edsac's start button.
 * @author	Colin Watson
 * @version	$Id: StartButton.java,v 1.5 1999/03/05 06:55:28 cjw44 Exp $
 * @see		FloatingButton
 * @see		FrontEnd
 * @see		Edsac
 */

public class StartButton extends FloatingButton
{

	private FrontEnd fe;

	public StartButton(FrontEnd fe, StatusBar status,
			Image unselected, Image selected, Image greyed,
			int x, int y, int width, int height)
		throws ImageLoadingException
	{
		super(status, unselected, selected, greyed,
			x, y, width, height);
		this.fe = fe;
	}

	public void buttonClicked()
	{
		fe.startEdsac();
	}

	public String getName()
	{
		return "Start";
	}

	public String getStatusMessage()
	{
		return "Initialize and run the EDSAC";
	}

}

/*
 * $Log: StartButton.java,v $
 * Revision 1.5  1999/03/05 06:55:28  cjw44
 * Added support for upgraded peeping.
 *
 * Revision 1.4  1999/03/01 16:02:25  cjw44
 * Added a status bar description of the button.
 *
 * Revision 1.3  1999/02/11 10:45:02  cjw44
 * Added x, y, width, and height parameters to the constructor to match
 * FloatingButton and FloatingComponent.
 *
 * Revision 1.2  1999/02/09 04:23:07  cjw44
 * Constructor now throws ImageLoadingException to match FloatingComponent.
 *
 * Revision 1.1  1999/02/04 23:11:29  cjw44
 * Initial revision
 *
 */
