package india;

import java.awt.*;
import java.awt.datatransfer.*;
import java.io.*;

public class Edtest extends Frame
{
  String fileName;
  TextArea contents;

  Button loader;
  Label errorField;
  MenuBar menuBar;
  
  String savedContents="test text";
  
  public Edtest()
  {
    fileName="Untitled 1";
    this.setTitle(fileName+" - Edsac 99");
    contents=new TextArea();
    this.setLayout(new BorderLayout());
    
    Panel pan=new Panel();
    pan.setLayout(new BorderLayout());
    errorField=new Label("Errors here");
    pan.add("Center",errorField);
    loader=new Button("Load Tape");
    pan.add("East",loader);
    this.add("Center",contents);

    this.add("South",pan);
    menuBar=new MenuBar();
    Menu m;
    
    
    
    m=new Menu("File");
    m.add("new");
    //Check if frontend is an application here
    {
      m.add("open");
      m.add("save");
      m.add("save as");
    }
    m.add("close");
    menuBar.add(m);
    
    try
      {
	Toolkit t=Toolkit.getDefaultToolkit();
	Clipboard c=t.getSystemClipboard();
	
	m=new Menu("Edit");
	m.add("copy");
	    m.add("cut");
	    m.add("paste");
	    m.add("select all");
	    menuBar.add(m);
	  }
    catch(Error e)
      {
      }
    
    m=new Menu("Edsac");
    m.add("Load tape");
    m.add("View numbered code");
    menuBar.add(m);
    
    this.setMenuBar(menuBar);
    //    this.resize(300,300);
    this.show();
  }
  
  public boolean handleEvent(Event evt)
  {
    if(evt.id==Event.WINDOW_DESTROY)
      {
	// Put up a box saying "this will lose changes yes/no"
	close();
      }
    return super.handleEvent(evt);
  }
  
  public boolean action(Event evt, Object what)
  {
    if(!(what instanceof String))return false;

    String label=(String)what;
    
    if(label.equals("copy"))
      {
	Toolkit t=Toolkit.getDefaultToolkit();
	Clipboard c=t.getSystemClipboard();
	StringSelection s=new StringSelection(contents.getSelectedText());
	c.setContents(s,s);
	return true;
      }
    if(label.equals("cut"))
      {
	Toolkit t=Toolkit.getDefaultToolkit();
	Clipboard c=t.getSystemClipboard();
	StringSelection s=new StringSelection(contents.getSelectedText());
	c.setContents(s,s);
	contents.replaceText("",contents.getSelectionStart(),contents.getSelectionEnd());
	
	return true;
      }
    if(label.equals("paste"))
      {
	Toolkit t=Toolkit.getDefaultToolkit();
	Clipboard c=t.getSystemClipboard();
	try
	  {
	    String tran=(String)c.getContents(this).getTransferData(DataFlavor.stringFlavor);
	    contents.replaceText(tran,contents.getSelectionStart(),contents.getSelectionEnd());
	  }
	catch(UnsupportedFlavorException e){}
	catch(IOException e){}
	return true;
      }
    if(label.equals("open"))
      {
	// Open a file in another window
	FileDialog dlg=new FileDialog(this,"Open program",FileDialog.LOAD);
	dlg.show();
	this.setTitle(dlg.getFile()+" - Edsac 99");
	fileName=dlg.getDirectory()+dlg.getFile();
	open();
      }
    
    if(label.equals("save"))
      {
	// save this file
	if(fileName.startsWith("Untitled "))
	  {
	    FileDialog dlg=new FileDialog(this,"Save program",FileDialog.SAVE);
	    dlg.show();
	    if(dlg.getFile()==null)return true;
	    System.out.println("dlg.getFile="+dlg.getFile());
	    
	    fileName=dlg.getDirectory()+dlg.getFile();	       
	    this.setTitle(dlg.getFile()+" - Edsac 99");
	    
	    this.save();
	  }	     
      }
    if(label.equals("save as"))
      {
	// save this file with a new name
	FileDialog dlg=new FileDialog(this,"Save program",FileDialog.SAVE);
	dlg.show();
	if(dlg.getFile()==null)return true;
	System.out.println("dlg.getFile="+dlg.getFile());
	fileName=dlg.getDirectory()+dlg.getFile();	       
	this.setTitle(dlg.getFile()+" - Edsac 99");
	this.setTitle(fileName);
	this.save();
      }
    if(label.equals("new"))
      {
	// Are you sure here if changed
	contents.setText("");
      }
    if(label.equals("select all"))
      {
	contents.selectAll();
      }
    if(label.equals("close"))
      {
	close();
      }
    return false;
  }
  
  public void save()
  {
    try
      {
	
	FileWriter fw=new FileWriter(fileName,false);
	String s=contents.getText();
	fw.write(s,0,s.length());
	fw.flush();
	fw.close();
      }
    catch(IOException e)
      {
	System.out.println(e);
	// display an error box here
      }
  }

  public void open()
  {
    try
      {
	FileReader fw=new FileReader(fileName);
	char[]car=new char[1000];
	String str=new String();
	int num=5;
	while(num>0)
	  {
	    num=fw.read(car,0,1000);
	    if(num>0)str=str+new String(car,0,num);
	  }
	contents.setText(str);
      }
    catch(IOException e)
      {
	System.out.println(e);
	// Display an error alert here
      }
  }

  public void close()
  {
    this.hide();
    this.dispose();
  }

  public static void main(String []args)
  {
    Edtest e=new Edtest();
  }
}






