package india;

import java.awt.*;
import java.awt.datatransfer.*;
import java.io.*;
import java.net.*;

public class EditorApplet extends Editor
{
    FrontEndInterface frontEnd;
    String fileName;
    TextArea contents;
    Button loader;
    Label errorField;
    MenuBar menuBar;
    String original;
    RemoteFileMenu subroutines;

    static String currentPath="";

    public EditorApplet(FrontEndInterface fe)
    {
	this(fe,"Untitled - Edsac 99","");
    }
    public EditorApplet(FrontEndInterface fe,String name)
    {
	this(fe,name,"");
    }
    public EditorApplet(FrontEndInterface fe,String name,String text)
    {
	super(fe);


	frontEnd=fe;
	fileName=name;
	this.setTitle(fileName+" - Edsac 99");
	contents=new TextArea(text);
	original=text;
	this.setLayout(new BorderLayout());
	this.resize(300,300);
    
	Panel pan=new Panel();
	pan.setLayout(new BorderLayout());
	errorField=new Label("");
	pan.add("Center",errorField);
	loader=new Button("Load Tape");
	pan.add("East",loader);
	this.add("Center",contents);
	
	this.add("South",pan);
	menuBar=new MenuBar();
	Menu m;
    
	// Try to get a monospaced font
	String[] fonts = Toolkit.getDefaultToolkit().getFontList();
	Font font;
	for(int i = 0; i < fonts.length; i++)
		if(fonts[i].toLowerCase().startsWith("monospaced"))
		{
			Font curFont = getFont();
			font = new Font(fonts[i],
				curFont != null ?
					curFont.getSize() : 12,
				Font.PLAIN);
			if(font != null)
			{
				contents.setFont(font);
				break;
			}
		}
    
    
	m=new Menu("File");
	m.add("New");

	m.addSeparator();
	m.add("Close");
	menuBar.add(m);
	
	m=new Menu("Edsac");
	m.add("Load Tape");
	m.add("Load Tape (without running)");
	menuBar.add(m);

	try
	{
		subroutines=new RemoteFileMenu(new URL(fe.getBase(),"subroutine"));
		menuBar.add(subroutines.getMenu());
	}catch(Exception e){}
	
	
	this.setMenuBar(menuBar);
	
	this.show();
    }

  public boolean handleEvent(Event evt)
  {
    if(evt.id==Event.WINDOW_DESTROY)
      {
	close();
      }
    return super.handleEvent(evt);
  }

  public boolean action(Event evt, Object what)
  {
    if(!(what instanceof String))return false;

	if(evt.target instanceof MenuItem)
	{
		try
		{
			String s=subroutines.getFile((MenuItem)evt.target);
			if(s!=null)
			{
				contents.replaceText(s,contents.getSelectionStart(),contents.getSelectionEnd());
				return true;
			}
		}catch(IOException e){System.out.println(e);}
	}
    String label=(String)what;
    

    if(label.equals("Open..."))
      {
	// Open a file in another window
	FileDialog dlg=new FileDialog(this,"Open program",FileDialog.LOAD);
  	dlg.setDirectory(Editor99.currentPath);
	dlg.show();
	if(dlg.getFile() != null)
	  if(contents.getText().equals(""))
	  {
	      Editor99.currentPath=dlg.getDirectory();
	
	    setTitle(dlg.getFile() + " - Edsac 99");
	    open(dlg.getDirectory() + dlg.getFile());
	  }
	  else
	  {
	    Editor99.currentPath=dlg.getDirectory();
	    Editor editor=frontEnd.newEditor("",dlg.getFile());
	    editor.open(dlg.getDirectory()+dlg.getFile());
	  }
	return true;
      }
    
    if(label.equals("Save"))
      {
	// save this file
	if(fileName.startsWith("Untitled "))
	  {
	    FileDialog dlg=new FileDialog(this,"Save program",FileDialog.SAVE);
	  	dlg.setDirectory(Editor99.currentPath);
	    dlg.show();
	    if(dlg.getFile()==null)return true;
	    Editor99.currentPath=dlg.getDirectory();
	    
	    fileName=dlg.getDirectory()+dlg.getFile();	       
	    this.setTitle(dlg.getFile()+" - Edsac 99");
	    
	    this.save();
	    return true;
	  }
	  else
	  {
	    this.save();
	  }
      }
    if(label.equals("Save as..."))
      {
	// save this file with a new name
	FileDialog dlg=new FileDialog(this,"Save program",FileDialog.SAVE);
  	dlg.setDirectory(Editor99.currentPath);
	dlg.show();
	if(dlg.getFile()==null)return true;
    Editor99.currentPath=dlg.getDirectory();
	fileName=dlg.getDirectory()+dlg.getFile();	       
	this.setTitle(dlg.getFile()+" - Edsac 99");
	this.setTitle(fileName);
	this.save();
	return true;
      }
    if(label.equals("New"))
      {
	// Are you sure here if changed
	  if(!(original.equals(contents.getText())))
	      {
		  YesNoDlg dlg=new YesNoDlg(this,"File modified, clear anyway?","Warning");
		  if(dlg.getValue()==false)return true;
	      }
	contents.setText("");
	original="";
	return true;
      }
    if(label.equals("Select All"))
      {
	contents.selectAll();
	return true;
      }
    if(label.equals("Close"))
      {
	close();
	return true;
      }
    if(label.startsWith("Load Tape"))
	{
	  try
	    {
	      Assembler99 asm=new Assembler99(contents.getText());
	      Tape t=asm.getTape();
	      frontEnd.loadTape(t, !label.endsWith("(without running)"));
	      if(asm.getWarnings()!=null && asm.getWarnings().length!=0)
		  {
		      errorField.setText(asm.getWarnings()[0]);
		  }else errorField.setText("No errors");
	      return true;
	    }
	  catch(AssemblerException e)
	    {
		String s=e+"";
		s=s.substring(s.indexOf("Exception")+9);
	      errorField.setText("Error"+s);
	      contents.select(e.getPos(),e.getPos());
	      return true;
	    }
	  catch(EdsacException e)
	    {
		String s=e+"";
		s=s.substring(s.indexOf("Exception")+9);
	      errorField.setText("Error"+s);
	      return true;
	    }
	  
	}
    return false;
  }
    
    public void save()
  {
    try
      {
	FileWriter fw=new FileWriter(fileName,false);
	String s=contents.getText();
	original=s;
	fw.write(s,0,s.length());
	fw.flush();
	fw.close();
      }
    catch(IOException e)
      {
	ErrorDlg dlg=new ErrorDlg(this,"Cannot save file","Error");
	dlg.show();
	// display an error box here
      }
  }

    public void open(String name)
    {

      try
      {
	fileName=name;
	FileReader fw=new FileReader(fileName);
	char[]car=new char[1000];
	String str=new String();
	int num=5;
	while(num>0)
	  {
	    num=fw.read(car,0,1000);
	    if(num>0)str=str+new String(car,0,num);
	  }
	original=str;
	contents.setText(str);
      }
    catch(IOException e)
      {
	ErrorDlg dlg=new ErrorDlg(this,"Cannot open file","Error");
	dlg.show();
	close();
	// Display an error alert here
      }
  }

  public void close()
  {
    if(!(original.equals(contents.getText())))
    {
	YesNoDlg dlg=new YesNoDlg(this,"File modified, close anyway?","Warning");
	if(dlg.getValue()==false)return;
    }

    frontEnd.removeEditor(this);

  }

    public String getText()
    {
	return contents.getText();
    }

    public void setText(String text)
    {
	contents.setText(text);
    }

    public Tape getTape()throws EdsacException
    {
	Assembler99 asm=new Assembler99(contents.getText());
	Tape t=asm.getTape();
	return t;
    }

  public static void main(String []args)
  {
    Editor e=new Editor99(new FrontEndTest());
    currentPath=".";
  }

}

/*
 * $Log: EditorApplet.java,v $
 * Revision 1.4  1999/03/03 17:38:15  mnw21
 * Fixed log
 *
 * Revision 1.3  1999/02/22 12:24:06  jm266
 * Corrected the subroutine library path
 *
 * Revision 1.2  1999/02/19 15:57:29  jm266
 * *** empty log message ***
 *
 * Revision 1.9  1999/02/19 15:53:17  jm266
 * Sorted out a couple of silly bugs.
 *
 * Revision 1.5  1999/02/14 16:45:42  jm266
 * Sorted out subroutine loading.
 * Directory file is ./subroutine
 * or APPLET_BASE/subroutine
 *
 */
