/**
      * A class which handles the text editor window.
      *
      * @author  Joseph Marshall
      * @version $Id: Editor.java,v 1.3 1999/02/05 18:26:38 jm266 Exp $
      * @see     india.FrontEnd
      */

package india;

import java.awt.*;

public abstract class Editor extends Frame 
// JM:I didn't implement WindowListener because this window needs
// very little event handling so programming it using HandleEvent is
// trivial and 1.0 compatible. I've got an example of doing this so
// when coding it check that.

{
    
    /**
     * Makes a new Editor window with no name or text.
     * @param fe the FrontEndInterface that owns this window.
     *  This is needed to be able to implement the window list etc.
     */
    
    public Editor(FrontEndInterface fe)
    {
    }
    
    /**
     * Makes a new Editor window initialised with a name and some text.
     * @param fe the FrontEnd object that owns this window.
     *  This is needed to be able to implement the window list etc.
     * @param text the text to initialise the window with
     */
    
    public Editor(FrontEndInterface fe,String name,String text)
    {
    }

    /**
     * Destructor, checks if file is saved in the Application version.
     */
    
    protected void finalize()
    {
    }

    /**
     * Sets the text of the window.
     * @param text the text to put in the window
     */
    public abstract void setText(String text);
    
    /**
     * Returns the text of the window.
     * @return the text currently in the window
     */
    public abstract String getText();
    
    /**
     * Returns the window text as a Tape object. This
     * will have been passed through the assembler to remove
     * labels and comments.
     * @return the Tape object representing the program currently in the window
     * @throws EdsacException if you use illegal characters, don't close comments,
     * 		use unknown labels etc.
     */
    public abstract Tape getTape() throws EdsacException;


    /**
     *
     * Opens this file in this window. Closes the window on error
     *
     */
    public abstract void open(String filename);
}
