package india;

import java.awt.*;

/**
 * One of the two buttons that are part of the CRT selector.
 * @author	Colin Watson
 * @version	$Id: CRTSelectorButton.java,v 1.3 1999/03/05 06:55:28 cjw44 Exp $
 * @see		FloatingButton
 * @see		CRTSelector
 */

public class CRTSelectorButton extends FloatingButton
{

	private CRTSelector selector;
	private boolean up;

	public CRTSelectorButton(CRTSelector selector, StatusBar status,
			Image unselected, Image selected,
			int x, int y, int width, int height, boolean up)
		throws ImageLoadingException
	{
		// no greyed-out image
		super(status, unselected, selected, unselected,
			x, y, width, height);
		this.selector = selector;
		this.up = up;
	}

	public void buttonClicked()
	{
		selector.changeTank(up, 1);
	}

	public String getName()
	{
		return up ? "Next" : "Previous";
	}

	public String getStatusMessage()
	{
		return up ?
			"Display the next long tank" :
			"Display the previous long tank";
	}

}

/*
 * $Log: CRTSelectorButton.java,v $
 * Revision 1.3  1999/03/05 06:55:28  cjw44
 * Added support for upgraded peeping.
 *
 * Revision 1.2  1999/03/01 16:07:10  cjw44
 * Added a status bar description of each button.
 *
 * Revision 1.1  1999/02/22 00:46:04  cjw44
 * Initial revision
 *
 */
