package india;

import java.awt.*;

/**
 * An about box, displaying information about the Edsac simulator.
 * @author	Colin Watson
 * @version	$Id: AboutBox.java,v 1.4 1999/02/28 23:44:41 cjw44 Exp $
 * @see		FrontEnd
 */

public class AboutBox extends Frame
{

	private static String[] names = {
		"Alan Mitchell (ajm86@cam.ac.uk)",
		"    - Project Lead",
		"Matthew Wakeling (mnw21@cam.ac.uk)",
		"    - Technical Lead",
		"Chris Town (cpt23@cam.ac.uk)",
		"    - Testing and EDSAC programming",
		"Colin Watson (cjw44@cam.ac.uk)",
		"    - User interface programming",
		"Dom Penfold (djrcp2@cam.ac.uk)",
		"    - Website and graphic design",
		"James Slorach (jrs47@cam.ac.uk)",
		"    - Testing and test harnesses",
		"Joseph Marshall (jm266@cam.ac.uk)",
		"    - Kernel and EDSAC programming"};

	public AboutBox(Image logo)
	{
		super("About EDSAC 1999");
		try
		{
			add("West", new Logo(logo));
		} catch(ImageLoadingException e) {}
		Panel p = new Panel();
		p.setLayout(new BorderLayout());
		p.add("North",
			new Label("Written by the India Programming Team:"));
		StringBuffer creditsMessage = new StringBuffer();
		int maxlength = 0;
		for(int i = 0; i < names.length - 1; i++)
		{
			creditsMessage.append(names[i]);
			creditsMessage.append('\n');
			if(names[i].length() > maxlength)
				maxlength = names[i].length();
		}
		creditsMessage.append(names[names.length - 1]);
		TextArea credits = new TextArea(
			creditsMessage.toString(), names.length, maxlength);
		credits.setEditable(false);
		p.add("Center", credits);
		add("Center", p);
		p = new Panel();
		p.add(new Button("OK"));
		add("South", p);
		pack();
		setResizable(false);
	}

	public boolean handleEvent(Event event)
	{
		if(event.id == Event.WINDOW_DESTROY)
		{
			hide();
			return true;
		}
		return super.handleEvent(event);
	}

	public boolean action(Event event, Object what)
	{
		if(!(what instanceof String))
			return super.action(event, what);
		if(((String)what).equals("OK"))
		{
			hide();
			return true;
		}
		return super.action(event, what);
	}

}

/*
 * $Log: AboutBox.java,v $
 * Revision 1.4  1999/02/28 23:44:41  cjw44
 * General revamp: added logo and names of project members.
 *
 * Revision 1.3  1999/02/11 10:36:26  cjw44
 * Turned AboutBox back into a modal dialog, since, with an OK button to close
 * the window, it doesn't matter whether a title bar is present or not.
 * Enclosed the OK button in a Panel to stop it being stretched to fill the
 * available space.
 *
 * Revision 1.2  1999/02/09 06:42:36  cjw44
 * Changed to subclass Frame instead of Dialog, since Dialog seems to have no
 * title bar under Linux.
 * Added handling for the window being closed.
 * Added an "OK" button which also closes the window.
 *
 * Revision 1.1  1999/02/06 22:29:52  cjw44
 * Initial revision
 *
 */
