package india;

public class EdsacDebug extends Edsac
{
	private long nextSequence=0; // the next SCR value
	private long lastCharacter=0; // the last character output
	private boolean letter_shift=true;
	private static final String PRINTER_CHARACTERS="PQWERTYUIOJ SZK  F\rD HNM\nLXGABCV";
	private static final String PRINTER_NUMBERS="0123456789  \"+(  $\r; ,.\n)/#-?:=";



	public static final int OPCODE_A=28;
	public static final int OPCODE_S=12;
	public static final int OPCODE_H=21;
	public static final int OPCODE_V=31;
	public static final int OPCODE_N=22;
	public static final int OPCODE_T=5;
	public static final int OPCODE_U=7;
	public static final int OPCODE_C=30;
	public static final int OPCODE_R=4;
	public static final int OPCODE_L=25;
	public static final int OPCODE_E=3;
	public static final int OPCODE_G=27;
	public static final int OPCODE_I=8;
	public static final int OPCODE_O=9;
	public static final int OPCODE_F=17;
	public static final int OPCODE_X=26;
	public static final int OPCODE_Y=6;
	public static final int OPCODE_Z=13;

	public EdsacDebug(FrontEndInterface fe)
	{
		super(fe);
	}


	long totalTime=0;

	public synchronized void clear()
	{
		System.err.println("EdsacDebug.clear() called");
	}

	public synchronized void initialise(int[]initialOrders)
	{
		System.err.println("EdsacDebug.initialise("+initialOrders+") called");
	}

// private methods removed.

	public synchronized void singleStep(Tape ta)throws EdsacException
	{
		System.err.println("EdsacDebug.singleStep(tape) called");
	}


	public synchronized long getMultiplier()
	{
		System.err.println("EdsacDebug.getMultplier() called");
		return multiplier;
	}
	public synchronized long getMultiplicand()
	{
		System.err.println("EdsacDebug.getMultiplicand() called");
		return multiplicand;
	}
	public synchronized long getOrder()
	{
		System.err.println("EdsacDebug.getOrder() called");
		return order;
	}
	public synchronized long getSequenceControl()
	{
		System.err.println("EdsacDebug.getSequenceControl() called");
		return sequenceControl;
	}
	public synchronized Accumulator getAccumulator()
	{
		System.err.println("EdsacDebug.getAccumulator() called");
		return new Accumulator(accumulator);
	}
	public synchronized void setAccumulator(Accumulator acc)
	{
		System.err.println("EdsacDebug.setAccumulator() called");
		accumulator=acc;
	}
	public synchronized long getEdsacTime()
	{
		System.err.println("EdsacDebug.setEdsacTime() called");
		return totalTime;
	}
	public synchronized void zeroEdsacTime()
	{
		System.err.println("EdsacDebug.zeroEdsacTime() called");
		totalTime=0;
	}

	public synchronized int[]getMemoryTank(int tank) throws EdsacException
	{
		System.err.println("EdsacDebug.getMemoryTank() called");
		int[]tankData=new int[32];
		if(tank>31 || tank<0)
		  throw(new EdsacException("Bad tank number ["+tank+"] in getMemoryTank") );
		try
		{
			System.arraycopy(memory,32*tank,tankData,0,32);
		}
		catch(Exception e)
		{
			throw(new EdsacException("Unexpected exception ["+e+"] in getMemoryTank") );
		}
		return tankData;
	}


}

// $Log: EdsacDebug.java,v $
// Revision 1.1  1999/02/07 17:30:29  mnw21
// Initial revision
//
