
/**
	  * A class to convert between labelled and non-labelled assembler
      * 
      * @author  Joseph Marshall
      * @version $Id: Assembler99.java,v 1.13 1999/02/23 23:39:45 jm266 Exp $
      */




package india;

import java.util.*;

public class Assembler99 extends Assembler
{
	String output=null;
	Vector Warnings=null;

	public String[] getWarnings()
	{
		if(Warnings==null)return null;
		String[]temp=new String[Warnings.size()];
		Warnings.copyInto(temp);
		return temp;
		
	}
	
	public Assembler99(String s)throws AssemblerException
	{
		super(s);
		s=s.toUpperCase();
		// which can be input for the program or something. 
		Vector labels=new Vector(32);
		Vector labelPositions=new Vector(32);
		Vector instructions=new Vector(256);
		Vector instructionPositions=new Vector(256);
		Warnings=new Vector(10);
		// First pass:- find labels and remove comments

		String trimmed=new String(); // this stores the string trimmed down
		// first loop:- clear white space and comments, gather names of labels
		for(int c=0;c<s.length();)
		{
//			System.out.print(s.charAt(c));
			switch(s.charAt(c))
			{
				case ':':
					try
					{
						int pos=s.indexOf(":",c+1);
						String label=s.substring(c+1,pos);
						for(int d=0;d<labels.size();d++)
						{
							if(label.equals((String)labels.elementAt(d)))
							{
								throw(new AssemblerException("Duplicate label"+label,c));
							}
						}
						for(int d=0;d<label.length();d++)
						{
							if(!Character.isLetterOrDigit(label.charAt(d)))
							{
								throw(new AssemblerException("Non-alphabet character in label"+label,c));
							}
						}
						labels.addElement(label);
						c=pos+1;
						trimmed=trimmed+":"+label+":";
					}
					catch(StringIndexOutOfBoundsException e)
					{
						throw(new AssemblerException("Label not closed"+s.substring(c),c));
					}
					break;
				case ' ':
				case '\n':
				case '\r':
				case '\t':
					c++;
					break;
				case '[':
					try
					{
						int pos=s.indexOf(']',c+1);
						if(pos==-1)
					    	throw(new AssemblerException("Comment not closed"+s.substring(c),c));
					    c=pos+1;
					}
					catch(StringIndexOutOfBoundsException e)
					{
						throw(new AssemblerException("Comment not closed"+s.substring(c),c));
					}
					break;
					
				case '/':
					if(c+1>=s.length())break; // Catch the end of the string
					if(s.charAt(c+1)=='*')
					{
						int pos=s.indexOf("*/",c+2);
						if(pos==-1)throw(new AssemblerException("Comment not closed"+s.substring(c),c));
						c=pos+2;
					}
					else
						if(s.charAt(c+1)=='/')
						{
							int pos=s.indexOf('\n',c+2);
							int pos2=s.indexOf('\r',c+2);
							if(pos==-1)pos=pos2;
							if(pos2<pos && pos2!=-1)pos=pos2;
							if(pos==-1)
							{
								pos=s.length()-1;
							}
							c=pos+1;
						}
					break;
				case 'C':
				case 'c': // is this 'const blah'
					if(c+1>=s.length()) // Catch the end of the string
					{
						trimmed=trimmed+s.charAt(c);
						c++;
					}
 					else if(s.startsWith("ONST(",c+1))
				    {
				    	if(s.indexOf(",D)",c+6)!=-1 &&(s.indexOf(",D)",c+6)<s.indexOf(")",c+6)))
				    	{
				    		try
				    		{
						    	String value=s.substring(c+6,s.indexOf(",D)",c+7)).trim();
						    	double number=(new Double(value)).doubleValue();
						    	String instruct;
						    	long instval;
						    	if(number<1 && number>=-1)number=number*Math.pow(2,34);
						    	instval=(long)number;
	//					    	System.out.println(value+":"+number+":"+instval);
								instruct=""+Tape.chars1.charAt((int)((instval>>12)&0x1f));
								instruct+=(instval>>1)&0x7ff;
								if((instval&0x01)!=0)instruct+="D";
								  else instruct+="F";
								instruct+=Tape.chars1.charAt((int)((instval>>30L)&0x1f));
								instruct+=(instval>>19L)&0x7ff;
								if(((instval>>18L)&0x01)!=0)instruct+="D";
								  else instruct+="F";

								if(((instval>>17)&0x01)!=0)
								{
									Warnings.addElement("Constant "+value+" cannot be represented exactly");
									// throw a warning about this constant here
								}
	//							System.out.println(instruct);
								trimmed+=instruct;
								c=s.indexOf(",D)",c+7)+3;
					    	}
							catch(NumberFormatException e)
						    {
						    	throw(new AssemblerException("Bad constant:"+s.substring(c),c));
						    }

				    	}
					    else if(s.indexOf(",F)",c+6)!=-1  &&(s.indexOf(",F)",c+6)<s.indexOf(")",c+6)))
					    {
					    	try
					    	{
							   	String value=s.substring(c+6,s.indexOf(",F)",c+7)).trim();
							   	double number=(new Double(value)).doubleValue();
						    	String instruct;
						    	int instval;
		//					    	System.out.print(value+":"+number);
						    	if(number<1 && number>=-1)number=number*Math.pow(2,16);
						    	instval=(int)number;
								instruct=""+Tape.chars1.charAt((instval>>12)&0x1f);
								instruct+=(instval>>1)&0x7ff;
								if((instval&0x01)!=0)instruct+="D";
								  else instruct+="F";
		//							System.out.println(instruct);
								trimmed+=instruct;
								c=s.indexOf(",F)",c+7)+3;
						    }
						    catch(NumberFormatException e)
						    {
						    	throw(new AssemblerException("Bad constant:"+s.substring(c),c));
						    }
					    }
						else throw(new AssemblerException("Constant not closed:"+s.substring(c),c));
					    		// Unclosed constant				   
				    }
				    else
				    {
						trimmed=trimmed+s.charAt(c);
						c++;
				    }
				    break;
				default:
					trimmed=trimmed+s.charAt(c);
					c++;
					break;
			}
		}

//		System.out.println(trimmed);

		// Second pass:- bracket labels and
		// work out where each label is in the Edsac memory
		// split instructions up:-
		// This puts each instruction into a seperate String in the instructions vector
		// InstructionPositions holds Integer objs which have the position in memory this
		// instruct'n is loaded at
		
		int omega=0;   //The current value of omega (@)
		int base=44;   //The base of the current section
		int current=44; //The current instruction pos in memory
		String currentText=new String();
		labelPositions.setSize(labels.size());

		// When we get to an EnZ / EnK instruction then stop labelling etc.
		// until we get to blank tape "." followed by pz / pk
		// After blank tape is the start of an instruction

		for(int c=0;c<trimmed.length();)
		{
		    try
		    {
//			System.out.println("2:"+c+":"+current+":"+omega+":"+currentText+trimmed.length());
			int pos=c;
			boolean foundLabel=false;

			currentText=new String(); 

/*			while(trimmed.charAt(pos)=='.'){currentText+='.';pos++;}
			if(trimmed.charAt(c)=='.')
			{
				instructions.addElement(currentText);
				instructionPositions.addElement(new Integer(omega));
				c=pos;
			}*/
			currentText=new String();

			if(trimmed.charAt(pos)==':')
			{
				try
				{
					int lpos=trimmed.indexOf(":",pos+1);
					String label=trimmed.substring(pos+1,lpos);
//					System.out.print("label:"+ label);
					for(int d=0;d<labels.size();d++)
					{
						if(((String)labels.elementAt(d)).equals(label))
						{
							labelPositions.setElementAt(new Integer(current),d);
//							System.out.println(" set to "+(current));
						}
					}
					c=lpos+1;
				}
				catch(StringIndexOutOfBoundsException e)
				{
					// Bad label handler here
				}
			}
			if(trimmed.charAt(pos)==':')continue;
			


			currentText+=trimmed.charAt(pos);// get function letter
			pos++;
		 
			
		     
			// Very inefficient check if there is a label name here:-
			int labelLength=0;
			// the longest label so far
			// this is needed so that it doesn't see "loopstart" as being
			// "loop" where both labels are used
			int newpos=pos;
			String addtext=new String();
			for(int d=0;d<labels.size();d++)
			{
				if(((String)labels.elementAt(d)).length()>labelLength)
				  if(trimmed.startsWith((String)labels.elementAt(d),pos))
				{
					foundLabel=true;
					addtext=(String)labels.elementAt(d);
					newpos=pos+((String)labels.elementAt(d)).length();
					labelLength=((String)labels.elementAt(d)).length();
				}
			}
			pos=newpos;
			currentText+=addtext;
			
			if(!foundLabel)
			  while(pos<trimmed.length()&& Character.isDigit(trimmed.charAt(pos)))
			  {
			  	currentText+=trimmed.charAt(pos);
			  	pos++;
			  }

			
			if(trimmed.charAt(pos)=='#')
			{
				currentText+='#';
				pos++;
			}
			currentText+=trimmed.charAt(pos);

			// Now we have 1 instruction:- check if a control code
			
			if(trimmed.charAt(pos)=='K' || trimmed.charAt(pos)=='Z')
			{
				char functionLetter=currentText.charAt(0);
				String postfix=currentText.charAt(currentText.length()-1)+"";
				String argument;
				if(currentText.charAt(currentText.length()-2)=='#')
					argument=currentText.substring(1,currentText.length()-2);
				  else argument=currentText.substring(1,currentText.length()-1);
				switch(currentText.charAt(0))
				{
					case 'E':
					// Enter the program. Can now pass through anything until we find
					// a ..PK or ..PZ
						int skipTo=trimmed.indexOf("..PK",pos);
						if(skipTo==-1)skipTo=trimmed.length()-2;
						if(trimmed.indexOf("..PZ",pos)!=-1 && skipTo>trimmed.indexOf("..PZ",pos))
							skipTo=trimmed.indexOf("..PZ",pos);
						skipTo+=2;
						instructions.addElement(currentText);
						instructionPositions.addElement(new Integer(omega));
						c=c+currentText.length();					
						currentText=trimmed.substring(pos+1,skipTo);
						instructions.addElement(currentText);
						instructionPositions.addElement(new Integer(omega));
						pos=skipTo;
//						System.out.println(c+":"+pos);
						break;
					case 'G':
					// Set the "@" parameter to the current position+argument
						if(argument.length()==0)
						{
							omega=current;
							instructions.addElement(currentText);
							instructionPositions.addElement(new Integer(omega));
							
						}
						else
						{
							try
							{
								omega=current+Integer.parseInt(argument);
								omega&=0x3ff;
								instructions.addElement(currentText);
								instructionPositions.addElement(new Integer(omega));
								
							}
							catch(NumberFormatException e)
							{
								// Can't use a label in a GK instruction
							}
						}
						break;
					case 'T':
					// Set the current load address to the argument (plus omega if Z)
						if(argument.length()==0)
						{
							current=0;
							if(postfix.charAt(0)=='Z')current+=omega;
							instructions.addElement(currentText);
							instructionPositions.addElement(new Integer(omega));
						}
						else
						{
							try
							{
								current=Integer.parseInt(argument);
								if(postfix.charAt(0)=='Z')current+=omega;
								current&=0x3ff;
								instructions.addElement(currentText);
								instructionPositions.addElement(new Integer(omega));
							}
							catch(NumberFormatException e)
							{
								// Can't use a label in a TK instruction
								
							}
						}
						break;
					case 'O':
					case 'P':
					case 'Z':
						instructions.addElement(currentText);
						instructionPositions.addElement(new Integer(omega));
						break;
				}
			}else
			{
				instructions.addElement(currentText);
				instructionPositions.addElement(new Integer(omega));
				current++;
			}
			c=c+currentText.length();
		    }
		    catch(StringIndexOutOfBoundsException e)
		    {
			instructions.addElement(currentText);
			instructionPositions.addElement(new Integer(omega));
			c=trimmed.length();
		    }

		}

		// Third pass:- replace labels 
		for(int c=0;c<instructions.size();c++)
		{
//			System.out.println("3:"+c);
			String instr=(String)instructions.elementAt(c);
//			System.out.println(instr);
			int labelLength=0;
			int bestLabel=-1;

			for(int d=0;d<labels.size();d++)
			{
				String lab=(String)labels.elementAt(d);
				if(lab.length()>labelLength && instr.startsWith(lab,1))
				{
					bestLabel=d;
					labelLength=lab.length();
				}
			}
			if(bestLabel!=-1)
			{
				String lab=(String)labels.elementAt(bestLabel);

			//					System.out.print("Replace Label "+lab+" in "+instr+" with ");
				String temp=instr.substring(0,1);
				if(instr.charAt(instr.length()-1)=='F' ||instr.charAt(instr.length()-1)=='D' ||instr.charAt(instr.length()-1)=='K')
				  {
	//				  	System.out.println(labelPositions);
				  temp=temp+(((Integer)labelPositions.elementAt(bestLabel)).intValue());
				  temp=temp+instr.substring(lab.length()+1);
				  }
				  else
				  {
				  	if(instr.charAt(instr.length()-1)=='Z')temp=temp+((((Integer)labelPositions.elementAt(bestLabel)).intValue()-((Integer)instructionPositions.elementAt(c)).intValue())&0x3ff)+instr.substring(lab.length()+1);
					  	  else temp=temp+((((Integer)labelPositions.elementAt(bestLabel)).intValue()-((Integer)instructionPositions.elementAt(c)).intValue())&0x3ff)+instr.substring(lab.length()+1,instr.length()-1)+"@";
				  }
	//				System.out.println(temp);
				instructions.setElementAt(temp,c);
			}

		}

			// Collate this into a big string
		output=new String();
		for(int c=0;c<instructions.size();c++)
		{
			output+=(String)instructions.elementAt(c);
		}
	}
	public String getText() // Gets EDSAC assembler as text
	{
		return output;
	}
  	public Tape getTape()throws EdsacException// Gets an EDSAC tape object for this program.
  	{
  		return new Tape(this.getText());
  	}

  public String getNumbers()
  {
    return "";
  }
}

/*
 *$Log: Assembler99.java,v $
 *Revision 1.13  1999/02/23 23:39:45  jm266
 *Made it take digits as part of a label.
 *
# Revision 1.12  1999/02/17  23:44:34  cjw44
# Fixed problem with RCS log where nested comments were confusing javac
# somewhat.
#
 *Revision 1.11  1999/02/17 01:18:37  jm266
 *Support for [ comments] made it notice unterminated
 *slash-star comments
 *
# Revision 1.10  1999/02/14  15:02:08  jm266
# removed a bug with blank tape characters.
#
 *Revision 1.9  1999/02/09 16:25:02  jm266
 *Hopefully completely sorted the label bug, had forgotten to set
 *the current label length at line 272
 *
 *Revision 1.5  1999/02/08 22:20:14  jm266
 *sorted a couple of minor bugs with constants
 *
 *Revision 1.4  1999/02/05 18:29:27  jm266
 *Sorted out the string exceptions that were thrown everywhere
 *sorted the text of the exceptions thrown for the editor.
 *
# Revision 1.3  1999/02/05  01:55:56  jm266
# constants as per specification.
#
# Revision 1.2  1999/02/03  19:01:12  jm266
# Debugged somewhat, works at least on the fibonacci example I wrote to test
# it with!
#*/
