package india;

/**
 * A thread capable of running an Edsac by repeatedly single-stepping until
 * it is interrupted.
 * @author	Colin Watson
 * @version	$Id: EdsacThread.java,v 1.12 1999/02/25 13:49:58 jm266 Exp $
 * @see		Edsac
 * @see		FrontEnd
 */

public class EdsacThread extends Thread
{

	private FrontEnd fe;
	private Tape tape;
	private volatile boolean killed = false;

	public EdsacThread(FrontEnd fe, Tape tape)
	{
		this.fe = fe;
		this.tape = tape;
		setPriority(MIN_PRIORITY);
	}

	public void run()
	{
		while(!killed)
			fe.singleStepEdsac(tape);
		killed=true;
	}

	public void stopRequest()
	{
		killed = true;
		//try
		{
		    //	join();
		    if(!killed)setPriority(MAX_PRIORITY);
		    Thread.currentThread().yield();
		    Thread.currentThread().yield();
		}
		// catch(InterruptedException e)
		//{
			// This is the main program thread; it shouldn't be
			// interrupted.
		//}
	}

	public void killThread()
	{
		killed = true;
	}

}

/*
 * $Log: EdsacThread.java,v $
 * Revision 1.12  1999/02/25 13:49:58  jm266
 * put in the check before setting the priority.
 *
 * Revision 1.11  1999/02/25 13:41:08  jm266
 * Thread.currentThread().yield() not Thread.yield() dohhhh.
 *
 * Revision 1.10  1999/02/24 17:01:22  jm266
 * Ok, this is now the biggest kludge ever so that it will work in netscape /
 * linux / hopefully nt.
 *
# Revision 1.9  1999/02/15  19:08:29  cjw44
# Changed method of stopping an EdsacThread from interrupted() to a volatile
# boolean, at Joe's suggestion - it doesn't work otherwise, at least not
# always.
#
 * Revision 1.8  1999/02/12 18:44:55  cjw44
 * Fixed a bug in thread priorities which was causing the event dispatching
 * thread to be locked out. It seems that the Java VM operates a round-robin
 * thread scheduling policy. However, it also operates a priority system -
 * badly, as far as I can tell. If a thread at priority n is runnable, no
 * thread at priority n - 1 or below will ever be run. It seems that the fact
 * that the EdsacThread had a priority (probably) higher than the event
 * dispatching thread, possibly combined with the bug in
 * FrontEnd.singleStepEdsac(Tape) (q.v.), locked out the EDT (almost)
 * completely. This has now been fixed.
 *
 * Revision 1.7  1999/02/11 10:33:11  cjw44
 * Removed exception catch from run(), as FrontEnd.singleStepEdsac() now
 * handles EdsacExceptions itself.
 *
 * Revision 1.6  1999/02/10 12:28:43  cjw44
 * Removed sleep period.
 *
 * Revision 1.5  1999/02/09 15:39:17  cjw44
 * Changed constructor to take a FrontEnd rather than an Edsac, so that all
 * single-stepping goes through the FrontEnd (this makes sure things get
 * repainted properly and so on).
 * Added sleep period at the end of each cycle, controlled by the constant
 * SLEEP_PERIOD.
 * run() no longer synchronized - it's unnecessary, and we spend enough time
 * trying to gain locks as it is.
 *
 * Revision 1.4  1999/02/06 16:41:33  cjw44
 * Changed name of stop() to stopRequest(), since stop() in class Thread is
 * final.
 * Made run catch EdsacException from edsac.singleStep(tape).
 *
 * Revision 1.3  1999/02/04 18:35:20  cjw44
 * Updated to use tapes.
 *
 * Revision 1.2  1999/01/22 18:05:16  cjw44
 * Added @see reference to Edsac.
 *
 * Revision 1.1  1999/01/22 17:57:30  cjw44
 * Initial revision
 */
