package india;

import java.applet.Applet;
import java.awt.*;

/**
 * The top-level class which should be called by the Java system to actually
 * run the simulator. Whether run as an applet or an application, it
 * instantiates a MainFrame and passes control to it.
 * @author	Colin Watson
 * @version	$Id: EdsacSimulator.java,v 1.5 1999/03/10 07:51:20 cjw44 Exp $
 * @see		MainFrame
 */

public class EdsacSimulator extends Applet implements Runnable
{

	private MainFrame mf;
	private Button restartButton;

	public void init()
	{
		setLayout(new BorderLayout());
		setBackground(Color.white);
	}

	public void start()
	{
		try
		{
			mf = new MainFrame(true, this);
			if(countComponents() == 1)
				add("South", restartButton = new Button(
					"Restart simulator"));
			resize(preferredSize());
			mf.show();
		} catch(ImageLoadingException e)
		{
			if(mf != null)
				mf.dispose();
		}
	}

	public void stop()
	{
		if(mf != null)
			mf.dispose();
	}

	public void run()
	{
		start();
	}

	public boolean action(Event event, Object what)
	{
		if(event.target == restartButton)
		{
			stop();
			new Thread(this).start();
			return true;
		}
		return false;
	}

	public static void main(String[] argv)
	{
		// May want to do something with the arguments at some
		// stage ...
		try
		{
			MainFrame mf = new MainFrame(false, null);
			mf.show();
		} catch(ImageLoadingException e) {}
	}

}

/*
 * $Log: EdsacSimulator.java,v $
 * Revision 1.5  1999/03/10 07:51:20  cjw44
 * Added facility to restart simulator in an applet after the various frames
 * have been closed.
 *
 * Revision 1.4  1999/02/19 00:02:04  cjw44
 * Any problems with loading images will now stop the main frame from being
 * shown.
 *
 * Revision 1.3  1999/02/12 19:00:29  cjw44
 * MainFrame is now passed an Applet parameter, which, if we're running as an
 * applet, allows it to fetch image files over the network.
 *
 * Revision 1.2  1999/02/10 17:22:21  cjw44
 * Removed repaint() calls as they're unnecessary.
 *
 * Revision 1.1  1999/02/09 07:01:27  cjw44
 * Initial revision
 *
 */
