package india;

import java.awt.Graphics;

/**
 * A thread that turns the phone dial.
 * @author	Colin Watson
 * @version	$Id: DialTurner.java,v 1.2 1999/03/10 13:39:12 cjw44 Exp $
 * @see		PhoneDial
 */

public class DialTurner implements Runnable
{

	private static final double DEG2RAD = Math.PI / 180.0;

	private PhoneDial dial;
	private int hole;
	private int x, y, radius;

	public DialTurner(PhoneDial dial, int hole, int x, int y, int radius)
	{
		this.dial = dial;
		this.hole = hole;
		this.x = x;
		this.y = y;
		this.radius = radius;
	}

	public void run()
	{
		Graphics g = dial.getGraphics();
		int maxangle = 30 * (hole == 0 ? 10 : hole);
		dial.darken(x, y, radius);
		long startTime = System.currentTimeMillis();
		dial.redraw(0, g);
		long redrawTime = System.currentTimeMillis() - startTime;
		double incr = maxangle * redrawTime / 300.0;
		if(incr > 30.0) incr = 30.0;
		for(double angle = 0; angle <= maxangle; angle += incr)
		{
			dial.redraw(angle * DEG2RAD, g);
			long time = System.currentTimeMillis();
		}
		try
		{
			Thread.sleep(200);
		} catch(InterruptedException e) {}
		incr /= 2.0;
		for(double angle = maxangle; angle >= 0; angle -= incr)
			dial.redraw(angle * DEG2RAD, g);
		dial.restore(x, y, radius);
		dial.redraw(0, g);
		dial.doneTurning(hole);
	}

}

/*
 * $Log: DialTurner.java,v $
 * Revision 1.2  1999/03/10 13:39:12  cjw44
 * Added synchronization to system speed.
 *
 * Revision 1.1  1999/02/23 23:50:50  cjw44
 * Initial revision
 *
 */
