package india;

/**
      * A class representing an Edsac punched tape
      *
      * 
      * @author  Joseph Marshall
      * @version $Id: Tape.java,v 1.4 1999/03/03 17:39:15 mnw21 Exp $
      * @see     india.Edsac
      */


public class Tape
{
    /**
     * The values of the tape characters.
     * Will not need to be updated often so an array is fine.
     */
	private int []tapeValues;

	int pos=0;

	static final String chars1="PQWERTYUIOJ#SZK*.F@D!HNM&LXGABCV";
	static final String chars2="pqwertyuioj#szk*.f@d!hnm&lxgabcv";
	static final String nums="0123456789ZZZZZZZZZZZ+-";

	
	public Tape()
	{
		tapeValues=new int[1];
	}
	public Tape(String s) throws EdsacException
	{
		tapeValues=new int[s.length()];
		for(int c=0;c<s.length();c++)
		{
			char currentChar=s.charAt(c);
			if(chars1.indexOf(currentChar)!=-1)tapeValues[c]=chars1.indexOf(currentChar);
			 else if(chars2.indexOf(currentChar)!=-1)tapeValues[c]=chars2.indexOf(currentChar);
	  	     else if(nums.indexOf(currentChar)!=-1)tapeValues[c]=nums.indexOf(currentChar);
	  	       else throw(new EdsacException("Undefined character:"+(char)s.charAt(c)));
		}
	}
	
	public void append(String s)throws EdsacException
	{
		int[]temp;
		temp=new int[s.length()+tapeValues.length];
		System.arraycopy(tapeValues,0,temp,0,tapeValues.length);
		for(int c=tapeValues.length;c<temp.length;c++)
		{
			char currentChar=s.charAt(c);
			if(chars1.indexOf(currentChar)!=-1)tapeValues[c]=chars1.indexOf(currentChar);
			 else if(chars2.indexOf(currentChar)!=-1)tapeValues[c]=chars2.indexOf(currentChar);
	  	     else if(nums.indexOf(currentChar)!=-1)tapeValues[c]=nums.indexOf(currentChar);
	  	       else throw(new EdsacException("Undefined character:"+(char)currentChar));
		}
		tapeValues=temp;
	}

	public int nextValue() throws EdsacException
	// returns the next 5 bits
	{
		if(pos>=tapeValues.length)throw(new EdsacException("End of tape"));
		return tapeValues[pos++];
	}
	public void reload()
	{
		pos=0;
	}
}

/*
 * $Log: Tape.java,v $
 * Revision 1.4  1999/03/03 17:39:15  mnw21
 * Fixed log.
 *
 * Revision 1.3  1999/02/05 18:33:02  jm266
 * added a position to this so the editor can jump to errors.
 *
 * Revision 1.2  1999/01/29 19:49:57  jm266
 * filled in the actual code
 *
*/
