package india;

import java.util.*;
import java.awt.*;
import java.io.*;
import java.net.*;

public class RemoteFileMenu
{
	Vector menuItems=null;
	URL baseURL=null;
	Vector names=null;

	public RemoteFileMenu(URL url)
	{
		baseURL=url;
		
		names=new Vector(32);
		menuItems=new Vector(32);

				
	}

	public Menu getMenu() throws IOException
	{
		Vector menuStack=new Vector(4);
		InputStream is=baseURL.openStream();
		byte[] bytes;
		int read=0;
		int length=baseURL.openConnection().getContentLength();
		bytes=new byte[length];
		
		for(int c=0;c<length;)
		{
			read=is.read(bytes,c,bytes.length-c);
			if(read!=-1)c=c+read;
			  else throw (new IOException("URL Length mismatch"));
		}

		Menu topLevel=null;
		Menu current=null;
		String s=new String(bytes);
		for(int c=0;c<s.length();)
		{
			String line;
			int nextPos=c;
			int cr=s.indexOf("\r",c);
			int lf=s.indexOf("\n",c);

			if(cr==-1 &&lf==-1)
			{
				line=s.substring(c).trim();
				nextPos=s.length();
			}
			else if(cr<lf && cr!=-1)
			{
				line=s.substring(c,cr).trim();
				if(lf!=-1)nextPos=lf+1;
				else nextPos=cr+1;
			}
			else if(lf!=-1)
			{
			  	line= s.substring(c,lf).trim();
				if(cr!=-1)nextPos=cr+1;
				else nextPos=lf+1;
			}
			else
			{
				line=s.substring(c,cr).trim();
				nextPos=cr+1;
			}

			if(line.startsWith("!"))
			{
				nextPos=cr+1;
				continue;
			}else
			if(line.startsWith("{"))
			{
				Menu temp=new Menu(line.substring(1).trim());
				if(current!=null)
				{
					current.add(temp);
					menuStack.addElement(current);
				}
				else topLevel=temp;
				current=temp;
			}else
			if(line.startsWith("}"))
			{
				if(menuStack.isEmpty())current=null;
				  else
				  {
  					current=(Menu)menuStack.lastElement();
					menuStack.removeElement(current);
				  }
			}else
			if(line.indexOf("=")!=-1)
			{
				MenuItem temp;
				temp=new MenuItem(line.substring(0,line.indexOf("=")));
				if(line.length()<=line.indexOf("=")+1)break;
				menuItems.addElement(temp);
				names.addElement(line.substring(line.indexOf("=")+1));
				current.add(temp);
			}
			c=nextPos;
		}
		return topLevel;
	}
	
	public String getFile(MenuItem m) throws MalformedURLException, IOException
	{
		int index=menuItems.indexOf(m);
		if(index!=-1)
		{
			String s=new String();
			URL remoteFile=new URL(baseURL,(String)names.elementAt(index));
			InputStream is=remoteFile.openStream();
			byte[] bytes;
			int read=0;
			int length=remoteFile.openConnection().getContentLength();
			bytes=new byte[length];
			for(int c=0;c<length;)
			{
				read=is.read(bytes,c,bytes.length-c);
				if(read!=-1)c=c+read;
				  else throw( new IOException("URL Length mismatch"+remoteFile));
			}
			s=new String(bytes);
			return s;
		}
		else return null;
	}

	public static void main(String []args)
	{
		try
		{
		Frame f=new Frame("Title");
		RemoteFileMenu rtfm=new RemoteFileMenu(new URL("file:///G:/edsac/menu"));
		MenuBar m=new MenuBar();
		System.out.println("here1!");
		m.add(rtfm.getMenu());
		System.out.println("here!");
		f.setMenuBar(m);
		f.pack();
		f.show();
		}catch(Exception e){System.out.println(e); e.printStackTrace();}
	}
}
