package india;

import java.awt.*;

public class NumberFrame extends Frame
{

  String contents;
  TextArea output;
  String fileName;
  MenuBar menuBar;
  static final int TAPE=0;
  static final int MEMORY=1;
  static final int RELATIVE=2;
  int mode=TAPE;

  NumberFrame(String name,String con)
  {
    contents=con;
    fileName=name;

    this.setTitle(fileName+" - Numbered Source");

    output=new TextArea();
    output.setEditable(false);
    this.setLayout(new BorderLayout());
    
    Panel pan=new Panel();
    pan.setLayout(new GridLayout(1,3));
    Button b=new Button("Tape");
    pan.add(b);
    b=new Button("Memory");
    pan.add(b);
    b=new Button("Relative");
    pan.add(b);
    this.add("Center",output);
    this.add("South",pan);
    menuBar=new MenuBar();
    Menu m;
    m=new Menu("File");
    m.add("close");
    menuBar.add(m);

    this.setMenuBar(menuBar);
    this.resize(300,300);
    this.show();
  }

  public boolean handleEvent(Event evt)
  {
    if(evt.id==Event.WINDOW_DESTROY)
      {
	// Put up a box saying "this will lose changes yes/no"
	close();
      }
    return super.handleEvent(evt);
  }
  
  public boolean action(Event evt, Object what)
  {
    if(!(what instanceof String))return false;

    String label=(String)what;
    
    if(label.equals("Tape"))
      {
	if(this.mode==TAPE)return true;
	this.mode=TAPE;

	return true;
      }
    if(label.equals("Memory"))
      {
	if(this.mode==MEMORY)return true;
	this.mode=MEMORY;
	String s="   44:";
	int line=44;
	for(int c=0;c<contents.length;c++)
	  {
	    s=s+contents.charAt(c);
	    if(contents.charAt(c)=='\n')
	      {
		line++;
		String num=""+line+":";
		while(num.length<6)line=" "+line;
		s=s+num;
	      }
	  }
	output.setText(s);
	return true;
      }
    if(label.equals("Relative"))
      {
	if(this.mode==RELATIVE)return true;
	this.mode=RELATIVE;
	return true;
      }
    return false;
  }
}





