package india;

import java.awt.*;

/**
 * A panel with user-definable insets.
 * @author	Colin Watson
 * @version	$Id: InsetPanel.java,v 1.1 1999/02/28 23:41:37 cjw44 Exp $
 * @see		Panel
 * @see		Insets
 */

public class InsetPanel extends Panel
{

	private Insets extraInsets;

	public InsetPanel()
	{
		extraInsets = new Insets(0, 0, 0, 0);
	}

	public InsetPanel(Insets insets)
	{
		extraInsets = insets;
	}

	public InsetPanel(int top, int left, int bottom, int right)
	{
		extraInsets = new Insets(top, left, bottom, right);
	}

	public Insets getExtraInsets()
	{
		return extraInsets;
	}

	public synchronized void setExtraInsets(Insets insets)
	{
		extraInsets = insets;
	}

	public synchronized void setExtraInsets(
		int top, int left, int bottom, int right)
	{
		extraInsets = new Insets(top, left, bottom, right);
	}

	public Insets insets()
	{
		Insets defaultInsets = super.insets();
		synchronized(this)
		{
			return new Insets(
				defaultInsets.top + extraInsets.top,
				defaultInsets.left + extraInsets.left,
				defaultInsets.bottom + extraInsets.bottom,
				defaultInsets.right + extraInsets.right);
		}
	}

}

/*
 * $Log: InsetPanel.java,v $
 * Revision 1.1  1999/02/28 23:41:37  cjw44
 * Initial revision
 *
 */
