package india;

import java.awt.*;

/**
 * A dialog box reporting an error.
 * @author	Joseph Marshall
 * @version	$Id: ErrorDlg.java,v 1.2 1999/02/11 02:09:10 cjw44 Exp $
 */

public class ErrorDlg extends Dialog
{
    public ErrorDlg(Frame parent,String body,String title)
    {
	super(parent,title,true);
	Point p=parent.location();
        Rectangle r=parent.bounds();
	this.reshape(r.x+(r.width/2)-100,r.y+(r.height/2)-50,200,100);
	this.setLayout(new BorderLayout());

	Label t=new Label(body);

	this.add("Center",t);
	Panel panel=new Panel();
	panel.add(new Button("OK"));
	this.add("South",panel);
	this.pack();
    }
    
    public boolean handleEvent(Event evt)
    {
	if(evt.id==Event.WINDOW_DESTROY)
	    {
		close();
	    }
	return super.handleEvent(evt);
    }

    
    public boolean action(Event evt, Object what)
    {
	if(!(what instanceof String))return false;
	
	String label=(String)what;
	if(label.equals("OK"))
	    {
		close();
		return super.action(evt,what);
	    }

	return super.action(evt,what);
    }
    

    public void close()
    {
	this.hide();
    }

}

/*
 * $Log: ErrorDlg.java,v $
 * Revision 1.2  1999/02/11 02:09:10  cjw44
 * Made constructor call pack() to make sure the dialog box is laid out
 * correctly.
 * Changed layout slightly by adding a Panel around the OK button, so that it
 * doesn't get stretched to fill the available width.
 *
 */
