/*
 * Decompiled with CFR 0.152.
 */
package edsac.kernel;

import edsac.datatypes.Address;
import edsac.datatypes.Character;
import edsac.datatypes.LongWord;
import edsac.datatypes.ShortWord;
import edsac.kernel.Accumulator;
import edsac.kernel.Memory;
import edsac.kernel.StoppedException;
import edsac.kernel.TapeReader;
import edsac.kernel.Teletype;

class Processor {
    Memory mem;
    TapeReader in;
    Teletype out;
    Accumulator acc;
    Address scr;
    Address oldscr;
    ShortWord orderCode;
    LongWord multiplier;
    LongWord multiplicand;
    private boolean islong;
    private Address addr;
    private int opcode;
    private Character lastOutput;
    int instructionSet;

    public Processor(Memory memory, TapeReader tapeReader, Teletype teletype) {
        this.mem = memory;
        this.in = tapeReader;
        this.out = teletype;
        this.acc = new Accumulator();
        this.scr = new Address(0);
        this.oldscr = new Address(0);
        this.orderCode = new ShortWord(0L);
        this.multiplier = new LongWord(0L);
        this.multiplicand = new LongWord(0L);
        this.lastOutput = new Character();
        this.instructionSet = 51;
    }

    public Processor(Memory memory, TapeReader tapeReader, Teletype teletype, int n) {
        this(memory, tapeReader, teletype);
        this.instructionSet = n;
    }

    public Address execute(ShortWord shortWord) throws StoppedException {
        this.orderCode = shortWord;
        this.islong = shortWord.isLongOperation();
        this.addr = shortWord.getAddress();
        this.opcode = shortWord.getOpcode().byteValue();
        this.oldscr = this.scr;
        switch (this.opcode) {
            case 3: {
                if (!this.acc.isPositive()) break;
                this.scr = new Address(this.addr.intValue() - 1);
                break;
            }
            case 4: {
                if (this.islong) {
                    this.acc.shiftRight(new Address(0), true);
                    break;
                }
                if (this.addr.intValue() == 0) {
                    this.acc.shiftRight(new Address(256), false);
                    this.acc.shiftRight(new Address(8), false);
                    break;
                }
                this.acc.shiftRight(this.addr, this.islong);
                break;
            }
            case 5: {
                if (this.islong) {
                    this.mem.setLong(this.addr, this.acc.longValue());
                } else {
                    this.mem.setShort(this.addr, this.acc.shortValue());
                }
                this.acc.clear();
                break;
            }
            case 6: {
                if (this.instructionSet == 49) {
                    this.acc.round();
                    break;
                }
                this.acc.round();
                break;
            }
            case 7: {
                if (this.islong) {
                    this.mem.setLong(this.addr, this.acc.longValue());
                    break;
                }
                this.mem.setShort(this.addr, this.acc.shortValue());
                break;
            }
            case 8: {
                if (this.islong) {
                    this.mem.setLong(this.addr, new LongWord(new ShortWord(this.in.getNext())));
                    break;
                }
                this.mem.setShort(this.addr, new ShortWord(this.in.getNext()));
                break;
            }
            case 9: {
                this.lastOutput = new Character(this.mem.shortValue(this.addr));
                try {
                    this.out.putChar(this.lastOutput);
                    break;
                }
                catch (InterruptedException interruptedException) {
                    this.scr = this.scr.increment();
                    throw new StoppedException("Stop button pressed.");
                }
            }
            case 12: {
                if (this.islong) {
                    this.acc.subLong(this.mem.longValue(this.addr));
                    break;
                }
                this.acc.subShort(this.mem.shortValue(this.addr));
                break;
            }
            case 13: {
                this.scr = this.scr.increment();
                throw new StoppedException("Halt instruction at address " + this.oldscr.intValue());
            }
            case 17: {
                this.mem.setShort(this.addr, new ShortWord(this.lastOutput, true));
                break;
            }
            case 21: {
                if (this.islong) {
                    this.multiplier = this.mem.longValue(this.addr);
                    break;
                }
                this.multiplier = new LongWord(this.mem.shortValue(this.addr));
                break;
            }
            case 22: {
                this.multiplicand = this.islong ? this.mem.longValue(this.addr) : new LongWord(this.mem.shortValue(this.addr));
                this.acc.multSub(this.multiplicand, this.multiplier);
                break;
            }
            case 25: {
                if (this.islong) {
                    this.acc.shiftLeft(new Address(0), true);
                    break;
                }
                if (this.addr.intValue() == 0) {
                    this.acc.shiftLeft(new Address(32), false);
                    this.acc.shiftLeft(new Address(16), false);
                    break;
                }
                this.acc.shiftLeft(this.addr, this.islong);
                break;
            }
            case 27: {
                if (!this.acc.isNegative()) break;
                this.scr = new Address(this.addr.intValue() - 1);
                break;
            }
            case 28: {
                if (this.islong) {
                    this.acc.addLong(this.mem.longValue(this.addr));
                    break;
                }
                this.acc.addShort(this.mem.shortValue(this.addr));
                break;
            }
            case 30: {
                if (this.islong) {
                    this.acc.longCollate(this.mem.longValue(this.addr), this.multiplier);
                    break;
                }
                this.acc.shortCollate(this.mem.shortValue(this.addr), this.multiplier);
                break;
            }
            case 31: {
                this.multiplicand = this.islong ? this.mem.longValue(this.addr) : new LongWord(this.mem.shortValue(this.addr));
                this.acc.multAdd(this.multiplicand, this.multiplier);
                break;
            }
            default: {
                this.scr = this.scr.increment();
                throw new StoppedException("Unknown Instruction at address " + this.oldscr.intValue());
            }
            case 26: 
        }
        this.scr = this.scr.increment();
        return this.scr;
    }
}

