/*
 * Decompiled with CFR 0.152.
 */
package edsac.kernel;

import edsac.datatypes.Address;
import edsac.datatypes.LongWord;
import edsac.datatypes.ShortWord;

class Memory {
    int[] mem = new int[1024];

    Memory() {
        int n = 0;
        while (n < 1024) {
            this.mem[n] = 0;
            ++n;
        }
    }

    ShortWord shortValue(Address address) {
        return new ShortWord(this.mem[address.intValue() & 0x3FF]);
    }

    LongWord longValue(Address address) {
        int n = address.intValue();
        n &= 0xFFFFFFFE;
        return new LongWord((long)this.mem[n &= 0x3FF] | (long)this.mem[n + 1] << 18);
    }

    void setShort(Address address, ShortWord shortWord) {
        this.mem[address.intValue() & 0x3FF] = shortWord.intValue();
    }

    void setLong(Address address, LongWord longWord) {
        int n = address.intValue();
        n &= 0xFFFFFFFE;
        long l = longWord.longValue();
        this.mem[n &= 0x3FF] = (int)(l & 0x3FFFFL);
        this.mem[n + 1] = (int)(l >> 18);
    }

    public String toString() {
        String string = "Short values:\n";
        int n = 0;
        while (n < 1024) {
            string = String.valueOf(string) + n + ": " + this.shortValue(new Address(n)) + "\n";
            ++n;
        }
        string = String.valueOf(string) + "Long values:\n";
        int n2 = 0;
        while (n2 < 1024) {
            string = String.valueOf(string) + n2 + ": " + this.longValue(new Address(n2)) + "\n";
            n2 += 2;
        }
        return string;
    }
}

