/*
 * Decompiled with CFR 0.152.
 */
package edsac.kernel;

import edsac.datatypes.Address;
import edsac.datatypes.ShortWord;
import edsac.gui.MessageBox;
import edsac.gui.TeleQueue;
import edsac.kernel.Memory;
import edsac.kernel.Processor;
import edsac.kernel.StoppedException;
import edsac.kernel.TapeReader;
import edsac.kernel.Teletype;

public class Kernel
implements Runnable {
    Processor p;
    Memory m;
    TapeReader in = new TapeReader("");
    Teletype out;
    Address loc;
    boolean running;
    Thread t;
    public int cycles;
    public int delay;
    public String whyStopped;

    public Kernel(TeleQueue teleQueue) {
        this.out = new Teletype(teleQueue);
        this.m = new Memory();
        this.p = new Processor(this.m, this.in, this.out);
        this.loc = new Address();
        this.running = false;
    }

    void readInitialOrders(int n) {
        String string = n == 1 ? "TF H2F TF E6F P1F P5F TF IF AF R16F TD I2F A2F S5F E21FT3F V1F L8F A2F T1F E11F R4F A1F LD AF T31F A25F A4F U25FS31F G6F" : "TF E20F P1F U2F A39F R4F VF L8F TF I1F A1F S39F G4F LDS39F E17F S7F A35F T20F AF H8F A40F T43F A22F A2F T22FE34F A43F E8F A42F A40F E25F A22F T42F I40D A40D R16FT40D E8F P5D PD";
        TapeReader tapeReader = new TapeReader(string);
        int n2 = 0;
        try {
            while (true) {
                byte by = tapeReader.getNext().byteValue();
                int n3 = by << 12;
                int n4 = 0;
                while ((by = tapeReader.getNext().byteValue()) < 10) {
                    n4 *= 10;
                    n4 += by;
                }
                n3 |= n4 << 1;
                if (by == 19) {
                    n3 |= 1;
                }
                this.m.setShort(new Address(n2), new ShortWord(n3));
                ++n2;
            }
        }
        catch (StoppedException stoppedException) {
            this.whyStopped = stoppedException.toString();
            return;
        }
    }

    public void singleStep() {
        try {
            this.loc = this.p.execute(this.m.shortValue(this.loc));
            return;
        }
        catch (StoppedException stoppedException) {
            this.whyStopped = stoppedException.toString();
            return;
        }
    }

    public void startFreeRun() {
        this.t = new Thread(this);
        this.t.start();
    }

    public void stopFreeRun() {
        this.t.interrupt();
    }

    public void run() {
        block5: {
            this.running = true;
            try {
                try {
                    while (!this.t.isInterrupted()) {
                        this.loc = this.p.execute(this.m.shortValue(this.loc));
                        ++this.cycles;
                        Thread.sleep(this.delay);
                    }
                }
                catch (InterruptedException interruptedException) {
                    throw new StoppedException("Stop button pressed.");
                }
            }
            catch (StoppedException stoppedException) {
                this.loc = this.p.scr;
                if (stoppedException.toString().startsWith("Stop button") || stoppedException.toString().startsWith("Halt instruction")) break block5;
                new MessageBox("Stopped: " + stoppedException);
            }
        }
        this.running = false;
    }

    public void restart(int n) {
        this.p = new Processor(this.m, this.in, this.out, n == 1 ? 49 : 51);
        this.loc = new Address();
        this.running = false;
        this.readInitialOrders(n);
    }

    public boolean isRunning() {
        return this.running;
    }

    public long[] getTank(int n) {
        int n2 = n * 32;
        long[] lArray = new long[16];
        int n3 = 0;
        while (n3 < 16) {
            lArray[n3] = this.m.longValue(new Address(n2 + n3 * 2)).longValue();
            ++n3;
        }
        return lArray;
    }

    public long[] getAccumulator() {
        long[] lArray = new long[]{this.p.acc.low, this.p.acc.high};
        return lArray;
    }

    public long getMultiplier() {
        return this.p.multiplier.longValue();
    }

    public long getMultiplicand() {
        return this.p.multiplicand.longValue();
    }

    public int getSCR() {
        return this.p.oldscr.intValue();
    }

    public int getOrderCode() {
        return this.p.orderCode.intValue();
    }

    public void setInputTape(String string) {
        this.in.setTape(string);
    }

    public void updateDialAcc(int n) {
        this.p.acc.addShort(new ShortWord(n * 2));
    }

    public void memoryClear(int n) {
        this.m = new Memory();
        this.p = new Processor(this.m, this.in, this.out, n == 1 ? 49 : 51);
        this.loc = new Address();
        this.running = false;
    }
}

