/*
 * Decompiled with CFR 0.152.
 */
package edsac.gui;

import edsac.datatypes.Tapes;
import edsac.gui.CloseableFrame;
import edsac.gui.ColouredLabel;
import edsac.gui.ConfigGui;
import edsac.gui.Crt;
import edsac.gui.Dial;
import edsac.gui.DisplayUpdater;
import edsac.gui.DownSection;
import edsac.gui.InputGui;
import edsac.gui.MainMemoryTube;
import edsac.gui.OutputGui;
import edsac.gui.ResetSection;
import edsac.gui.SingleEpSection;
import edsac.gui.StartSection;
import edsac.gui.StopSection;
import edsac.gui.TeleQueue;
import edsac.gui.UpSection;
import edsac.kernel.Kernel;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class Gui
extends Container {
    Image configImage;
    Button start;
    Button stop;
    Button config;
    Button reset;
    Button singleEp;
    Button input;
    Button output;
    Button help;
    Button up;
    Button down;
    Button clear;
    Image backdrop;
    ColouredLabel tankLabel;
    ColouredLabel timeLabel;
    MainMemoryTube mainMemoryTube;
    Crt scr;
    Crt orderTank;
    Crt multiplier;
    Crt multiplicand;
    Crt accumulator;
    int buttonWidth = 60;
    int buttonHeight = 15;
    Font guiFont;
    Dial dial;
    InputGui inputGui;
    OutputGui outputGui;
    ConfigGui configGui;
    DisplayUpdater displayUpdater;
    int tankNumber;
    Kernel kernel;
    private boolean[] multiplierBits = new boolean[35];
    private boolean[] scrBits = new boolean[10];
    private boolean[] accBits = new boolean[71];
    private boolean[] multiplicandBits = new boolean[35];
    private boolean[] orderBits = new boolean[17];
    private boolean[][] memTankBits = new boolean[16][35];
    public CloseableFrame inputFrame;
    public CloseableFrame outputFrame;
    public CloseableFrame configFrame;
    long elapsed;
    int delay = 10;

    public Gui(Kernel kernel, TeleQueue teleQueue, Image image) {
        this.configImage = image;
        this.kernel = kernel;
        this.setTankNumber(0);
        this.setLayout(null);
        this.guiFont = new Font("SansSerif", 0, 10);
        this.tankLabel = new ColouredLabel(Color.white, Color.black, "0");
        this.tankLabel.setSize(15, 20);
        this.tankLabel.setLocation(285, 25);
        this.tankLabel.setFont(this.guiFont);
        this.add(this.tankLabel);
        this.up = new Button("up");
        this.up.setSize(20, this.buttonHeight);
        this.up.setLocation(115, 140);
        this.up.setFont(this.guiFont);
        UpSection upSection = new UpSection(this);
        this.up.addActionListener(upSection);
        this.add(this.up);
        this.down = new Button("down");
        this.down.setSize(30, this.buttonHeight);
        this.down.setLocation(365, 140);
        this.down.setFont(this.guiFont);
        DownSection downSection = new DownSection(this);
        this.down.addActionListener(downSection);
        this.add(this.down);
        this.start = new Button("Start");
        this.start.setSize(this.buttonWidth, this.buttonHeight);
        this.start.setLocation(10, 20);
        this.start.setFont(this.guiFont);
        StartSection startSection = new StartSection(this);
        this.start.addActionListener(startSection);
        this.add(this.start);
        this.stop = new Button("Stop");
        this.stop.setSize(this.buttonWidth, this.buttonHeight);
        this.stop.setLocation(10, 20 + (this.buttonHeight + 5));
        this.stop.setFont(this.guiFont);
        StopSection stopSection = new StopSection(this);
        this.stop.addActionListener(stopSection);
        this.stop.setEnabled(false);
        this.add(this.stop);
        this.config = new Button("Config");
        this.config.setSize(this.buttonWidth, this.buttonHeight);
        this.config.setLocation(10, 20 + 4 * (this.buttonHeight + 5) + 30);
        this.config.setFont(this.guiFont);
        this.configFrame = new CloseableFrame("EDSAC Configuration", this.config);
        ((Component)this.configFrame).setSize(200, 200);
        this.configGui = new ConfigGui(image);
        this.configGui.setSize(192, 171);
        this.configGui.setLocation(4, 23);
        this.configFrame.add(this.configGui);
        this.config.addActionListener(this.configFrame);
        this.add(this.config);
        this.reset = new Button("Reset");
        this.reset.setSize(this.buttonWidth, this.buttonHeight);
        this.reset.setLocation(10, 20 + 2 * (this.buttonHeight + 5));
        this.reset.setFont(this.guiFont);
        ResetSection resetSection = new ResetSection(this);
        this.reset.addActionListener(resetSection);
        this.add(this.reset);
        this.singleEp = new Button("Single E.P.");
        this.singleEp.setSize(this.buttonWidth, this.buttonHeight);
        this.singleEp.setLocation(10, 20 + 3 * (this.buttonHeight + 5));
        this.singleEp.setFont(this.guiFont);
        SingleEpSection singleEpSection = new SingleEpSection(this);
        this.singleEp.addActionListener(singleEpSection);
        this.add(this.singleEp);
        this.clear = new Button("Clear");
        this.clear.setSize(this.buttonWidth, this.buttonHeight);
        this.clear.setLocation(10, 20 + 4 * (this.buttonHeight + 5));
        this.clear.setFont(this.guiFont);
        this.clear.addActionListener(new 1());
        this.add(this.clear);
        this.help = new Button("Help");
        this.help.setSize(this.buttonWidth, this.buttonHeight);
        this.help.setLocation(10, 20 + 5 * (this.buttonHeight + 5) + 30);
        this.help.setFont(this.guiFont);
        this.add(this.help);
        this.input = new Button("Input");
        this.input.setSize(this.buttonWidth, this.buttonHeight);
        this.input.setLocation(10, 20 + 6 * (this.buttonHeight + 5) + 30);
        this.input.setFont(this.guiFont);
        this.inputFrame = new CloseableFrame("Input Section", this.input);
        ((Component)this.inputFrame).setSize(220, 365);
        ((Component)this.inputFrame).setLocation(200, 50);
        this.inputGui = new InputGui();
        this.inputGui.setSize(211, 295);
        this.inputGui.setLocation(2, 23);
        this.inputFrame.add(this.inputGui);
        this.input.addActionListener(this.inputFrame);
        this.add(this.input);
        MenuBar menuBar = new MenuBar();
        Menu menu = new Menu("Tapes");
        menuBar.add(menu);
        MenuItem menuItem = new MenuItem("Happy 50th");
        menu.add(menuItem);
        menuItem.addActionListener(new 2());
        MenuItem menuItem2 = new MenuItem("Squares");
        menu.add(menuItem2);
        menuItem2.addActionListener(new 3());
        MenuItem menuItem3 = new MenuItem("Primes");
        menu.add(menuItem3);
        menuItem3.addActionListener(new 4());
        this.inputFrame.setMenuBar(menuBar);
        MenuItem menuItem4 = new MenuItem("OXO");
        menu.add(menuItem4);
        menuItem4.addActionListener(new 5());
        MenuItem menuItem5 = new MenuItem("Conway");
        menu.add(menuItem5);
        menuItem5.addActionListener(new 6());
        MenuItem menuItem6 = new MenuItem("Cubes");
        menu.add(menuItem6);
        menuItem6.addActionListener(new 7());
        MenuItem menuItem7 = new MenuItem("MandelBrot");
        menu.add(menuItem7);
        menuItem7.addActionListener(new 8());
        MenuItem menuItem8 = new MenuItem("Hello World");
        menu.add(menuItem8);
        menuItem8.addActionListener(new 9());
        this.output = new Button("Output");
        this.output.setSize(this.buttonWidth, this.buttonHeight);
        this.output.setLocation(10, 20 + 7 * (this.buttonHeight + 5) + 30);
        this.output.setFont(this.guiFont);
        this.outputFrame = new CloseableFrame("Output Section", this.output);
        ((Component)this.outputFrame).setSize(350, 350);
        ((Component)this.outputFrame).setLocation(400, 50);
        this.outputGui = new OutputGui(teleQueue);
        this.outputGui.setSize(341, 300);
        this.outputGui.setLocation(2, 11);
        this.outputFrame.add(this.outputGui);
        this.output.addActionListener(this.outputFrame);
        this.add(this.output);
        this.timeLabel = new ColouredLabel(Color.white, Color.black, "   " + this.elapsed + " secs");
        this.timeLabel.setSize(this.buttonWidth + 9, 18);
        this.timeLabel.setLocation(6, 210);
        this.timeLabel.setFont(this.guiFont);
        this.mainMemoryTube = new MainMemoryTube();
        this.mainMemoryTube.setLocation(150, 45);
        this.add(this.mainMemoryTube);
        this.mainMemoryTube.setSize(210, 192);
        this.scr = new Crt(60, 10, 10);
        this.scr.setLocation(430, 30);
        this.add(this.scr);
        this.orderTank = new Crt(102, 17, 17);
        this.orderTank.setLocation(410, 57);
        this.add(this.orderTank);
        this.multiplier = new Crt(108, 35, 18);
        this.multiplier.setLocation(467, 105);
        this.add(this.multiplier);
        this.multiplicand = new Crt(108, 35, 18);
        this.multiplicand.setLocation(467, 144);
        this.add(this.multiplicand);
        this.accumulator = new Crt(108, 71, 18);
        this.accumulator.setLocation(412, 210);
        this.add(this.accumulator);
        this.dial = new Dial(this);
        this.dial.setSize(48, 64);
        this.dial.setLocation(16, 220);
        this.add(this.dial);
    }

    void dispUpdate() {
        this.displayUpdater = new DisplayUpdater(this);
        this.displayUpdater.start();
    }

    void execute() {
        this.kernel.startFreeRun();
    }

    public void paint(Graphics graphics) {
        graphics.setColor(Color.lightGray);
        graphics.draw3DRect(5, 15, this.buttonWidth + 10, 5 * (this.buttonHeight + 5) + 5, true);
        graphics.draw3DRect(6, 16, this.buttonWidth + 8, 5 * (this.buttonHeight + 5) + 3, true);
        graphics.draw3DRect(5, 125, this.buttonWidth + 10, 4 * (this.buttonHeight + 5) + 5, true);
        graphics.draw3DRect(6, 126, this.buttonWidth + 8, 4 * (this.buttonHeight + 5) + 3, true);
        graphics.setColor(Color.black);
    }

    public void setTankNumber(int n) {
        this.tankNumber = n;
    }

    public void drawAllDisplays() {
        this.drawScr();
        this.drawOrderTank();
        this.drawMultiplier();
        this.drawMultiplicand();
        this.drawAccumulator();
        this.drawMemoryTank();
        this.elapsed = this.kernel.cycles / 600;
        this.timeLabel.setText("   " + this.elapsed + " secs");
    }

    private void drawScr() {
        if (this.scr != null && this.configGui.shortTankSelector.getState()) {
            int n = this.kernel.getSCR();
            int n2 = 0;
            while (n2 < 10) {
                this.scrBits[n2] = (n & 1) != 0;
                n >>= 1;
                ++n2;
            }
            this.scr.setNumber(this.scrBits);
        }
    }

    private void drawOrderTank() {
        if (this.orderTank != null && this.configGui.shortTankSelector.getState()) {
            int n = this.kernel.getOrderCode();
            int n2 = 0;
            while (n2 < 17) {
                this.orderBits[n2] = (n & 1) != 0;
                n >>= 1;
                ++n2;
            }
            this.orderTank.setNumber(this.orderBits);
        }
    }

    private void drawMultiplier() {
        if (this.multiplier != null && this.configGui.shortTankSelector.getState()) {
            long l = this.kernel.getMultiplier();
            int n = 0;
            while (n < 35) {
                this.multiplierBits[n] = (l & 1L) != 0L;
                l >>= 1;
                ++n;
            }
            this.multiplier.setNumber(this.multiplierBits);
        }
    }

    private void drawMultiplicand() {
        if (this.multiplicand != null && this.configGui.shortTankSelector.getState()) {
            long l = this.kernel.getMultiplicand();
            int n = 0;
            while (n < 35) {
                this.multiplicandBits[n] = (l & 1L) != 0L;
                l >>= 1;
                ++n;
            }
            this.multiplicand.setNumber(this.multiplicandBits);
        }
    }

    private void drawAccumulator() {
        if (this.accumulator != null && this.configGui.shortTankSelector.getState()) {
            long[] lArray = this.kernel.getAccumulator();
            int n = 0;
            while (n < 36) {
                this.accBits[n] = (lArray[0] & 1L) != 0L;
                lArray[0] = lArray[0] >> 1;
                ++n;
            }
            n = 36;
            while (n < 71) {
                this.accBits[n] = (lArray[1] & 1L) != 0L;
                lArray[1] = lArray[1] >> 1;
                ++n;
            }
            this.accumulator.setNumber(this.accBits);
        }
    }

    void drawMemoryTank() {
        if (this.mainMemoryTube != null) {
            long[] lArray = this.kernel.getTank(this.tankNumber);
            int n = 0;
            while (n < 16) {
                long l = lArray[n];
                boolean[] blArray = this.memTankBits[n];
                int n2 = 0;
                while (n2 < 35) {
                    blArray[n2] = (l & 1L) != 0L;
                    l >>= 1;
                    ++n2;
                }
                ++n;
            }
            this.mainMemoryTube.setMemory(this.memTankBits);
        }
    }

    private final class 1
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            Gui.this.kernel.memoryClear(Gui.this.configGui.initialOrdersVersion);
            Gui.this.drawAllDisplays();
        }

        /* synthetic */ 1() {
        }
    }

    private final class 2
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            new Tapes();
            Gui.this.inputGui.inputArea.setText("T97F \nGF \nA64D \nG47F \nLD T64D \nA33F A60F \nS59F E51F \nA59F \nT33F \nA36F A60F T36F \nE33F \nLD A62D E36F G36F \nA61F U33F S96F T36F E33F \nPF PF PF \nA96D P2F A64D PD \nPF \nP12S \nP0S \nP12S \nP391S \nP0S \nP584L \nW652S \nP72L \nW652S \nP72L \nW908S \nP904L \nW652S \nP520L \nU652S \nP967S \nP0S \nP0S \n.128S \nF552S \n.128S \nF552S \n.128S \nF1000S \nA128S \nV558S \n@320S \nF553S \n@320S \nF329S \nA544S \nF142S \nMF");
        }

        /* synthetic */ 2() {
        }
    }

    private final class 3
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            new Tapes();
            Gui.this.inputGui.inputArea.setText("[Squares]\nT123SE84SPSPSP10000SP1000SP100SP10SP1S\nQS#SA40S!S&S@SO43SO33SPSA46S\nT65ST129SA35ST34SE61ST48SA47ST65SA33SA40S\nT33SA48SS34SE55SA34SPST48ST33SA52SA4S\nU52SS42SG51SA117ST52SPSPSPSPSPS\nE110SE118SP100SE95SO41ST129SO44SO45SA76SA4S\nU76ST48SA83ST75SE49SO43SO43SH76SV76SL64S\nL32SU77SS78ST79SA77SU78ST48SA80ST75SE49S\nO43SO43SA79ST48SA81ST75SE49SA35SA76SS82S\nG85SO41SZS");
        }

        /* synthetic */ 3() {
        }
    }

    private final class 4
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            new Tapes();
            Gui.this.inputGui.inputArea.setText("[Primes]\nT107SO92SO93SO94SS5ST6SO95SO95ST7S\nA96SR4SS97SE42SL4SA97SG45SS98SG100ST7S\nA97SA4ST97SH97SN97SL64SL64SA96SE39ST7S\nA96SU1SA4ST96SA99ST97SS88ST7SH91SA1S\nE72SV91SS89SE71SA89STLOSH90SV1SL4S\nTLA7SA98SG67SA6SA4SG36SE33SP2SP500S\nJSP16S#S@S&S!SP2LP1LPLP1L\nT7SA99ST97SA4SA96ST96SE39S");
        }

        /* synthetic */ 4() {
        }
    }

    private final class 5
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            new Tapes();
            Gui.this.inputGui.inputArea.setText("[OXO]\nT56K\n[M3]\nPFGKIFAFRDLFUFOFE@A6FG@E8FEZPF\n@&#9!8!7!!!!!!!*NOUGHTS!AND!CROSSES\n@&#6!5!4!!!!!!!*!!!!!!!!BY\n@&#3!2!1!!!!!!!*A!S!DOUGLAS#N!*C#M1952\n@&@&*LOADING!PLEASE!WAIT#MMM\n..PK\nT45KP192F  [H-parm]\nT50KP512F  [X-parm]\nT46KP352F  [N-parm]\n\nT64K\nGKT48KP@TZ\n[&-sequence]\nP4FPFP1FP2FP3FP4FP8FP10FP12FP16F\nP300FP32FAHOFU1FU2FK4098FM1FA2DPF\n\nT96K\n[C-sequence]\nGKT54KP@TZ\n\nP3072FP24FP2F&FPFPFPFPFIFP1F\n\n.FPD.FV2047F&FP1DPFPFPFPFQ1024F\n\nT128K\n[Special Sequence]\nGKT53KP@TZ\nZFS2&S2&S2&S2&S2&S2&S2&S2&S2&\nA7&T14BA12BGHZFA15BGNA17BGXPFZF\n\nT160K\n[Draw Grid]\nGKT44KP@TZ\nA15&T20@A#CUDU2DU4DU6DU8DU12DU14D\nU16DU18DU22DU24DU26DU28DT30DS2#CU10DT20DZFPF\n\nT192K\n[Plant Routine]\nGKT45KP@TZ\nT55KP108@TZA3&U4@A14&T106@ZFTVXFXFXFXFXFXF\nA8#CT4#CA10#CT6#CA&L1024FE24@T32FS12#CT4#CA14#CT6#CT32FAVA3V\nT29@XFZFE47@E56@E38@E47@E56@E38@E47@E56@\nA4#CL512FT4#CA6#CL512FT6#CE56@XFXF\nA4#CR512FT4#CA6#CR512FT6#CXFXFXF\nSVXFA4&E85@XFA4&E74@T32FXF\nA24DA4#CU24DT26DA22DA6#CU22DT28DE96@T32F\nA14DA4#CU14DT16DA12DA6#CU12DT18DE96@XFT32F\n A4DA4#C U4D T6D A2DA6#C U2D T8DXFXF\nA&L1024FG103@T&A8&T&E106@T&A5&T&\nZFPF\nPF.F.FE29@\n\nT320K\n[Search routine]\nGKT47KP@TZ\nGKA3&U8@A15&U20@S2&T22@A18&T13@AFS5&\nE24@A23@T14@A2DZFL512FL512FL8FG21@T32F\nZFT32FZFE18@S4&T34FA13@A7&T13@A34FG11@E24@\n\nT352K\n[Opponent's Routine]\nGKT46KP@TZ\nGKT55KP45@TZ\nA15&T44@O1VO2VO3VO6VO7VO@O12VO5V\nO8VO11@O9VO16@O4VO10VE20@T32FO11VXF\nT32FZFXFUVU35@T43@SVE17@T32FAV\nS7&E17@T32FA33@GMPFE17@\nAVL512FTVOV\nA41@\nGHPFZF\nPF@F&F*F#F!FDFIFMFVFCFBFLF\n\nT416K\nGKT49KP@TZ\n[Winning Print Routine]\nGKT55KP11@TZ\nA15&T14@A2@G832F@24F*3FD12FA30F!2FO22F#23FM23F.FT13&ZF\n\nGKT55KP11@TZ\nA15&T10@XFOVO1VO2VO3VO3VO3VXFZF\n@F&F*FXF\n\nT448K\n[Auxiliary to end-game routine]\nGKT51KP@TZ\nH20CA3&U9@A2&U46@A14&T43@T34FT36DAF\nU33FS5&G48@S4&G50@S4&T32FA7&A7&A18&\nT24@A32FA52@T25@A2DZFL512FL512FU35FL8F\nG34@T32FA33FT36FT32FC35FR256FA34FT34FA37F\nA2&U37FS4&ZFT32FA33FAFE10@T32FE19@\nT32FE18@E29@\n\nT512K\n[End-game routine]\nGKT50KP@TZ\nA3&U49@U68@A14&U67@T88@T92@A4&T1&A18@\nT21@T59@A2&U37@U36@A25@T17@ZFE34@E34@\nE34@ZFE81@E87@E34@E17@E75@A2&U36@T1&\nA4&T37@A26@T21@A34@GGP1FP1FA34FA58@\nT41@ZFE55@E55@E60@E55@E68@E52@E72@AF\nA88@T88@A2&A59@T59@A36@A1&E14@E42@PF\nA36FT64@A62@GHPFA65@GLZFAFA88@\nT88@E55@A36FT92@E55@A5&U37@T1&A2&T36@\nE34@A3&T37@A4&U36@T1&E34@S92@ZFT32F\nA90@GHPFA59@S5&E67@T32FA97@GNA67@E5@\n\nT640K\n[Master Routine 1]\nGKA15&T20BA5&T&A4@GHP9FA7@GNA9@\nGMP7FE37@A13@GMP8FE37@A17@GHP7F\nA20@GNA22@GXP1FE20BE5BE32@ZFZF\nE4BE20BA32@GMP1FE3BE1BA37@GHP3F\nA40@GNA42@GMP6FE1BE17B\n\nT704K\n[Master Routine 2]\nGKA15&T20BA8&T&A4@GNA6@GMP5FE25@\nA10@GHP5FA13@GNA15@GXP1FE20BE40@\nE49@E95@ZFE20BZFA25@GHP9FA28@GN\nA30@GXP1FE20BE7BEFZFE3BZFE20B\nA40@GMP8FE9BA44@GMP6FE9BE8BA49@\nGMP9FE75@A53@GMP7FE80@A57@GMP3F\nE85@A61@GMP8FE90@A65@GMP6FE70@E3B\nA70@GMP1FE8BE1BA75@GMP4FE2BE4B\nA79@GMP6FE2BE6BA85@GMP8FE4BE8B\nA90@GMP4FE9BE7BA95@GMP2FE6BE2B\n\nT832K\n[Print caption]\nGKA3&U4@A14&T10@ZFU33FE12@A11@G12@T32F\nZFVFT32FO33FA33FL512FT33FO33FA4@A2&\nT4@A10@A2&T10@E4@\n\nT864K\n[My Master]\nGKS13&E15@T32FA3@G832F@24F*19FR28FW22F!27F\nA23FE11FM23FM16F.FT32FA2&T13&A18@G832F\n@24F@24F*3FD12FA30F#26F*16FU12FE4F!17FI4F\nS5F!11FK15FD8FA25F!11FP26FQ25FC16F\n.FZFXFS2&G55@S2&G58@S6&G55@O37@\nA50@G!A52@G640FE@O64@T32FE41@O38@A59@\nG!A61@G704FE@BF\nE15ZPF");
        }

        /* synthetic */ 5() {
        }
    }

    private final class 6
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            new Tapes();
            Gui.this.inputGui.inputArea.setText("[Conways Life]\n[Ian Gillman 1998]\n\n[Pattern]\nT96K\nF  555 D\nQ  520 D\nP 1105 F\nW   80 F\nQ  130 D\nT  128 D\nP   69 F\nJ   68 F\nX  640 F\nR  136 F\nI   20 F\nP   20 F\nF      D\nQ  520 D\nP 1040 F\nW   80 F\nQ    2 D\nT  128 F\nI    1 F\nJ    4 F\nX  130 F\nR  520 F\nI 1028 F\nI   16 F\nQ  512 D\nP  520 D\nP 1105 F\nW   16 F\nQ  128 D\nT      D\nI      F\nW    4 F\nX      F\nT      F\n\n\n[Copy Screen]\nT45K  [H Parameter]\nP153F\n\nT128K\nGK\nA57F  [Form return address]\nT24@  [Plant Link]\nA3H   [Reset counter]\nTH    [             ]\nA1H   [Get FROM offset]\nA4H   [Add instruction blank]\nT11@  [Write instruction]\nA2H   [Get TO offset]\nA5H   [Add instruction blank]\nT12@  [Write instruction]\n\nT58F  [Clear acc]\nAF    [Target instruction]\nTF    [Target instruction]\nA11@  [Get instruction]\nS6H   [Decrement by 4]\nT11@  [Store instruction]\nA12@  [Get instruction]\nS6H   [Decrement by 4]\nT12@  [Store instruction]\nAH    [Get counter]\nS43F  [Decrement counter]\nUH    [Store counter]\nE10@  [Loop back]\n\nT58F  [Clear acc]\nEF    [Space for link]\n\n[Variables]\nPF    [Counter]\nPF    [FROM Offset]\nPF    [TO Offset]\nP7D   [Counter Max]\nAD    [Instruction blank]\nTD    [Instruction blank]\nP2F   [Four]\n\n\n\n\n\n[Check for bit]\nT45K [H Parameter]\nP182F\n\nT160K\nGK\nA57F  [Form return address]\nU18@  [Plant Link]\nT20@  [Plant Link]\n\nT58D  [Clear acc]\nA#H   [Load bitmask]\nS4#H  [Decrement bitmask]\nG19@  [If it is -ve then exit]\n\nT58D  [Clear acc]\nA2H   [Load location]\nLD    [Shift location]\nA3H   [Add instruction]\nT13@  [Store new instruction]\nH#H   [Load bitmask]\nCD    [Instruction blank]\nS#H   [Subtract bitmask]\nG19@  [If acc is negative]\nT58F  [Else clear acc]\nA43F  [Put 1 in acc]\nEF    [Space for link]\nT58F  [Clear acc]\nEF    [Space for link]\nXF    [Spacer]\n\n[Variables]\n[Must be word aligned]\nPF    [Mask lower word]\nPF    [Mask upper word]\nPF    [Location]\nCD    [Instruction blank]\nPD    [One - double word]\nPF    [        ]\n\n[Number of Neighbours]\nT46K  [N Parameter]\nP182F [Location of working bits]\nT45K  [H Parameter]\nP264F\nT192K\nGK\nA57F  [Form return address]\nT71@  [Plant Link]\nT2H   [Clear neighbours]\nA56F  [Load two]\nT5H   [Set counter]\n\nA3H   [Load location offset]\nA4H   [Load base location]\nT2N   [Store working location]\n\n[If location >= 30]\nA3H   [Load location offset]\nS6H   [Subtract 30]\nG15@  [Else]\nT58F  [Clear acc]\nA5H   [Load counter]\nS43F  [Decrement counter]\nT5H   [Save counter]\n\n[If location <= 0]\nT58F  [Clear acc]\nA3H   [Get location offset]\nS43F  [Decrement it]\nG24@  [If we are -ve]\nT58F  [Else Clear acc]\nA2N   [Get working location]\nS56F  [Decrement by two]\nT2N   [Store it]\nE28@  [Else]\nT58F  [Clear acc]\nA5H   [Load counter]\nS43F  [Decrement counter]\nT5H   [Store counter]\n\n[To the right]\nT58D  [Clear acc]\nA#H   [Load bitmask]\nRD    [Shift to right]\nT#N   [Store it in working location]\nA32@  [Load return address]\nG160F [Find out bit value]\nA2H   [Add to neighbours]\nT2H   [Store neighbours]\n\n[In the middle]\nT58D  [Clear acc]\nA#H   [Load bitmask]\nT#N   [Store it in working location]\nA39@  [Load return address]\nG160F [Find out bit value]\nA2H   [Add to neighbours]\nT2H   [Store neighbours]\n\n[To the left]\nT58D  [Clear acc]\nA#H   [Load bitmask]\nLD    [Shift to left]\nT#N   [Store it in working location]\nA47@  [Load return address]\nG160F [Find out bit value]\nA2H   [Get neighbours]\nT2H   [Store neighbours]\n\n[Check counter]\nT58F  [Clear acc]\nA5H   [Load counter]\nS43F  [Decrement counter]\nG60@  [Break out of loop]\nT5H   [Store counter]\nA2N   [Get working location]\nA56F  [Location +=2]\nT2N   [Store location]\nE28@  [Loop back]\n\n[Make sure that we have not]\n[counted ourselves]\nT58F  [Clear acc]\nA3H   [Get location offset]\nA4H   [Get base location]\nT2N   [Store working location]\nA#H   [Load bitmask]\nT#N   [Store it in working location]\nA66@  [Load return address]\nG160F [Find out bit value]\nT5H   [Store bit value]\nA2H   [Get neighbours]\nS5H   [Subtract bit value]\nEF    [Space for link]\n\n[Variables]\nPF    [Bitmask]\nPF    [       ]\nPF    [Neighbours]\nPF    [Location offset]\nPF    [Base location]\nP1D   [Counter]\nP15F  [Thirty]\n\n\n\n\n\n\n[Alive or dead]\nT64K\nGK\nA57F  [Form return address]\nU13@  [Plant Link]\nU16@  [Plant Link]\nT20@  [Plant Link]\nA4@   [Store return address]\nG192F [Find neighbours]\n\nS56F  [Answer -= 2]\nG12@  [If -ve then 0 or 1 - die]\nS43F  [Decrement answer]\nG14@  [If -ve then 2 - no change]\nS43F  [Decrement answer]\nG17@  [If -ve then 3 - live]\n      [Else die]\nT58F  [Clear acc]\nEF    [Space for link]\nT58F  [Clear acc]\nA43F  [Set acc to one]\nEF    [Space for link]\nT58F  [Clear acc]\nA43F  [Set acc to one]\nA43F  [Set acc to two]\nEF    [Space for link]\n\n\n\n\n\n[OR Gate]\nT45K [H parameter]\nP304F\nT288K\nGK\nA57F [Form return address]\nT15@ [Plant link]\nT58D [Clear acc]\nS4#H [Get -1]\nS#H  [NOT a]\nT#H  [Store result]\nS4#H [Get -1]\nS2#H [NOT b]\nT2#H [Store result]\nH#H  [Load a into mult]\nC2#H [a AND b]\nT#H  [Store result]\nS4#H [Get -1]\nS#H  [NOT (a AND b)]\nT#H  [Store result]\nEF   [Space for link]\n[Variables]\nPF   [Number 1]\nPF   [        ]\nPF   [Number 2]\nPF   [        ]\nPD   [One - double word]\nPF  []\n\n[M3]\nPFGKIFAFRDLFUFOFE@A6FG@E8FEZPF\n@&*\n!!!!!!!!!!!!CONWAYS!LIFE@&\n!!!!!!!!!!IAN!GILLMAN!#1998*@&\n!!!!!SWITCH!CRT!TO!LONG!TANK!#0*@&\n!!!!!!!!!!!!PLEASE!WAIT@&\n!!!!!!!EACH!GENERATION!TAKES@&\n!!!!!!!ABOUT!#5*!EDSAC!MINUTES@&\n..PZ\n\n\n\n\n[Variables - Main]\nT320K\nPF   [Base location]\nP48F [Working screen location]\nP15F [Thirty]\nPF   [Current state]\nPF   [New state]\nAD   [Instruction blank]\nTD   [Instruction blank]\nP2F  [Four]\nPD   [One - double word]\nPF   [                 ]\n\n\n[Main]\nT45K  [H Parameter]\nP320F\nT46K  [N Parameter]\nP264F [Location of working bits]\nT47K  [M Parameter]\nP153F [Location of copy screen]\nT49K  [L Parameter]\nP304F [OR parameters]\n\nT48K  [& Parameter]\nP365F [Main code start]\n\nT352K\nGK\nA2F   [Load acc with location 2]\nT56F  [Store in location 56]\nA3F   [Load acc with location 3]\nT57F  [Store in location 57]\n\nAH    [Get base location]\nU4N   [Store base location]\n\nA2H   [Add thirty to base location]\nLD    [Shift left]\nT2M   [Store base location]\nA1H   [Get working location]\nA2H   [Add thirty]\nLD    [Shift left]\nT1M   [Store working location]\n\nT58F  [Clear acc]\nA1&   [Copy pattern to screen]\nG128F\n\nT58F  [Clear acc]\nA2H   [Load thirty]\nT3N   [Reset location offset]\n\nT58D  [Clear acc]\nA8#H  [Load base bitmask]\nT#N   [Set bitmask]\n\nT58D  [Clear acc]\nA1H   [Get working location]\nA3N   [Add location offset]\nLD    [Shift left]\nA5H   [Add instruction blank]\nU32&  [Store instruction]\nT44&  [Store instruction]\n\nA1H   [Get working location]\nA3N   [Add location offset]\nLD    [Shift left]\nA6H   [Add instruction blank]\nU38&  [Store instruction]\nT48&  [Store instruction]\n\nT58D  [Clear acc]\nA23&  [Live or die]\nG64F\n\nS43F  [Decrement state]\nG40&  [If -ve then die]\nS43F  [Decrement state]\nG49&  [no change]\n\n[Live]\nT58D  [Clear acc]\nA#N   [Load bitmask]\nT#L   [Store bitmask]\nAD    [Space for load instruction]\nT2#L  [Store location]\nA34&  [Load return address]\nG288F [a OR b]\nT58D  [Clear acc]\nA#L   [Get answer]\nTD    [Space for store instruction]\nE49&  [Continue]\n\n[Die]\nT58D  [Clear acc]\nS8#H  [Get -1]\nS#N   [Subtract bitmask]\nT#L   [Store result]\nAD    [Space for load instruction]\nT2#L  [Store location]\nH#L   [Put location in mult]\nC2#L  [a AND b]\nTD    [Space for store instruction]\n[46]\n\nT58D  [Clear acc]\nA#N   [Load bitmask]\nLD    [Shift left]\nU#N   [Store bitmask]\nS8#H  [Decrement bitmask]\nE22&  [Do not reset bitmask]\n\nT58D  [Clear acc]\nA32&  [Get load instruction]\nS7H   [Subtract four]\nU32&  [Store instruction]\nT44&  [Store instruction]\nA38&  [Get save instruction]\nS7H   [Subtract four]\nU38&  [Store instruction]\nT48&  [Store instruction]\n\nA3N   [Load offset]\nS56F  [Decrement by two]\nU3N   [Store offset]\nE6&   [Do not reset location offset]\n\nG&    [Reset location offset]\n\nEZPF");
        }

        /* synthetic */ 6() {
        }
    }

    private final class 7
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            new Tapes();
            Gui.this.inputGui.inputArea.setText("[Cubes]\n..PK\nT56K\n[P6]\nGKA3FT25@H29@VFT4DA3@TFH30@S6@T1F\nV4DU4DAFG26@TFTFO5FA4DF4FS4F\nL4FT4DA1FS3@G9@EFSFO31@E20@J995FJF!F\n..PZ\n[Cubes Master]\nGK\nZF\nO29@\nO30@\nO31@\nA23@\nTF\nA6@\nG56F\nT23@\nA24@\nA27@\nT24@\nS24@\nT26@\nA25@\nA28@\nU25@\nA23@\nT23@\nA26@\nA27@\nG13@\nE2@\nPD\nPD\nPD\nPF\nPD\nP1F\n#F\n@F\n&F\nEZPF");
        }

        /* synthetic */ 7() {
        }
    }

    private final class 8
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            new Tapes();
            Gui.this.inputGui.inputArea.setText("[                Edsac Mandelbrot Plotter\n                            by \n                      Jonathan Hunt\n                      January 1998\n\nThe Mandelbrot set is a set of complex numbers.  A complex\nnumber, C, is in the Mandelbrot set if, after applying\nmany iterations of the formula Z = Z*Z + C , the magnitude\nof Z is less than 2.\n\nWe can get a picture of what the Mandelbrot set looks like\nby drawing a graph where the x axis represents the real\npart of the complex number and the y axis represents the\nimaginary part.  For each position on the graph, we test\nwhether or not it satisfies the iteration test described\nabove, and if it does we colour that point black.  If it\ndoesn't, we leave it white.  If we plot thousands of\npoints in this way, we build up an image of the Mandelbrot\nset.\n\nThe Edsac Mandelbrot plotter does this job for us.  It\nuses the dots in Long tank 0 to represent the points on\nthe graph, and builds up the Mandelbrot image colouring\npoints inside the Mandelbrot set black, and points outside\nthe set white.\n\nThe initial ranges for the two axis can be changed by\nmodifying xorig, yorig, xstep and ystep at locations\n262, 264, 266 and 268 respectively.  In addition to this\nafter each frame has been completed, you can 'zoom' into\na particular part of the image by dialling the appropriate\nnumber (the program prints a key on the teleprinter so\nyou know which number corresponds to which region).]\n\n\nT64K\n[M3]\nPFGKIFAFRDLFUFOFE@A6FG@E8FEZPF           [ Print loading ]\n@&@&!!!!!!!*MANDELBROT!PLOTTER!BY        [ message using ]\n@&!!!!!!!!!!J#M*A#M*HUNT#N!#1998      [ subroutine    ]v@&@&*!!!!!!LOADING#N!*PLEASE!WAIT#MMM    [            M3 ]\n..PK\n\nT57K\nGK\nT00DT02DT04DT06D        [ Clear    ]\nT08DT10DT12DT14D        [   Long   ]\nT16DT18DT20DT22D        [     Tank ]\nT24DT26DT28DT30D        [       0  ]\n\n[073] A304F    [ \\                              ]\n[074] U126F    [  \\                             ]\n[075] T133F    [   \\                            ]\n[076] A318F    [    > Reset Self modifying code ]\n[077] T128F    [   /                            ]\n[078] A319F    [  /                             ]\n[079] T135F    [ /                              ]\n\n[080] A264D    [ \\_ b = yorig ]\n[081] T260D    [ /            ]\n[082] A289F    [ \\_ k = 15 ]\n[083] T257F    [ /         ]\n\n[084] T320D    [ (clear acc)  ]\n[085] A262D    [ \\_ a = xorig ]\n[086] T258D    [ /            ]\n[087] A290F    [ \\_ j = 34 ]\n[088] U256F    [ /         ]\n\n[089] T320D    [ (clear acc) ]\n[090] U270D    [ x = 0 ]\n[091] U272D    [ y = 0 ]\n[092] U274D    [ z = 0 ]\n[093] U280F    [ n = 0 ]\n\n[094] H270D    [ \\                ]\n[095] V270D    [  \\_ xsqr = x * x ]\n[096] L16F     [  /  <- (<<6)     ]\n[097] T276D    [ /                ]\n[098] H272D    [ \\                ]\n[099] V272D    [  \\_ ysqr = y * y ]\n[100] L16F     [  /  <- (<<6)     ]\n[101] U278D    [ /                ]\n[102] A276D    [ \\_ z = xsqr + ysqr ]\n[103] T274D    [ /                  ]\n[104] H270D    [ \\                     ]\n[105] V272D    [  \\                    ]\n[106] L32F     [   > y = 2 * x * y + b ]\n[107] A260D    [  /                    ]\n[108] T272D    [ /                     ]\n[109] A276D    [ \\                       ]\n[110] S278D    [  \\_ x = xsqr - ysqr + a ]\n[111] A258D    [  /                      ]\n[112] T270D    [ /                       ]\n[113] A280F    [ \\            ]\n[114] A288F    [  > n = n + 1 ]\n[115] T280F    [ /            ]\n\n[116] A274D    [ \\                         ]\n[117] S292D    [  > if z > 4 then goto 125 ]\n[118] E125F    [ /                         ]\n\n[119] T320D    [ (clear acc) ]\n[120] A280F    [ \\                          ]\n[121] S291F    [  > if n > 32 then goto 125 ]\n[122] E125F    [ /                          ]\n\n[123] T320D    [ \\_ goto 094 ]\n[124] E094F    [ /           ]\n\n[125] T320D    [ (clear acc) ]\n[126] A0D      [ \\                   ] [ <- SMC point ]\n[127] LD       [  > !ptr = !ptr << 1 ]\n[128] T0D      [ /                   ] [ <- SMC point ]\n\n[129] A280F    [ \\                          ]\n[130] S291F    [  > if n > 32 then goto 136 ]\n[131] E136F    [ /                          ]\n\n[132] T320D    [ (clear acc) ]\n[133] A0D      [ \\                   ] [ <- SMC point ]\n[134] A294D    [  > !ptr = !ptr + 1  ]\n[135] U0D      [ /                   ] [ <- SMC point ]\n\n[136] T320D    [ (clear acc) ]\n[137] A258D    [ \\                 ]\n[138] A266D    [  > a = a + xstep  ]\n[139] T258D    [ /                 ]\n[140] A256F    [ \\            ]\n[141] S288F    [  > j = j - 1 ]\n[142] U256F    [ /            ]\n\n[143] E089F    [ if j >= 0 then goto 089 ]\n\n[144] T320D    [ (clear acc) ]\n[145] A260D    [ \\                 ]\n[146] A268D    [  > b = b + ystep  ]\n[147] T260D    [ /                 ]\n\n[148] A126F    [ \\                                ]\n[149] A296F    [  \\                               ]\n[150] U126F    [   \\                              ]\n[151] T133F    [    \\_ ptr = ptr + 2  (Using SMC) ]\n[152] A128F    [    /                             ]\n[153] A296F    [   /                              ]\n[154] U128F    [  /                               ]\n[155] T135F    [ /                                ]\n\n[156] A257F    [ \\            ]\n[157] S288F    [  > k = k - 1 ]\n[158] U257F    [ /            ]\n\n[159] E084F    [ if k >= 0 then goto 084 ]\n\n[160] O298F O299F O298F O299F O297F [ Print out zoom ]\n      O300F O301F O301F O301F O301F [ area diagram   ]\n      O301F O301F O301F O300F O298F\n      O299F O302F O303F O311F O303F\n      O312F O303F O313F O303F O302F\n      O298F O299F O302F O303F O308F\n      O303F O309F O303F O310F O303F\n      O302F O303F O317F O314F O312F\n      O301F O315F O303F O301F O308F\n      O307F O301F O303F O309F O313F\n      O303F O300F O313F O313F O316F\n      O298F O299F O297F O302F O303F\n      O305F O303F O306F O303F O307F\n      O303F O302F O298F O299F O300F\n      O301F O301F O301F O301F O301F\n      O301F O301F O300F O298F O299F\n\n[240] T320D    [ (clear acc) ]\n[241] ZF       [ Stop and wait for input ]\n[242] U281F    [ Store input ]\n[243] S288F    [ \\_ if no input then goto 240 to ]\n[244] G240F    [ /  re-read input                ]\n[245] E328F    [ goto zoom routine ]\n\nT262K    [ Initialise xorig, yorig, xstep, and ystep ]\nPF       [ xorig = -1.75 (>>6) =                 ]\nV1152F   [                    %11111100100000000 ]\nPF       [ yorig = -1 (>>6) =                    ]\nV1536F   [                    %11111110000000000 ]\nPF       [ xstep = 17/256 (>>6) =                ]\nP34F     [                    %00000000001000100 ]\nPF       [ ystep = 1/8 (>>6) =                   ]\nP64F     [                    %00000000010000000 ]\n\nT288K    [ Start constants at location 288 ]\n[288] PD       [ Short integer  1 ]\n[289] P7D      [ Short integer 15 ]\n[290] P17F     [ Short integer 34 ]\n[291] P16F     [ Short integer 32 ]\n[292] PF       [ \\_ Fixed point 4 ]\n[   ] QF       [ /                ]\n[294] PD       [ \\_ LSB set only  ]\n[   ] PF       [ /                ]\n[296] P2F      [ Short integer  4 ]\n[297] #F       [ Number shift     ]\n[298] @F       [ Carriage Return  ]\n[299] &F       [ Line Feed        ]\n[300] ZF       [ Char Z / +       ]\n[301] AF       [ Char A / -       ]\n[302] CF       [ Char C / :       ]\n[303] !F       [ Char <Space>     ]\n[304] A0D      [ SMC constant ]\n[305] QF       [ Char Q / 1       ]\n[306] WF       [ Char W / 2       ]\n[307] EF       [ Char E / 3       ]\n[308] RF       [ Char R / 4       ]\n[309] TF       [ Char T / 5       ]\n[310] YF       [ Char Y / 6       ]\n[311] UF       [ Char U / 7       ]\n[312] IF       [ Char I / 8       ]\n[313] OF       [ Char O / 9       ]\n[314] DF       [ Char D / ;       ]\n[315] LF       [ Char L / )       ]\n[316] MF       [ Char M / .       ]\n[317] *F       [ Letter shift     ]\n[318] T0D      [ SMC constant ]\n[319] U0D      [ SMC constant ]\n\nT328K    [ Zoom routine ]\n[328] T320D    [ (clear acc) ]\n[329] A281F    [ load input into acc ]\n[330] RD       [ Divide by two to get actual value ]\n[331] S288F    [ Subtract 1 to get range 0-8 ]\n[332] S288F    [ \\_ If input was 1 goto 414 ]\n[333] G414F    [ /                          ]\n[334] S288F    [ \\_ If input was 2 goto 350 ]\n[335] G350F    [ /                          ]\n[336] S288F    [ \\_ If input was 3 goto 356 ]\n[337] G356F    [ /                          ]\n[338] S288F    [ \\_ If input was 4 goto 362 ]\n[339] G362F    [ /                          ]\n[340] S288F    [ \\_ If input was 5 goto 368 ]\n[341] G368F    [ /                          ]\n[342] S288F    [ \\_ If input was 6 goto 378 ]\n[343] G378F    [ /                          ]\n[344] S288F    [ \\_ If input was 7 goto 388 ]\n[345] G388F    [ /                          ]\n[346] S288F    [ \\_ If input was 8 goto 394 ]\n[347] G394F    [ /                          ]\n[348] S288F    [ \\_ If input was 9 goto 404 ]\n[349] G404F    [ /                          ]\n\n[350] T320D    [ Zoom area 2 ]\n[351] A266D    [ \\                             ]\n[352] L2F      [  \\_ xorig = xorig + xstep * 8 ]\n[353] A262D    [  /                            ]\n[354] T262D    [ /                             ]\n[355] E414F    [ goto 414 ]\n\n[356] T320D    [ Zoom area 3 ]\n[357] A266D    [ \\                              ]\n[358] L4F      [  \\_ xorig = xorig + xstep * 16 ]\n[359] A262D    [  /                             ]\n[360] T262D    [ /                              ]\n[361] E414F    [ goto 414 ]\n\n[362] T320D    [ Zoom area 4 ]\n[363] A268D    [ \\                             ]\n[364] L1F      [  \\_ yorig = yorig + ystep * 4 ]\n[365] A264D    [  /                            ]\n[366] T264D    [ /                             ]\n[367] E414F    [ goto 414 ]\n\n[368] T320D    [ Zoom area 5 ]\n[369] A266D    [ \\                             ]\n[370] L2F      [  \\_ xorig = xorig + xstep * 8 ]\n[371] A262D    [  /                            ]\n[372] T262D    [ /                             ]\n[373] A268D    [ \\                             ]\n[374] L1F      [  \\_ yorig = yorig + ystep * 4 ]\n[375] A264D    [  /                            ]\n[376] T264D    [ /                             ]\n[377] E414F    [ goto 414 ]\n\n[378] T320D    [ Zoom area 6 ]\n[379] A266D    [ \\                              ]\n[380] L4F      [  \\_ xorig = xorig + xstep * 16 ]\n[381] A262D    [  /                             ]\n[382] T262D    [ /                              ]\n[383] A268D    [ \\                             ]\n[384] L1F      [  \\_ yorig = yorig + ystep * 4 ]\n[385] A264D    [  /                            ]\n[386] T264D    [ /                             ]\n[387] E414F    [ goto 414 ]\n\n[388] T320D    [ Zoom area 7 ]\n[389] A268D    [ \\                             ]\n[390] L2F      [  \\_ yorig = yorig + ystep * 8 ]\n[391] A264D    [  /                            ]\n[392] T264D    [ /                             ]\n[393] E414F    [ goto 414 ]\n\n[394] T320D    [ Zoom area 8 ]\n[395] A266D    [ \\                             ]\n[396] L2F      [  \\_ xorig = xorig + xstep * 8 ]\n[397] A262D    [  /                            ]\n[398] T262D    [ /                             ]\n[399] A268D    [ \\                             ]\n[400] L2F      [  \\_ yorig = yorig + ystep * 8 ]\n[401] A264D    [  /                            ]\n[402] T264D    [ /                             ]\n[403] E414F    [ goto 414 ]\n\n[404] T320D    [ Zoom area 9 ]\n[405] A266D    [ \\                              ]\n[406] L4F      [  \\_ xorig = xorig + xstep * 16 ]\n[407] A262D    [  /                             ]\n[408] T262D    [ /                              ]\n[409] A268D    [ \\                             ]\n[410] L2F      [  \\_ yorig = yorig + ystep * 8 ]\n[411] A264D    [  /                            ]\n[412] T264D    [ /                             ]\n[413] E414F    [ goto 414 ]\n\n[414] A266D    [ \\                    ]\n[415] RD       [  > xstep = xstep / 2 ]\n[416] T266D    [ /                    ]\n[417] A268D    [ \\                    ]\n[418] RD       [  > ystep = ystep / 2 ]\n[419] T268D    [ /                    ]\n[420] E073F    [ goto 073 to plot next frame ]\n\nEZPF");
        }

        /* synthetic */ 8() {
        }
    }

    private final class 9
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            new Tapes();
            Gui.this.inputGui.inputArea.setText("[Hello World]T64KGKZFO5@O6@O7@ZF*FHFIFEZPF");
        }

        /* synthetic */ 9() {
        }
    }
}

