/*
 * Decompiled with CFR 0.152.
 */
package edsac.kernel;

import edsac.datatypes.Address;
import edsac.datatypes.LongWord;
import edsac.datatypes.ShortWord;
import java.math.BigInteger;

class Accumulator {
    long low;
    long high;
    long tmpLow;
    long tmpHigh;

    Accumulator() {
        this.clear();
    }

    ShortWord shortValue() {
        return new ShortWord((int)(this.high >> 18));
    }

    LongWord longValue() {
        return new LongWord(this.high);
    }

    void addShort(ShortWord shortWord) {
        this.high += (long)shortWord.intValue() << 18;
        this.high &= 0x7FFFFFFFFL;
    }

    void addLong(LongWord longWord) {
        this.high += longWord.longValue();
        this.high &= 0x7FFFFFFFFL;
    }

    void subShort(ShortWord shortWord) {
        this.high -= (long)shortWord.intValue() << 18;
        this.high &= 0x7FFFFFFFFL;
    }

    void subLong(LongWord longWord) {
        this.high -= longWord.longValue();
        this.high &= 0x7FFFFFFFFL;
    }

    void multAdd(LongWord longWord, LongWord longWord2) {
        this.multInternal(longWord, longWord2);
        this.low += this.tmpLow;
        this.high += this.tmpHigh;
        if ((this.low & 1L << 36) != 0L) {
            ++this.high;
        }
        this.low &= 0xFFFFFFFFFL;
        this.high &= 0x7FFFFFFFFL;
    }

    void multSub(LongWord longWord, LongWord longWord2) {
        this.multInternal(longWord, longWord2);
        this.low -= this.tmpLow;
        this.high -= this.tmpHigh;
        if ((this.low & 1L << 36) != 0L) {
            --this.high;
        }
        this.low &= 0xFFFFFFFFFL;
        this.high &= 0x7FFFFFFFFL;
    }

    private void multInternal(LongWord longWord, LongWord longWord2) {
        long l = longWord.longValue();
        long l2 = longWord2.longValue();
        boolean bl = false;
        if ((l & 1L << 34) != 0L) {
            l = (1L << 35) - l;
            boolean bl2 = bl = !bl;
        }
        if ((l2 & 1L << 34) != 0L) {
            l2 = (1L << 35) - l2;
            bl = !bl;
        }
        long l3 = l & 0xFFFFFFFFL;
        long l4 = l >>> 32;
        long l5 = l2 & 0xFFFFFFFFL;
        long l6 = l2 >>> 32;
        long l7 = l4 * l6;
        long l8 = l4 * l5;
        long l9 = l3 * l6;
        long l10 = l3 * l5;
        this.tmpLow = (l10 << 2 & 0xFFFFFFFFFL) + ((l8 & 3L) << 34) + ((l9 & 3L) << 34);
        this.tmpHigh = (l10 >>> 34) + (l8 >>> 2) + (l9 >>> 2) + (l7 << 30);
        this.tmpHigh += this.tmpLow >>> 36;
        this.tmpLow &= 0xFFFFFFFFFL;
        this.tmpHigh &= 0x3FFFFFFFFL;
        if (bl) {
            if (this.tmpLow != 0L) {
                this.tmpLow = 0x1000000000L - this.tmpLow;
                ++this.tmpHigh;
            }
            this.tmpHigh = 0x800000000L - this.tmpHigh;
        }
    }

    void shortCollate(ShortWord shortWord, LongWord longWord) {
        this.longCollate(new LongWord(shortWord), longWord);
    }

    void longCollate(LongWord longWord, LongWord longWord2) {
        this.addLong(new LongWord(longWord.longValue() & longWord2.longValue()));
    }

    void shiftLeft(Address address, boolean bl) {
        int n = address.intValue() * 2 + (bl ? 1 : 0);
        while (n != 0) {
            this.low <<= 1;
            this.high <<= 1;
            if ((this.low & 1L << 36) != 0L) {
                this.high |= 1L;
            }
            n >>= 1;
        }
        this.low &= 0xFFFFFFFFFL;
        this.high &= 0x7FFFFFFFFL;
    }

    void shiftRight(Address address, boolean bl) {
        int n = address.intValue() * 2 + (bl ? 1 : 0);
        while (n != 0) {
            if ((this.high & 1L) != 0L) {
                this.low |= 1L << 36;
            }
            this.low >>= 1;
            this.high >>= 1;
            if ((this.high & 1L << 33) != 0L) {
                this.high |= 1L << 34;
            }
            n >>= 1;
        }
    }

    boolean isPositive() {
        return (this.high & 1L << 34) == 0L;
    }

    boolean isNegative() {
        return (this.high & 1L << 34) != 0L;
    }

    void clear() {
        this.high = 0L;
        this.low = 0L;
    }

    void round() {
        if ((this.low & 1L << 35) != 0L) {
            ++this.high;
            this.low &= 1L << 35 ^ 0xFFFFFFFFFFFFFFFFL;
        } else {
            this.low |= 1L << 35;
        }
        this.low &= 0xFFFFFFFFFL;
        this.high &= 0x7FFFFFFFFL;
    }

    BigInteger bigIntValue() {
        BigInteger bigInteger = BigInteger.valueOf(this.high);
        BigInteger bigInteger2 = BigInteger.valueOf(this.low);
        bigInteger = bigInteger.shiftLeft(36);
        return bigInteger.add(bigInteger2);
    }

    double fractValue() {
        double d = this.low;
        d /= (double)(1L << 36);
        d += (double)this.high;
        if ((d /= (double)(1L << 34)) >= 1.0) {
            d -= 2.0;
        }
        return d;
    }

    public String toString() {
        return "High: " + this.high + " Low: " + this.low + " = " + this.bigIntValue().toString() + " -> " + this.fractValue();
    }
}

