/*
 * Decompiled with CFR 0.152.
 */
package edsac.datatypes;

import edsac.datatypes.Character;
import edsac.datatypes.ShortWord;

public class LongWord {
    long value;

    public LongWord() {
        this.value = 0L;
    }

    public LongWord(long l) {
        this.value = l & 0x7FFFFFFFFL;
    }

    public LongWord(Character character) {
        this.value = character.byteValue();
    }

    public LongWord(ShortWord shortWord) {
        this.value = (long)shortWord.intValue() << 18;
    }

    public long longValue() {
        return this.value;
    }

    public double fractValue() {
        long l = this.value;
        if ((l & 1L << 34) != 0L) {
            l -= 1L << 35;
        }
        return (double)l / (double)(1L << 34);
    }

    public String toString() {
        return "LongWord: longValue=" + this.value + " fractValue=" + this.fractValue();
    }
}

