#Specify number of LEDs
LEDno = 11			

#Specify Array of bus addresses in decimal: Bus 0 corresponds to address 56 and Bus 1 corresponds to address 57
Bus = [56, 57, 58]	

#Create array of LEDs
LED = []
for x in range(LEDno):
	LED.append([])
	for y in range(2):
		LED[x].append([-1, -1])

#Assign Bus and Pin number to LED, i.e. LED[LED number][colour(R=0,G=1)] = [Bus number][Pin number]
LED[0][1] = [0, 0]		#LED 0 (green) is connected to Pin 0 of Bus 0 (address 56)
LED[1][1] = [0, 1]		
LED[2][1] = [0, 2]		
LED[3][1] = [0, 3]		
LED[3][0] = [0, 4]		
LED[2][0] = [0, 5]		
LED[1][0] = [0, 6]
LED[0][0] = [0, 7]
LED[4][1] = [1, 0]
LED[5][1] = [1, 1]
LED[6][1] = [1, 2]
LED[7][1] = [1, 3]		
LED[7][0] = [1, 4]
LED[6][0] = [1, 5]
LED[5][0] = [1, 6]
LED[4][0] = [1, 7]
LED[8][1] = [2, 0]
LED[9][1] = [2, 1]
LED[10][1] = [2, 2]
LED[10][0] = [2, 5]
LED[9][0] = [2, 6]
LED[8][0] = [2, 7]

#Assign Raspberry Pi GPIO pins to switches
RunPause = 7
Continue = 11
Reset = 13

WriteErase = 12
MoveTapeLeft = 16
MoveTapeRight = 18

ProgramLEDRed = 8
ProgramLEDGreen = 10

#Sets delay between steps in seconds when running the program
RunDelay = 0.5