# Copyright (c) 2012 Matthew Kirk
# See LICENSE file for details

import time
import os.path
from plugins._sensor import Sensor

class MemorySensor(Sensor):
	can_quit = True
	no_of_measurements = 2

	def setup(self):
		self.filename = "logging"
		with open(self.filename, "w") as f:
			f.write("started")

	def wait_for_start(self):
		time.sleep(5)

	def get_data(self):
		with open("/proc/meminfo") as f:
			# Line 1 is total memory
			line1 = f.readline()
			# Line 2 is free memory
			line2 = f.readline()
		total_mem_KiB = float(line1.split()[1])
		free_mem_KiB = float(line2.split()[1])
		free_mem_kB = free_mem_KiB * 1.024
		free_mem_MB = free_mem_kB / 1000
		percent_free = (free_mem_KiB / total_mem_KiB) * 100
		return (free_mem_MB, percent_free)

	def stop_measuring(self):
		"""Stop measuring if logging file has been deleted."""
		file_exists = os.path.isfile(self.filename)
		return not file_exists

	def finished(self):
		"""Delete logging file if it still exists."""
		if os.path.isfile(self.filename):
			os.remove(self.filename)

