/*
 * Decompiled with CFR 0.152.
 */
package edsac.datatypes;

import edsac.datatypes.Address;
import edsac.datatypes.Character;
import edsac.datatypes.LongWord;

public class ShortWord {
    int value;

    public ShortWord() {
        this.value = 0;
    }

    public ShortWord(long l) {
        this.value = (int)l & 0x1FFFF;
    }

    public ShortWord(Character character) {
        this.value = character.byteValue();
    }

    public ShortWord(Character character, boolean bl) {
        this.value = character.byteValue() << 12;
    }

    public ShortWord(LongWord longWord) {
        this.value = (int)(longWord.longValue() >> 18);
    }

    public int intValue() {
        return this.value;
    }

    public Character getOpcode() {
        return new Character((byte)(this.value >> 12));
    }

    public Address getAddress() {
        return new Address(this.value >> 1);
    }

    public boolean isLongOperation() {
        return (this.value & 1) != 0;
    }

    public double fractValue() {
        int n = this.value;
        if ((n & 0x10000) != 0) {
            n -= 131072;
        }
        return (double)n / 65536.0;
    }

    public String toString() {
        return "ShortWord: intValue=" + this.value + " fractValue=" + this.fractValue() + " instructionValue=" + this.getOpcode() + " " + this.getAddress() + " " + (this.isLongOperation() ? "D" : "F");
    }

    public boolean isLong() {
        return (this.value & 1) == 1;
    }
}

