quietdec := true;
load "Process"; open Process;
load "List";    open List;
load "TextIO";  open TextIO;
load "String";  open String;
load "Int";     open Int;
val slides_in = openIn "slides.ps";
val slides_vec = tokens (fn c => c = #" ") (inputAll slides_in);
val (SOME pslides_num) = fromString(implode(rev(List.drop(rev(explode(nth(slides_vec,14))),13))));

fun writefiles n last =
 if n > last 
  then system "echo \"done\";"
  else (let val str = ("psselect -p " ^ toString n ^ " slides.ps slides/slide" ^ toString n ^ ".ps;")
        in
         (system("echo \"" ^ str ^ "\"\n");
          system str;
          writefiles (n+1) last)
        end);

quietdec := false;

writefiles 1 pslides_num;

quietdec := true;

closeIn slides_in;

val handout_body_out = openOut "../Notes/handout_body";

val prezi = false;

val form = if prezi then "1.3" else "1.0";

List.map
 (fn n =>
   output
    (handout_body_out, 
     ("\\fbox{\\includegraphics[scale=" ^ form ^ "]{../Lectures/slides/slide" 
      ^ Int.toString n 
      ^ ".ps}} \n\n")))
 (List.tabulate(pslides_num, fn n => n+1));

output(handout_body_out, "\\end{document}\n\n");

flushOut handout_body_out;
closeOut handout_body_out;

quietdec := false;
