%**********************************************************************
% lab2RGB.m
% Mapping from lab to RGB colour space using Reinhard et al. 2001
%**********************************************************************
function [ result ] = lab2RGB( array )

result = uint8(zeros((size(array))));
l = array(:,1);
a = array(:,2);
b = array(:,3);
l2 = l*0.5774 + a*0.4082 + b*0.7071;
m = l*0.5774 + a*0.4082 - b*0.7071;
s = l*0.5774 - a*0.8165;
l2 = 10.^l2;
m = 10.^m;
s = 10.^s;
R = uint8(l2*4.4679 - m*3.5873 + s*0.1193);
G = uint8(l2*-1.2186 + m*2.3809 - s*0.1624);
B = uint8(l2*0.0497 - m*0.2439 + s*1.2045);
result(:,1) = R;
result(:,2) = G;
result(:,3) = B;

end