/******************************************************************************
*                                                                             *
*   Copyright 2005 University of Cambridge Computer Laboratory.               *
*                                                                             *
*   This file is part of Nprobe.                                              *
*                                                                             *
*   Nprobe is free software; you can redistribute it and/or modify            *
*   it under the terms of the GNU General Public License as published by      *
*   the Free Software Foundation; either version 2 of the License, or         *
*   (at your option) any later version.                                       *
*                                                                             *
*   Nprobe is distributed in the hope that it will be useful,                 *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of            *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
*   GNU General Public License for more details.                              *
*                                                                             *
*   You should have received a copy of the GNU General Public License         *
*   along with Nprobe; if not, write to the Free Software                     *
*   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA *
*                                                                             *
******************************************************************************/


#include <stddef.h>
#include <string.h>

/* 
 * Return the first ocurrence of NEEDLE in HAYSTACK of length len  
 */

char *
seqstr_l(const char *haystack,  const char *needle, size_t len)
{
  const char * needle_end = strchr(needle, '\0');
  const char *haystack_end = haystack + len;
  const size_t needle_len = needle_end - needle;
  const size_t needle_last = needle_len - 1;
  const char *begin;

  if (needle_len == 0)
    return (char *) haystack;   /* ANSI 4.11.5.7, line 25.  */
  if ((size_t) (haystack_end - haystack) < needle_len)
    return NULL;

  for (begin = &haystack[needle_last]; begin < haystack_end; ++begin)
    {
      const char *n = &needle[needle_last];
      const char *h = begin;

      do
        if (*h != *n)
          goto loop;            /* continue for loop */
      while (--n >= needle && --h >= haystack);

      return (char *) h;

    loop:;
    }

  return NULL;
}

/* 
 * Return the first ocurrence of NEEDLE in HAYSTACK delimited by delim
 *
 * caution: Must be sure that delim exists in H 
 *  (not handy NULL terminated string) 
 */

char *
seqstr_d(const char *haystack,  const char *needle, char delim)
{
  const char * needle_end = strchr(needle, '\0');
  const char *haystack_end = strchr(haystack, delim);
  const size_t needle_len = needle_end - needle;
  const size_t needle_last = needle_len - 1;
  const char *begin;

  if (needle_len == 0)
    return (char *) haystack;   /* ANSI 4.11.5.7, line 25.  */
  if ((size_t) (haystack_end - haystack) < needle_len)
    return NULL;

  for (begin = &haystack[needle_last]; begin < haystack_end; ++begin)
    {
      const char *n = &needle[needle_last];
      const char *h = begin;

      do
        if (*h != *n)
          goto loop;            /* continue for loop */
      while (--n >= needle && --h >= haystack);

      return (char *) h;

    loop:;
    }

  return NULL;
}
