/******************************************************************************
*                                                                             *
*   Copyright 2005 University of Cambridge Computer Laboratory.               *
*                                                                             *
*   This file is part of Nprobe.                                              *
*                                                                             *
*   Nprobe is free software; you can redistribute it and/or modify            *
*   it under the terms of the GNU General Public License as published by      *
*   the Free Software Foundation; either version 2 of the License, or         *
*   (at your option) any later version.                                       *
*                                                                             *
*   Nprobe is distributed in the hope that it will be useful,                 *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of            *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
*   GNU General Public License for more details.                              *
*                                                                             *
*   You should have received a copy of the GNU General Public License         *
*   along with Nprobe; if not, write to the Free Software                     *
*   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA *
*                                                                             *
******************************************************************************/


#ifndef _WREAD_H_
#define _WREAD_H_


#define GET_INT(file, addr, type)      \
MACRO_BEGIN                          \
  if (fread((addr), sizeof(type), 1, (file)) != 1) \
    ERROR("fread - GET_INT");        \
MACRO_END

#define GET_STRUCT(file, addr, type)      \
MACRO_BEGIN                          \
  if (fread((addr), sizeof(type), 1, (file)) != 1) \
    ERROR("fread - GET_STRUCT");        \
MACRO_END

#define GET_STRING(file, addr)      \
MACRO_BEGIN                          \
  char *cp = (addr);                \
  do                               \
    {                         \
      *cp = fgetc(file);   \
    } while (*cp++ != '\0');               \
MACRO_END

#define GET_MEM(file, addr, len)      \
MACRO_BEGIN                          \
  if (fread((addr), (len), 1, (file)) != 1) \
    ERROR("fread - GET_MEM");        \
MACRO_END

/*
 * Control allocation of HTTP transaction chain etc.
 */

#define NO_TRANS 0		/* get TCP connection data only */
#define GET_TRANS 1		/* get transaction chain too */

#define TRANS_ALLOC_ON_FLY 0	/* one set per tcp_conn */
#define TRANS_PREALLOC 1	/* one set does for all */

#define NO_IMGBUFS 0
#define PROVIDE_IMGBUFS 1

#define NO_INDX 0
#define DO_INDX 1

void wr_error(char *msg);
long read_conn_uncompressed(struct np_file *file, tcp_conn_t *tconnp, int allocflag, int get_trans);

#if 0
static int total_for_this_file = 0; 

#define malloc(x)    \
({  total_for_this_file += x; printf("%d at %s %d total for this file %d\n", (x), __FILE__, __LINE__, total_for_this_file); \
    malloc(x);  \
  })
#endif



#ifdef SWIG

void get_transchain(struct np_file *file, tcp_conn_t *tconnp);
extern int file_open(struct np_file *file);
extern int _indx(struct np_file *file);
extern void _rewind(struct np_file *file);
extern int _seek_rec(struct np_file *file, uint32 recno);

extern void wr_error(char *msg);
extern void indx(struct np_file *file);
int read_trans(http_trans_t *tp, struct np_file *file, int client_seen, int server_seen, int allocflag);
extern long read_conn(struct np_file *file, tcp_conn_t *tconnp, int allocflag, int get_trans);
extern void report_tcp_conn(tcp_conn_t *tconnp, uint32 indx);
void dealloc_trans(tcp_conn_t *tconnp);

#endif /* ifdef SWIG */

#endif /* _WREAD_H_ */





/*
 * end wread.h 
 */
