/******************************************************************************
*                                                                             *
*   Copyright 2005 University of Cambridge Computer Laboratory.               *
*                                                                             *
*   This file is part of Nprobe.                                              *
*                                                                             *
*   Nprobe is free software; you can redistribute it and/or modify            *
*   it under the terms of the GNU General Public License as published by      *
*   the Free Software Foundation; either version 2 of the License, or         *
*   (at your option) any later version.                                       *
*                                                                             *
*   Nprobe is distributed in the hope that it will be useful,                 *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of            *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
*   GNU General Public License for more details.                              *
*                                                                             *
*   You should have received a copy of the GNU General Public License         *
*   along with Nprobe; if not, write to the Free Software                     *
*   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA *
*                                                                             *
******************************************************************************/


#include <stdio.h>
#include <ctype.h>
#include <stdlib.h>
#include <sys/param.h>
#include <string.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/socket.h>
#ifdef __alpha__
#include <sys/mbuf.h>
#endif
#include <net/route.h>
#include <net/if.h>
#include <netinet/in.h>
#include <netinet/in_systm.h>
#undef __STDC__
#include <netinet/ip.h>

#ifdef __alpha__
#include <netinet/ip_var.h>
#endif
#include <netinet/tcp.h>
#include <netinet/if_ether.h>

#include <assert.h>

#include "list.h"
#include "pkt.h"
#include "interface.h"
#include "flows.h"
//#include "service.h"
#include "http.h"
//#include "tcp_other.h"
#include "tcp.h"
#include "udp.h"
#include "service.h"
#include "tcp_other.h"
#include "udp_ns.h"
#include "udp_other.h"
#include "seq.h"

//#include "report.h"

//#ifdef PRINT_OUT
//#include "print_util.h"
//#endif

#include "output.h"
//#include "writer.h"
#include "np_file.h"
//#include "pool.h"


void 
udp_other_open_na(prec_t *pp, struct udp_conn *uconnp, int way)
{
  return;
}

void 
udp_other_close_na(prec_t *pp, struct udp_conn *uconnp, int way)
{
  return;
}

int 
udp_other_pkt_na(prec_t *pp, struct udp_conn *uconnp, int way, unsigned int tm)
{
  return 0;
}
  
void 
udp_other_dump_na(struct udp_conn *uconnp)
{
  return;
}

  
void 
udp_other_dump_summary(struct udp_conn *uconnp)
{
  int client_seen = UDP_STATE & UDP_CLIENT_SEEN;
  int server_seen = UDP_STATE & UDP_SERVER_SEEN;
  unsigned char rec_type;

  if (uconnp->flow_inner.serv_type == UDP_SERV_NFS)
    rec_type = REC_UDP_NFS;
  else if (uconnp->flow_inner.serv_type == UDP_SERV_DNS)
    rec_type = REC_UDP_DNS;
  else if (uconnp->flow_inner.serv_type == UDP_SERV_ICQ)
    rec_type = REC_UDP_ICQ;
  else 
    rec_type = REC_UDP_OTHER;

  rec_dump_start();
  udp_dump(uconnp, client_seen, server_seen);
  rec_dump_end(rec_type);
  
  return;
}

/****************************************************************************/

/*
 * Service method suite - no actions at all
 */

udp_serv_methods_t udp_other_serv_methods_na = 
  {
    udp_other_open_na,
    udp_other_pkt_na,
    udp_other_close_na,
    udp_other_dump_na
  };

/*
 * Service method suite - no actions but dump connection summary
 */

udp_serv_methods_t udp_other_serv_methods_summary = 
  {
    udp_other_open_na,
    udp_other_pkt_na,
    udp_other_close_na,
    udp_other_dump_summary
  };

/*****************************************************************************/

/*
 * Service control - no actions, no dumps, count as udp_other
 */

serv_control_t udp_other_serv_control_na = 
  {
    {
      &udp_other_serv_methods_na
    },
    {
      REC_UDP_OTHER, REC_UDP_OTHER, REC_UDP_OTHER, UDP_SERV_OTHER
    },
    &counters.TRAFF_UDP_OTHER,
    NO_DUMP
  };

/*
 * Service control - no actions, dump connection summary, count as udp_other
 */

serv_control_t udp_other_serv_control_summary = 
  {
    {
      &udp_other_serv_methods_summary
    },
    {
      REC_UDP_OTHER, REC_UDP_OTHER, REC_UDP_OTHER, UDP_SERV_OTHER
    },
    &counters.TRAFF_UDP_OTHER,
    NO_DUMP
  }; 

/*****************************************************************************/


/*
 * Service control for other recognised UDP services without service-specific 
 * udp_*.c files
 */


/* NFS */
serv_control_t udp_nfs_serv_control = 
  {
    {
      (void *)&udp_other_serv_methods_na
    },
    {
      REC_UDP_OTHER, REC_UDP_OTHER, REC_UDP_OTHER, UDP_SERV_NFS
    },
    &counters.TRAFF_UDP_NFS,
    NO_DUMP
  }; 


/* ICQ */
serv_control_t udp_icq_serv_control = 
  {
    {
      (void *)&udp_other_serv_methods_na
    },
    {
      REC_UDP_OTHER, REC_UDP_OTHER, REC_UDP_OTHER, UDP_SERV_ICQ
    },
    &counters.TRAFF_UDP_ICQ,
    NO_DUMP
  }; 



