/******************************************************************************
*                                                                             *
*   Copyright 2005 University of Cambridge Computer Laboratory.               *
*                                                                             *
*   This file is part of Nprobe.                                              *
*                                                                             *
*   Nprobe is free software; you can redistribute it and/or modify            *
*   it under the terms of the GNU General Public License as published by      *
*   the Free Software Foundation; either version 2 of the License, or         *
*   (at your option) any later version.                                       *
*                                                                             *
*   Nprobe is distributed in the hope that it will be useful,                 *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of            *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
*   GNU General Public License for more details.                              *
*                                                                             *
*   You should have received a copy of the GNU General Public License         *
*   along with Nprobe; if not, write to the Free Software                     *
*   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA *
*                                                                             *
******************************************************************************/


#include <stdio.h>

#define ULONGLONG unsigned int long

main()
{
  typedef struct pkt 
    {
      unsigned short seq;
      unsigned short len;
    } pkt_t;

  int i;
  unsigned char highseq;
  int dups = 0;
  int ooo = 0;

  ULONGLONG l;
  l = 5;
  printf ("l = %llu\n", l);
  return 0;

#if 0
  pkt_t pkts[] =
    {
      {125, 20},
      {145, 19},
      {164, 21},
      {185, 18},
      {125, 20},
      {203, 15},
      {210, 20},
      {230, 10},
      {240, 10},
      {250, 22},
      {210, 20},
      {252, 26},
	{278, 30},
	{240, 10},
	{308, 40},

	{185, 18},	
      {0, 0}
    };

  highseq = pkts[0].seq;

  printf("Packets delivered:-\n");
  for (i = 0;; i++)
    {
      if (pkts[i].seq == 0)
	break;
      printf("%hu - %hu (%hu)\n", pkts[i].seq, pkts[i].seq + pkts[i].len, pkts[i].len);
    }

  printf("\n");

  for (i = 0;; i++)
    {
      unsigned char seq = pkts[i].seq & 0xff;
      unsigned char len = pkts[i].len & 0xff;
      char d = seq - highseq;

      if (seq == 0)
	break;

      printf("%hu - %hu (%hu) ", seq, (seq + len) & 0xff, len);

      if (d == 0)		/* in order in sequence */
	{
	  highseq += len;
	  printf("- in order, no gap - highseq %hu\n", highseq);
	}
      else if (d & 0x80)	/* earlier */
	{
	  unsigned char end = seq + len;
	  unsigned char ol = end - highseq;
	  printf("- earlier");
	  if (ol & 0x80)
	    {
	      dups += len;
	      printf(", all ");
	    }
	  else
	    {
	      dups += ol;
	      highseq = seq + len;
	      printf(", overlap %hu", len - ol);
	    }
	  printf(" - highseq %hu\n", highseq);
	}
      else			/* later with a gap */
	{
	  printf("- later with a gap of %d - highseq %hu\n", d, highseq);
	}
    }
      

return;
#endif
}
