/******************************************************************************
*                                                                             *
*   Copyright 2005 University of Cambridge Computer Laboratory.               *
*                                                                             *
*   This file is part of Nprobe.                                              *
*                                                                             *
*   Nprobe is free software; you can redistribute it and/or modify            *
*   it under the terms of the GNU General Public License as published by      *
*   the Free Software Foundation; either version 2 of the License, or         *
*   (at your option) any later version.                                       *
*                                                                             *
*   Nprobe is distributed in the hope that it will be useful,                 *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of            *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
*   GNU General Public License for more details.                              *
*                                                                             *
*   You should have received a copy of the GNU General Public License         *
*   along with Nprobe; if not, write to the Free Software                     *
*   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA *
*                                                                             *
******************************************************************************/


#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <limits.h>
#include <net/route.h>
#include <net/if.h>
#include <netdb.h>
#include <netinet/in.h>
#include <netinet/in_systm.h>
#include <netinet/ip.h>
#ifdef __alpha__
#include <netinet/ip_var.h>
#endif
#include <netinet/tcp.h>

#include <unistd.h>
#include <fcntl.h>


#define MACRO_BEGIN do {
#define MACRO_END } while (0)


#define FILE_TO_BUF(filename, fd, buf, buflen, nread, err1) \
  MACRO_BEGIN \
    char errbuf[64];						\
    if (fd == -1 && (fd = open(filename, O_RDONLY)) == -1) \
      { \
        sprintf(errbuf, "open() %s", (filename)); \
        error((err1), errbuf); \
      } \
    lseek(fd, 0L, SEEK_SET);					\
    if (((nread) = read((fd), (buf), (buflen) -1)) <= 0) \
      { \
        sprintf(errbuf, "read() %s", (filename)); \
        error((err1), errbuf); \
      } \
    (buf)[(nread)] = '\0';						\
  MACRO_END

#define BUF_SZ 1024

int main()
{
  static int statfd = -1, statmfd = -1;
  int nread;
  int cpus = 0;
  char *cp;
  
  

  char buf[BUF_SZ];

  FILE_TO_BUF("/proc/cpuinfo", statfd, buf, BUF_SZ, nread, 
	      "get_mystat()");
  fprintf(stderr, "%s\n", buf);

  cp = buf;
  while ((cp = strstr(cp, "processor")) != NULL)
    {
      cp += 1;
      cpus++;
    }
  
  printf("%d cpus\n", cpus);
  
      

  return;

  
}
