
/*  -*- Mode: C;  -*- */

/******************************************************************************
*                                                                             *
*   Copyright 2005 University of Cambridge Computer Laboratory.               *
*                                                                             *
*   This file is part of Nprobe.                                              *
*                                                                             *
*   Nprobe is free software; you can redistribute it and/or modify            *
*   it under the terms of the GNU General Public License as published by      *
*   the Free Software Foundation; either version 2 of the License, or         *
*   (at your option) any later version.                                       *
*                                                                             *
*   Nprobe is distributed in the hope that it will be useful,                 *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of            *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
*   GNU General Public License for more details.                              *
*                                                                             *
*   You should have received a copy of the GNU General Public License         *
*   along with Nprobe; if not, write to the Free Software                     *
*   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA *
*                                                                             *
******************************************************************************/

#ifndef _TIMEOUTS_H_
#define _TIMEOUTS_H_

/*
 * Stuff to deal with sequencing and timing out packets
 */


#define TCP_FLOW_TIMEO_US (120*US_IN_S)	/* tcp connection timeout in us */
#define TCP_SEQ_TIMEO_US (120*US_IN_S)	/* tcp simplex flow seq. gap timeout in us */
#define BUFFS_HOLDABLE_RATIO 4          /* inverse */
#define BUFFS_HOLDABLE (FIFO_SIZE/BUFFS_HOLDABLE_RATIO) 
#define TIMEO_US_PER_FREEBUF (TCP_SEQ_TIMEO_US/BUFFS_HOLDABLE)


#define SEQ_TIMEO_US TCP_SEQ_TIMEO_US

#define UDP_FLOW_TIMEO_US (30*US_IN_S)	/* tcp connection timeout in us */


#ifndef _COUNTERS_C_
/*
 * timeouts.c
 */

void timeo_queues_init(void);
void seq_timeo_q_init(void);
void seq_timeo_q_insert(tcp_heldpkt_t *hpp);
void seq_timeo_q_rem(tcp_heldpkt_t *hpp);
void check_seq_timeo(us_clock_t time_now);
void check_timeouts(us_clock_t time_now);

extern listhdr_t tcp_conn_timeo_q;
extern listhdr_t udp_conn_timeo_q;
extern listhdr_t seq_timeo_q;
extern us_clock_t started_us;

extern unsigned int tcp_flo_timeo;
extern unsigned int udp_flo_timeo;
extern unsigned int sto;
extern unsigned int sto_f;
extern unsigned int sto_q;
extern unsigned int sto_a;

#endif /* ifndef _COUNTERS_C_ */


#endif /* _TIMEOUTS_H_ */


/*
 * end timeouts.h
 */
