/*  -*- Mode: C;  -*- */

/******************************************************************************
*                                                                             *
*   Copyright 2005 University of Cambridge Computer Laboratory.               *
*                                                                             *
*   This file is part of Nprobe.                                              *
*                                                                             *
*   Nprobe is free software; you can redistribute it and/or modify            *
*   it under the terms of the GNU General Public License as published by      *
*   the Free Software Foundation; either version 2 of the License, or         *
*   (at your option) any later version.                                       *
*                                                                             *
*   Nprobe is distributed in the hope that it will be useful,                 *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of            *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
*   GNU General Public License for more details.                              *
*                                                                             *
*   You should have received a copy of the GNU General Public License         *
*   along with Nprobe; if not, write to the Free Software                     *
*   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA *
*                                                                             *
******************************************************************************/

#include <stdio.h>
#include <ctype.h>
#include <stdlib.h>
#include <sys/param.h>
#include <string.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/socket.h>
#ifdef __alpha__
#include <sys/mbuf.h>
#endif
#include <net/route.h>
#include <net/if.h>
#include <netinet/in.h>
#include <netinet/in_systm.h>
#undef __STDC__
#include <netinet/ip.h>

#ifdef __alpha__
#include <netinet/ip_var.h>
#endif
#include <netinet/tcp.h>
#include <netinet/if_ether.h>

#include <assert.h>

#include "list.h"
#include "pkt.h"
#include "interface.h"
#include "flows.h"
#include "http.h"
//#include "tcp_other.h"
#include "tcp.h"
#include "udp.h"
#include "service.h"
#include "udp_ns.h"
#include "seq.h"
#include "report.h"

#ifdef PRINT_OUT
#include "print_util.h"
#endif

#include "output.h"
#include "if_nprobe.h"
#include "writer.h"
#include "pool.h"


void 
tcp_rtsp_open(prec_t *pp, struct tcp_conn *tconnp, int way, unsigned char flags)
{
  return;
}

void 
tcp_rtsp_close(prec_t *pp, struct tcp_conn *tconnp, int way, unsigned char flags)
{
  return;
}

int 
tcp_rtsp_pkt(prec_t *pp, struct tcp_conn *tconnp, int way)
{
#if 0
  unsigned int atmdata = 
    (way == CLIENT ? tconnp->flow_common.inner.src_atmdata 
     : tconnp->flow_common.inner.dst_atmdata);
  pkt_dump(pp, INTERESTING_RTSP_PKT, NULL, atmdata);
#endif
  return 0;
}


int 
tcp_rtsp_sync(struct tcp_heldpkt *hpp, struct tcp_conn *tconnp, 
		 struct tcp_simplex_flow *tsp, unsigned int gap, int way, 
	      unsigned int tm)
{
  return 1;
}
  
void 
tcp_rtsp_dump(struct tcp_conn *tconnp)
{
  int client_seen = TCP_STATE & TCP_CLIENT_SEEN;
  int server_seen = TCP_STATE & TCP_SERVER_SEEN;

  rec_dump_start();
  /* tcp part */
  tcp_dump(tconnp, client_seen, server_seen);
  rec_dump_end(REC_TCP_RTSP);
  
  return;
}

tcp_serv_methods_t tcp_rtsp_serv_methods = 
{
  tcp_rtsp_open,
  tcp_rtsp_pkt,
  tcp_rtsp_sync,
  tcp_rtsp_close,
  tcp_rtsp_dump
};

serv_control_t tcp_rtsp_serv_control = 
  {
    {
      &tcp_rtsp_serv_methods
    },
    {
      REC_TCP_RTSP_OPEN, REC_TCP_RTSP_HDRS, REC_TCP_RTSP, TCP_SERV_RTSP
    },
    &counters.TRAFF_TCP_RTSP,
    NO_DUMP
  }; 


void 
tcp_pnm_open(prec_t *pp, struct tcp_conn *tconnp, int way, unsigned char flags)
{
  return;
}

void 
tcp_pnm_close(prec_t *pp, struct tcp_conn *tconnp, int way, unsigned char flags)
{
  return;
}

int 
tcp_pnm_pkt(prec_t *pp, struct tcp_conn *tconnp, int way)
{ 
#if 0
  unsigned int atmdata = 
    (way == CLIENT ? tconnp->flow_common.inner.src_atmdata 
     : tconnp->flow_common.inner.dst_atmdata);
  pkt_dump(pp, INTERESTING_PNM_PKT, NULL, atmdata);
#endif
  return 0;
}


int 
tcp_pnm_sync(struct tcp_heldpkt *hpp, struct tcp_conn *tconnp, 
	     struct tcp_simplex_flow *tsp, unsigned int gap, int way, 
	     unsigned int tm)
{
  return 1;
}
  
void 
tcp_pnm_dump(struct tcp_conn *tconnp)
{
  int client_seen = TCP_STATE & TCP_CLIENT_SEEN;
  int server_seen = TCP_STATE & TCP_SERVER_SEEN;

  rec_dump_start();
  /* tcp part */
  tcp_dump(tconnp, client_seen, server_seen);
  rec_dump_end(REC_TCP_PNM);
  
  return;
}

tcp_serv_methods_t tcp_pnm_serv_methods = 
{
  tcp_pnm_open,
  tcp_pnm_pkt,
  tcp_pnm_sync,
  tcp_pnm_close,
  tcp_pnm_dump
};

serv_control_t tcp_pnm_serv_control = 
  {
    {
      &tcp_pnm_serv_methods
    },
    {
      REC_TCP_PNM_OPEN, REC_TCP_PNM_HDRS, REC_TCP_PNM, TCP_SERV_PNM
    },
    &counters.TRAFF_TCP_PNM,
    NO_DUMP
  }; 
