/******************************************************************************
*                                                                             *
*   Copyright 2005 University of Cambridge Computer Laboratory.               *
*                                                                             *
*   This file is part of Nprobe.                                              *
*                                                                             *
*   Nprobe is free software; you can redistribute it and/or modify            *
*   it under the terms of the GNU General Public License as published by      *
*   the Free Software Foundation; either version 2 of the License, or         *
*   (at your option) any later version.                                       *
*                                                                             *
*   Nprobe is distributed in the hope that it will be useful,                 *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of            *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
*   GNU General Public License for more details.                              *
*                                                                             *
*   You should have received a copy of the GNU General Public License         *
*   along with Nprobe; if not, write to the Free Software                     *
*   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA *
*                                                                             *
******************************************************************************/


#ifndef _SK98_CLK_H_
#define _SK98_CLK_H_


// clock calculation
typedef struct {

    int mode;     // 0: not yet started
                  // 1: finding intercept
                  // 2: constant output
                  // 3: finished

    unsigned long drift_period;
    unsigned long nictstamp_freq;

    int chan;

    // next time for initial checking
    unsigned long nextdrift;
    unsigned int binned;

    // base time; ie at tic_base tics, the time actually was time_base
    struct timeval time_base;
    unsigned long long tic_base;

    // current cumulative tics
    unsigned long long tic_cur;
    unsigned long long tic_last;

    // stats to get time intercept & gradient
    unsigned int samples;
    double sum;    // sum of diff
    double sum2;   // sum of diff*diff
    double tsum;   // sum of time
    double tsum2;  // sum of time*time
    double psum;   // sum of time*diff (product sum)
    double min;    // min(diff)
    double max;    // max(diff)

} sk98_clk_t;


int sk98_start_clock(int chan);
inline unsigned long long sk98_maptotimeofday( unsigned int nictstamp);



#endif // _SK98_CLK_H
