/*  -*- Mode: C;  -*- */

/******************************************************************************
*                                                                             *
*   Copyright 2005 University of Cambridge Computer Laboratory.               *
*                                                                             *
*   This file is part of Nprobe.                                              *
*                                                                             *
*   Nprobe is free software; you can redistribute it and/or modify            *
*   it under the terms of the GNU General Public License as published by      *
*   the Free Software Foundation; either version 2 of the License, or         *
*   (at your option) any later version.                                       *
*                                                                             *
*   Nprobe is distributed in the hope that it will be useful,                 *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of            *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
*   GNU General Public License for more details.                              *
*                                                                             *
*   You should have received a copy of the GNU General Public License         *
*   along with Nprobe; if not, write to the Free Software                     *
*   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA *
*                                                                             *
******************************************************************************/

#ifndef _REPORT_H_
#define _REPORT_H_


/* 
 * Size of tmp buf for uncompressed report output - 
 * **MUST** keep up to date with changes to tcp_dump()
 */

#define REP_TMPBUF_SZ (2*sizeof(unsigned short) \
		       + 10*sizeof(unsigned int) \
		       + 2*sizeof(tcp_simplex_flow_t) \
		       + MAX_NTRANS    \
		          *(3*sizeof(unsigned char)      \
			  + 1*sizeof(unsigned short) \
		          + 0*sizeof(unsigned int) \
			  + 2*sizeof(http_transinf_t)  \
			  + 2*(HTTP_REQSTR_LEN+1)        \
			  + 2 *sizeof(us_clock_t)   \
			  + 1 *sizeof(http_imagechars_len_t) \
			  + 1 *(HTTP_IMAGECHARS_LEN + 2)))



#if defined FINAL_REPORT || defined REPORT

extern int report;
void final_report(listhdr_t *htbl);


#ifdef REPORT
void report_tcp_close(tcp_conn_t *tconnp);
#endif

#endif

#ifdef BIN_REPORT

/* tcp.c */
void tcp_dump(struct tcp_conn *tconnp, int client_seen, int server_seen);

#endif


#ifdef WREAD
void report_tcp_conn(FILE *f, tcp_conn_t *tconnp, unsigned int indx, int print_hdrs);
void report_tcp_open(tcp_open_t *flow, us_clock_t tm, unsigned int indx);
void report_tcp_hdrs(tcp_hdrs_t *hdrs, unsigned int indx);
void print_trans(FILE *f, http_trans_t *tp, int indx, 
		 int client_seen, int server_seen, 
		 unsigned int addit_fields, us_clock_t start);
void report_udp_conn(udp_conn_t *uconnp, unsigned int indx);
void report_buf_alloc_fail(sk_buff_alloc_fail_rec_t *rec, int indx);
void report_nic_fail(net_device_stats_t *rec, int indx);
void report_period_report(period_report_t *prep, int indx, counters_t *ctrs, int why);
void report_rusage(np_rusage_t *ru, int indx, int show_stamp);
void report_interesting(flow_inner_t *flowp, int way, char *s, int indx);
void report_procstats(procstat_rec_t *prp, int ncpus, int hz, 
		      int pgsz, int indx);

void report_wrapper(wrapper_record_t *wrapper, int indx);
void report_call_times(call_times_t *ct, int indx);

void report_ns(ns_fullrec_t *np);
void report_icmp(struct icmp_rec *ip, int indx);
#endif


#endif /* _REPORT_H_ */

/*
 * end report.h 
 */
